/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.ReceivingInformationDto;
import com.byh.outpatient.api.model.ReceivingInformationEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.data.repository.ReceivingInformationMapper;
import com.byh.outpatient.web.service.ReceivingInformationService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReceivingInformationServiceImpl
implements ReceivingInformationService {
    @Autowired
    ReceivingInformationMapper receivingInformationMapper;

    public ResponseData saveReceivingInformation(ReceivingInformationEntity entity) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeStr = format.format(new Date());
        entity.setCreateTime(timeStr);
        int insert = this.receivingInformationMapper.insert((Object)entity);
        return ResponseData.success();
    }

    public ResponseData delReceivingInformation(ReceivingInformationEntity entity) {
        Integer id = entity.getId();
        if (id == null) {
            return ResponseData.error((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int i = this.receivingInformationMapper.deleteById((Serializable)entity.getId());
        return ResponseData.success();
    }

    public ResponseData editReceivingInformation(ReceivingInformationEntity entity) {
        Integer id = entity.getId();
        if (id == null) {
            return ResponseData.error((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int i = this.receivingInformationMapper.updateById((Object)entity);
        return ResponseData.success();
    }

    public ResponseData<PageInfo<ReceivingInformationEntity>> receivingInformationList(ReceivingInformationDto dto) {
        String startTime = dto.getStartTime();
        String endTime = dto.getEndTime();
        if (startTime == null || !startTime.equals("")) {
            // empty if block
        }
        PageHelper.startPage((int)dto.getCurrent(), (int)dto.getSize());
        List receivingInformationEntities = this.receivingInformationMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().like(ReceivingInformationEntity::getBuyerName, (Object)dto.getBuyerName())).ge(dto.getStartTime() != null, ReceivingInformationEntity::getCreateTime, (Object)dto.getStartTime())).le(dto.getEndTime() != null, ReceivingInformationEntity::getCreateTime, (Object)dto.getEndTime()));
        PageInfo pageInfo = new PageInfo(receivingInformationEntities);
        return ResponseData.success((Object)pageInfo);
    }

    public ResponseData<ReceivingInformationEntity> searchReceivingInformationById(ReceivingInformationEntity entity) {
        Integer id = entity.getId();
        if (id == null) {
            return ResponseData.error((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ReceivingInformationEntity receivingInformationEntity = (ReceivingInformationEntity)this.receivingInformationMapper.selectById((Serializable)entity.getId());
        return ResponseData.success((Object)receivingInformationEntity);
    }

    public ResponseData<List<ReceivingInformationEntity>> searchReceivingInformationByPatientId(ReceivingInformationEntity entity) {
        Integer id = entity.getPatientId();
        if (id == null) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List receivingInformationEntity = this.receivingInformationMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(id != null, ReceivingInformationEntity::getPatientId, (Object)id));
        return ResponseData.success((Object)receivingInformationEntity);
    }
}

