/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.byh.outpatient.api.model.OutEtubePatientInfoEntity;
import com.byh.outpatient.api.model.OutFollowUpTasksEntity;
import com.byh.outpatient.api.model.OutFollowUpTasksVo;
import com.byh.outpatient.api.sysModel.request.SysDrugEntity;
import com.byh.outpatient.api.vo.TaskByDispense;
import com.byh.outpatient.api.vo.TaskByDrugVo;
import com.byh.outpatient.api.vo.TaskByPatientVo;
import com.byh.outpatient.api.vo.prescription.WesternMedicineDrugsVo;
import com.byh.outpatient.data.repository.OutEtubePatientInfoMapper;
import com.byh.outpatient.data.repository.OutFollowUpTasksMapper;
import com.byh.outpatient.web.service.OutEtubePatientInfoService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class OutEtubePatientInfoServiceImpl
implements OutEtubePatientInfoService {
    @Resource
    private OutEtubePatientInfoMapper outEtubePatientInfoMapper;
    @Resource
    private OutFollowUpTasksMapper outFollowUpTasksMapper;

    public void outEtubePatientInfoSave(OutEtubePatientInfoEntity entity) {
        int a = this.outEtubePatientInfoMapper.outEtubePatientInfoSave(entity);
    }

    public List<OutEtubePatientInfoEntity> outEtubePatientInfoSelect(OutEtubePatientInfoEntity entity) {
        List list = this.outEtubePatientInfoMapper.outEtubePatientInfoSelect(entity);
        return list;
    }

    public void outEtubePatientInfoUpdate(OutEtubePatientInfoEntity entity) {
        int a = this.outEtubePatientInfoMapper.outEtubePatientInfoUpdate(entity);
    }

    public void outEtubePatientInfoDelete(OutEtubePatientInfoEntity entity) {
        int a = this.outEtubePatientInfoMapper.outEtubePatientInfoDelete(entity);
    }

    public PageInfo<SysDrugEntity> queryDrugRecordByPatient(OutEtubePatientInfoEntity entity) {
        PageHelper.startPage((int)entity.getCurrent(), (int)entity.getSize());
        List list = this.outEtubePatientInfoMapper.queryDrugRecordByPatient(entity.getPatientId() + "");
        PageInfo page = new PageInfo(list);
        return page;
    }

    public List<String> queryDiagnosisByPatient(OutEtubePatientInfoEntity entity) {
        List list = this.outEtubePatientInfoMapper.queryDiagnosisByPatient(entity.getPatientId() + "");
        return list;
    }

    public List<String> queryTreatmentByPatient(OutEtubePatientInfoEntity entity) {
        List list = this.outEtubePatientInfoMapper.queryTreatmentByPatient(entity.getPatientId() + "");
        return list;
    }

    public List<OutFollowUpTasksVo> queryDrugDay(OutFollowUpTasksEntity entity) throws ParseException {
        List outFollowUpTasksVos = this.outEtubePatientInfoMapper.queryTaskDetail(entity);
        if (outFollowUpTasksVos.size() > 0) {
            OutFollowUpTasksVo outFollowUpTasksVo = (OutFollowUpTasksVo)outFollowUpTasksVos.get(0);
            List drugList = outFollowUpTasksVo.getDrugList();
            Integer id = entity.getId();
            if (id == null) {
                entity.setId(outFollowUpTasksVo.getId());
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            List taskByPatientVos = this.outFollowUpTasksMapper.queryDispenseDateByTaskDetail(entity);
            ArrayList list = new ArrayList();
            for (TaskByPatientVo taskByPatientVo : taskByPatientVos) {
                for (TaskByDrugVo drugVo : taskByPatientVo.getDrugVos()) {
                    String voDrugNo = drugVo.getDrugNo();
                    for (WesternMedicineDrugsVo westernMedicineDrugsVo : drugList) {
                        String drugNo = westernMedicineDrugsVo.getDrugNo();
                        if (!voDrugNo.equals(drugNo)) continue;
                        List dispenseList = drugVo.getDispenseList();
                        String dispenseDate = null;
                        String followUpDate = null;
                        Integer medicationDays = 0;
                        String remark = null;
                        for (int i = 0; i < dispenseList.size(); ++i) {
                            long followUpDateL;
                            TaskByDispense taskByDispense = (TaskByDispense)dispenseList.get(i);
                            String voDispenseDateTime = taskByDispense.getDispenseDateTime();
                            String voFollowUpDate = taskByDispense.getFollowUpDate();
                            Integer voMedicationDays = taskByDispense.getMedicationDays();
                            if (dispenseDate == null) {
                                dispenseDate = voDispenseDateTime;
                                followUpDate = voFollowUpDate.substring(0, 10);
                                medicationDays = voMedicationDays;
                                break;
                            }
                            long dspenseDateL = format.parse(dispenseDate).getTime();
                            if (dspenseDateL > (followUpDateL = format.parse(voFollowUpDate).getTime())) break;
                            medicationDays = medicationDays + taskByDispense.getMedicationDays();
                            dispenseDate = voDispenseDateTime;
                            calendar.setTime(format.parse(voDispenseDateTime));
                            calendar.add(5, medicationDays);
                            followUpDate = format.format(calendar.getTime());
                            remark = "\u6b64\u836f\u6709" + (i + 1) + "\u6761\u6570\u636e\u5728\u7528\u836f\u65f6\u95f4\u7ed3\u675f\u524d\u518d\u6b21\u8d2d\u836f\uff0c\u5df2\u6839\u636e\u7528\u836f\u5929\u6570\u5185\u91cd\u5408\u7684\u65f6\u95f4\u7d2f\u52a0\u8ba1\u7b97\u7528\u836f\u7ed3\u675f\u65f6\u95f4";
                        }
                        if (!StringUtils.isNotBlank(followUpDate)) continue;
                        westernMedicineDrugsVo.setDispenseDateTime(dispenseDate);
                        westernMedicineDrugsVo.setEndTime(followUpDate);
                        westernMedicineDrugsVo.setRemark(remark);
                        westernMedicineDrugsVo.setTotalMedicationDays(medicationDays + "");
                    }
                }
            }
        }
        return outFollowUpTasksVos;
    }
}

