/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.text.StrBuilder;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.byh.outpatient.api.dto.wms.WmsInterface01Dto;
import com.byh.outpatient.api.dto.wms.WmsInterfaceOrderDetailDto;
import com.byh.outpatient.api.dto.wms.WmsInterfaceOrderNoDto;
import com.byh.outpatient.api.dto.wms.WmsInterfaceOrdrDto;
import com.byh.outpatient.api.model.HttpLogEntity;
import com.byh.outpatient.api.model.SysDrugNumberRelationEntity;
import com.byh.outpatient.api.model.prescription.OutPrescriptionDrug;
import com.byh.outpatient.api.model.prescription.OutTisanePrescription;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.data.repository.HttpLogMapper;
import com.byh.outpatient.data.repository.SysDrugNumberRelationMapper;
import com.byh.outpatient.data.repository.SysParamMapper;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.WmsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class WmsServiceImpl
implements WmsService {
    private static final Logger log = LoggerFactory.getLogger(WmsServiceImpl.class);
    private static final String SHANG_PIN_PREFIX = "ZKYY002";
    private static final String CARGO_OWNER_NAME = "(\u5357\u660c\u4f17\u5eb7\u533b\u9662)";
    @Resource
    private SysParamMapper sysParamMapper;
    @Autowired
    private CommonRequest commonRequest;
    @Resource
    private HttpLogMapper httpLogMapper;
    @Autowired
    private SysDrugNumberRelationMapper sysDrugNumberRelationMapper;

    public void placeOrderAdd(List<OutTisanePrescription> dto) {
        for (OutTisanePrescription outTisanePrescription : dto) {
            String value = this.sysParamMapper.selectByNameReturnValue("wms_url", this.commonRequest.getTenant());
            JSONObject json = JSONObject.parseObject((String)value);
            String url = json.get((Object)"ADD_PRODUCT").toString();
            ArrayList list = new ArrayList();
            outTisanePrescription.getDrugList().forEach(item -> {
                WmsInterface01Dto entry = new WmsInterface01Dto();
                entry.setShangp_id(SHANG_PIN_PREFIX + item.getDrugNo());
                entry.setShangp_no(SHANG_PIN_PREFIX + item.getInternalCode());
                entry.setChinese_name(item.getDrugName());
                entry.setPackages(item.getSpecification());
                entry.setUnit(item.getQuantityUnit());
                List relations = this.sysDrugNumberRelationMapper.selectRelation(item.getThirdCode(), this.commonRequest.getTenant());
                ExceptionUtils.createException((Logger)log, (boolean)relations.isEmpty(), (String)"500", (String)("\u4e09\u65b9\u7f16\u7801\uff1a\u3010" + item.getThirdCode() + "\u3011\u672a\u5728sys_drug_number_relation\u8868\u4e2d\u67e5\u627e\u5230\u300a\u888b/\u4e2a -> \u4ef6\u300b\u7684\u5bf9\u5e94\u5173\u7cfb"));
                entry.setBaoz_num(new BigDecimal(((SysDrugNumberRelationEntity)relations.get(0)).getNumber()));
                list.add(entry);
            });
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            JSONArray jsonArray = new JSONArray();
            for (WmsInterface01Dto dto1 : list) {
                JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dto1), JSONObject.class);
                jsonObject.put("package", (Object)dto1.getPackages());
                jsonArray.add((Object)jsonObject);
            }
            params.add((Object)"content", (Object)JSONObject.toJSONString(list));
            JSONObject returnJson = JSONObject.parseObject((String)this.send(url, (MultiValueMap)params));
            String result = returnJson.get((Object)"result").toString();
            ExceptionUtils.createException((Logger)log, (boolean)"0".equals(result), (String)ResponseData.ResponseEnum.SERVICE_ERROR.getCode(), (String)(null == returnJson.get((Object)"msg") ? "" : returnJson.get((Object)"msg").toString()));
        }
    }

    public void syncOrderNo(MultiValueMap<String, String> param) {
        String value = this.sysParamMapper.selectByNameReturnValue("wms_url", this.commonRequest.getTenant());
        JSONObject json = JSONObject.parseObject((String)value);
        String url = json.get((Object)"SYNC_ORDER_NO").toString();
        List orders = (List)param.get((Object)"WaybillList");
        List orderDetails = (List)param.get((Object)"WaybillDetailList");
        List orderDtos = JSONArray.parseArray((String)((String)orders.get(0)), WmsInterfaceOrdrDto.class);
        Map<String, List<WmsInterfaceOrdrDto>> orderMap = orderDtos.stream().collect(Collectors.groupingBy(WmsInterfaceOrdrDto::getOrd_id));
        ArrayList<WmsInterfaceOrderNoDto> list = new ArrayList<WmsInterfaceOrderNoDto>();
        List detailDtos = JSONArray.parseArray((String)((String)orderDetails.get(0)), WmsInterfaceOrderDetailDto.class);
        for (WmsInterfaceOrderDetailDto detailDto : detailDtos) {
            WmsInterfaceOrderNoDto orderNoDto = new WmsInterfaceOrderNoDto();
            List<WmsInterfaceOrdrDto> wmsInterfaceOrdrDtos = orderMap.get(detailDto.getOrd_id());
            ExceptionUtils.createException((Logger)log, (boolean)wmsInterfaceOrdrDtos.isEmpty(), (String)"500", (String)("\u3010" + detailDto.getOrd_id() + "\u3011\u8ba2\u5355id\u672a\u627e\u5230"));
            orderNoDto.setSalesid(wmsInterfaceOrdrDtos.get(0).getHeadord_id());
            orderNoDto.setOrd_id(detailDto.getOrd_id());
            orderNoDto.setShangp_id(detailDto.getShangp_id());
            orderNoDto.setSalesdtlid(detailDto.getSonord_id());
            orderNoDto.setTotal(detailDto.getTotal());
            orderNoDto.setWeight(detailDto.getWeight());
            orderNoDto.setVolume(detailDto.getVolume());
            orderNoDto.setSmallcode(UUIDUtils.getRandom((int)6, (boolean)true));
            list.add(orderNoDto);
        }
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"SmallcodeList", (Object)JSONObject.toJSONString(list));
        JSONObject returnJson = JSONObject.parseObject((String)this.send(url, (MultiValueMap)params));
        String result = returnJson.get((Object)"result").toString();
        ExceptionUtils.createException((Logger)log, (boolean)"0".equals(result), (String)ResponseData.ResponseEnum.SERVICE_ERROR.getCode(), (String)(null == returnJson.get((Object)"msg") ? "" : returnJson.get((Object)"msg").toString()));
    }

    public MultiValueMap<String, String> syncOrder(List<OutTisanePrescription> dto) {
        String id = UUIDUtils.getRandom((int)6, (boolean)true) + "-1";
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params = this.setOrderValue(id, dto, (MultiValueMap)params);
        String value = this.sysParamMapper.selectByNameReturnValue("wms_url", this.commonRequest.getTenant());
        JSONObject json = JSONObject.parseObject((String)value);
        String url = json.get((Object)"SYNC_ORDER").toString();
        String response = this.send(url, (MultiValueMap)params);
        JSONObject returnJson = JSONObject.parseObject((String)response);
        String result = returnJson.get((Object)"result").toString();
        ExceptionUtils.createException((Logger)log, (boolean)"0".equals(result), (String)ResponseData.ResponseEnum.SERVICE_ERROR.getCode(), (String)(null == returnJson.get((Object)"msg") ? "" : returnJson.get((Object)"msg").toString()));
        return params;
    }

    private MultiValueMap<String, String> setOrderValue(String id, List<OutTisanePrescription> list, MultiValueMap<String, String> params) {
        ArrayList orderDtos = new ArrayList();
        ArrayList orderDetailDtos = new ArrayList();
        list.forEach(item -> {
            WmsInterfaceOrdrDto orderDto = new WmsInterfaceOrdrDto();
            orderDto.setHeadord_id(UUIDUtils.getRandom((int)6, (boolean)true));
            orderDto.setCentername(item.getRoute());
            orderDto.setOrd_id(id);
            orderDto.setS_customerId(this.commonRequest.getTenant().toString());
            orderDto.setR_customerId(item.getPatientId());
            orderDto.setR_co_name(CARGO_OWNER_NAME + item.getPatientName());
            orderDto.setR_mobile(item.getDtbphone());
            orderDto.setR_name(item.getPatientName());
            orderDto.setR_addr(item.getContactsAddressDetail());
            String[] s = item.getContactsAddress().split(" ");
            for (int i = 0; i < s.length; ++i) {
                if (i == 0) {
                    orderDto.setR_province(s[i]);
                    continue;
                }
                if (i == 1) {
                    orderDto.setR_city(s[i]);
                    continue;
                }
                if (i != 2) continue;
                orderDto.setR_area(s[i]);
            }
            orderDto.setCreate_time(DateUtils.dateFormat((Date)new Date(), (String)"YYYY-MM-dd"));
            List detailDtos = this.setOrderDetailValue(id, item.getDrugList(), orderDetailDtos);
            orderDto.setVolumn(detailDtos.stream().map(WmsInterfaceOrderDetailDto::getVolume).reduce(BigDecimal.ZERO, BigDecimal::add));
            orderDto.setWeight(detailDtos.stream().map(WmsInterfaceOrderDetailDto::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add));
            orderDto.setTotal(detailDtos.stream().map(WmsInterfaceOrderDetailDto::getTotal).reduce(BigDecimal.ZERO, BigDecimal::add));
            orderDtos.add(orderDto);
        });
        params.add((Object)"WaybillList", (Object)JSONObject.toJSONString(orderDtos));
        JSONArray jsonArray = new JSONArray();
        for (WmsInterfaceOrderDetailDto orderDetailDto : orderDetailDtos) {
            JSONObject json = (JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderDetailDto), JSONObject.class);
            json.put("package", (Object)orderDetailDto.getPackages());
            jsonArray.add((Object)json);
        }
        params.add((Object)"WaybillDetailList", (Object)jsonArray.toJSONString());
        return params;
    }

    private List<WmsInterfaceOrderDetailDto> setOrderDetailValue(String id, List<OutPrescriptionDrug> drugList, List<WmsInterfaceOrderDetailDto> list) {
        drugList.forEach(item -> {
            WmsInterfaceOrderDetailDto dto = new WmsInterfaceOrderDetailDto();
            StrBuilder builder = new StrBuilder(new CharSequence[]{""});
            dto.setOrd_id(id);
            dto.setShangp_id(SHANG_PIN_PREFIX + item.getDrugNo());
            dto.setGoods_name(item.getDrugName());
            dto.setTotal(BigDecimal.ZERO);
            dto.setSonord_id(UUIDUtils.getRandom((int)6, (boolean)true));
            dto.setPackages(item.getSpecification());
            List relations = this.sysDrugNumberRelationMapper.selectRelation(item.getThirdCode(), this.commonRequest.getTenant());
            ExceptionUtils.createException((Logger)log, (boolean)relations.isEmpty(), (String)"500", (String)("\u4e09\u65b9\u7f16\u7801\uff1a\u3010" + item.getThirdCode() + "\u3011\u672a\u5728sys_drug_number_relation\u8868\u4e2d\u67e5\u627e\u5230\u300a\u888b/\u4e2a -> \u4ef6\u300b\u7684\u5bf9\u5e94\u5173\u7cfb"));
            SysDrugNumberRelationEntity relation = (SysDrugNumberRelationEntity)relations.get(0);
            for (Map map : item.getBatchNumberList()) {
                String batchNumber = map.get("batchNumber").toString();
                builder.append((CharSequence)batchNumber).append((CharSequence)",");
                dto.setTotal(dto.getTotal().add(new BigDecimal(map.get("actualInventory").toString()).divide(new BigDecimal(relation.getNumber()))));
            }
            dto.setWeight(dto.getTotal().multiply(dto.getWeight()));
            dto.setVolume(dto.getTotal().multiply(dto.getVolume()));
            String batchNumber = builder.toString();
            batchNumber = batchNumber.substring(0, batchNumber.length() - 1);
            dto.setBatchno(batchNumber);
            list.add(dto);
        });
        return list;
    }

    public String send(String url, MultiValueMap<String, String> params) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
        HttpLogEntity entity = new HttpLogEntity();
        entity.setUrl(url);
        entity.setParam(JSONObject.toJSONString((Object)requestEntity).replace("\\", ""));
        entity.setCreatId(this.commonRequest.getUserId().toString());
        this.httpLogMapper.insert((Object)entity);
        String response = (String)restTemplate.postForObject(url, (Object)requestEntity, String.class, new Object[0]);
        entity.setResult(response);
        this.httpLogMapper.updateById((Object)entity);
        return response;
    }
}

