/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.infusionOfFluids.GetInfusionListDto;
import com.byh.outpatient.api.dto.infusionOfFluids.GetInfusionPageDto;
import com.byh.outpatient.api.dto.infusionOfFluids.OperateInfusionDto;
import com.byh.outpatient.api.dto.infusionOfFluids.SaveInfusionOfFluidsDto;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutInfusionOfFluidsService;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/infusionOfFluids"})
public class OutInfusionOfFluidsController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private OutInfusionOfFluidsService outInfusionOfFluidsService;

    @ApiOperation(value="\u751f\u6210\u6267\u884c\u5355\u6253\u5370\u5185\u5bb9")
    @PostMapping(value={"selectPrintData"})
    public ResponseData selectPrintData(@RequestBody @Valid GetInfusionListDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.outInfusionOfFluidsService.selectPrintData(dto));
    }

    @ApiOperation(value="\u914d\u836f\u3001\u6838\u5bf9\u3001\u5f00\u59cb\u8f93\u6db2\u3001\u7ed3\u675f\u8f93\u6db2")
    @PostMapping(value={"/operateInfusion"})
    public ResponseData operateInfusion(@RequestBody @Valid OperateInfusionDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setOperatorId(this.commonRequest.getUserId());
        dto.setOperatorName(this.commonRequest.getUserName());
        return ResponseData.success((Object)(this.outInfusionOfFluidsService.operateInfusion(dto) + "\u6210\u529f\uff01"));
    }

    @ApiOperation(value="\u6839\u636e\u95e8\u8bca\u53f7\u67e5\u8be2\u5bf9\u5e94\u7684\u60a3\u8005\u95e8\u8bca\u8f93\u6db2\u5355\u8bb0\u5f55\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/selectListByOutpatientNo"})
    public ResponseData selectListByOutpatientNo(@RequestBody @Valid GetInfusionListDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.outInfusionOfFluidsService.selectListByOutpatientNo(dto));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u60a3\u8005\u95e8\u8bca\u8f93\u6db2\u5355\u8bb0\u5f55")
    @PostMapping(value={"/selectPageList"})
    public ResponseData selectPageList(@RequestBody GetInfusionPageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.outInfusionOfFluidsService.selectPageList(dto));
    }

    @ApiOperation(value="\u64cd\u4f5c\u95e8\u8bca\u8f93\u6db2\u5355\u8bb0\u5f55")
    @PostMapping(value={"/operateInfusionOfFluids"})
    @UserOptLogger(operation="\u65b0\u589e\u95e8\u8bca\u8f93\u6db2\u5355\u8bb0\u5f55")
    public ResponseData operateInfusionOfFluids(@RequestBody @Valid SaveInfusionOfFluidsDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setOperatorId(this.commonRequest.getUserId());
        dto.setOperatorName(this.commonRequest.getUserName());
        this.outInfusionOfFluidsService.operateInfusionOfFluids(dto);
        return ResponseData.success((Object)"\u95e8\u8bca\u8f93\u6db2\u5355\u8bb0\u5f55\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

