/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.medicalRecord.ImplementDto;
import com.byh.outpatient.api.dto.medicalRecord.QueryExecutionDto;
import com.byh.outpatient.api.dto.treatment.PrintItemsDto;
import com.byh.outpatient.api.dto.treatment.QueryExecutionRecordsDto;
import com.byh.outpatient.api.dto.treatment.QueryInspectionChecklistDto;
import com.byh.outpatient.api.dto.treatment.QueryItemRecordsDto;
import com.byh.outpatient.api.dto.treatment.QueryItemsDto;
import com.byh.outpatient.api.dto.treatment.SaveTreatmentItemsDto;
import com.byh.outpatient.api.enums.PaymentStatusEnum;
import com.byh.outpatient.api.excel.ExcelQueryItemsVo;
import com.byh.outpatient.api.model.treatment.OutTreatmentItems;
import com.byh.outpatient.api.util.BeanUtil;
import com.byh.outpatient.api.util.EasyExcelUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringUtil;
import com.byh.outpatient.api.vo.OutTreatmentDfmResVo;
import com.byh.outpatient.api.vo.order.QueryFeeDetailsListVo;
import com.byh.outpatient.api.vo.prescription.QueryExecutionListVo;
import com.byh.outpatient.api.vo.treatment.PrintTemplateVo;
import com.byh.outpatient.api.vo.treatment.QueryExecutionRecordsVo;
import com.byh.outpatient.api.vo.treatment.QueryItemsExport;
import com.byh.outpatient.api.vo.treatment.QueryItemsVo;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.TreatmentItemsService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/treatmentItems"})
public class TreatmentItemsController {
    @Autowired
    private TreatmentItemsService treatmentItemsService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/v1/queryTreatmentItemByOutpatientNo"})
    @Operation(description="\u67e5\u8be2\u60a3\u8005\u524d10\u6b21\u68c0\u67e5\u68c0\u9a8c")
    @ApiOperation(value="\u67e5\u8be2\u60a3\u8005\u524d10\u6b21\u68c0\u67e5\u68c0\u9a8c", httpMethod="POST", notes="\u67e5\u8be2\u60a3\u8005\u524d10\u6b21\u68c0\u67e5\u68c0\u9a8c")
    public ResponseData<List<QueryItemsVo>> queryTreatmentItemByOutpatientNo(@RequestBody @Valid OutTreatmentItems parameter) {
        String patientId = parameter.getPatientId();
        if (StringUtils.isBlank((CharSequence)patientId)) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.treatmentItemsService.queryTreatmentItemByOutpatientNo(parameter);
    }

    @PostMapping(value={"/v1/queryOutpatientDetail"})
    @Operation(description="\u67e5\u8be2\u60a3\u8005\u524d10\u6b21\u5c31\u8bca\u8be6\u60c5")
    @ApiOperation(value="\u67e5\u8be2\u60a3\u8005\u524d10\u6b21\u5c31\u8bca\u8be6\u60c5", httpMethod="POST", notes="\u67e5\u8be2\u60a3\u8005\u524d10\u6b21\u5c31\u8bca\u8be6\u60c5")
    public ResponseData<List<Map<String, Object>>> queryOutpatientDetail(@RequestBody @Valid OutTreatmentItems parameter) {
        String patientId = parameter.getPatientId();
        if (StringUtils.isBlank((CharSequence)patientId)) {
            return ResponseData.error((String)"\u60a3\u8005id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List list = this.treatmentItemsService.queryOutpatientDetail(parameter.getPatientId());
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/v1/queryItems"})
    @Operation(description="\u95e8\u8bca\u53f7\u67e5\u8be2\u9879\u76ee\u5217\u8868")
    @ApiOperation(value="\u95e8\u8bca\u53f7\u67e5\u8be2\u9879\u76ee\u5217\u8868", httpMethod="POST", notes="\u95e8\u8bca\u53f7\u67e5\u8be2\u9879\u76ee\u5217\u8868")
    public ResponseData<List<QueryItemsVo>> queryItems(@RequestBody @Valid QueryItemsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.treatmentItemsService.queryItems(parameter);
    }

    @PostMapping(value={"/v1/queryItems/by/dianfumao"})
    @Operation(description="\u9762\u5355\u6253\u5370\u9700\u8981\u7684\u7898\u4f0f\u5e3d\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u9762\u5355\u6253\u5370\u9700\u8981\u7684\u7898\u4f0f\u5e3d\u5217\u8868\u67e5\u8be2", httpMethod="POST", notes="\u9762\u5355\u6253\u5370\u9700\u8981\u7684\u7898\u4f0f\u5e3d\u5217\u8868\u67e5\u8be2")
    public ResponseData<List<OutTreatmentDfmResVo>> queryItemsByDianfumao(@RequestBody QueryItemsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.treatmentItemsService.queryItemsByDianfumao(parameter);
    }

    @PostMapping(value={"/v1/queryItemsDetails"})
    @Operation(description="\u9879\u76eeid\u67e5\u8be2\u8be6\u60c5")
    @ApiOperation(value="\u9879\u76eeid\u67e5\u8be2\u8be6\u60c5", httpMethod="POST", notes="\u9879\u76eeid\u67e5\u8be2\u8be6\u60c5")
    public ResponseData<List<QueryFeeDetailsListVo>> queryItemsDetails(@RequestBody @Valid QueryItemsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.treatmentItemsService.queryItemsDetails(parameter);
    }

    @PostMapping(value={"/v1/saveTreatmentItems"})
    @Operation(description="\u4fdd\u5b58\u6cbb\u7597\u9879\u76ee")
    @ApiOperation(value="\u4fdd\u5b58\u6cbb\u7597\u9879\u76ee", httpMethod="POST", notes="\u4fdd\u5b58\u6cbb\u7597\u9879\u76ee")
    public ResponseData<String> saveTreatmentItems(@RequestBody @Valid SaveTreatmentItemsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        if (StringUtils.isEmpty((CharSequence)parameter.getOperatorName())) {
            parameter.setOperatorName(this.commonRequest.getUserName());
        }
        return this.treatmentItemsService.saveTreatmentItems(parameter);
    }

    @PostMapping(value={"/v1/voidItems"})
    @Operation(description="\u9879\u76eeid\u4f5c\u5e9f")
    @ApiOperation(value="\u9879\u76eeid\u4f5c\u5e9f", httpMethod="POST", notes="\u9879\u76eeid\u4f5c\u5e9f")
    public ResponseData<String> voidItems(@RequestBody @Valid QueryItemsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.treatmentItemsService.voidItems(parameter);
    }

    @PostMapping(value={"/v1/queryExecutionList"})
    @Operation(description="\u67e5\u8be2\u6267\u884c\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u6267\u884c\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u6267\u884c\u5217\u8868")
    public ResponseData<PageResult<QueryExecutionListVo>> queryExecutionList(@RequestBody @Valid QueryExecutionDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.treatmentItemsService.queryExecutionList(parameter);
    }

    @PostMapping(value={"/v1/implement"})
    @Operation(description="\u6267\u884c")
    @ApiOperation(value="\u6267\u884c", httpMethod="POST", notes="\u6267\u884c")
    public ResponseData<String> implement(@RequestBody @Valid ImplementDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.treatmentItemsService.implement(parameter);
    }

    @PostMapping(value={"/v1/queryInspectionChecklist"})
    @Operation(description="\u5386\u53f2\u68c0\u6d4b\u68c0\u9a8c\u5217\u8868")
    @ApiOperation(value="\u5386\u53f2\u68c0\u6d4b\u68c0\u9a8c\u5217\u8868", httpMethod="POST", notes="\u5386\u53f2\u68c0\u6d4b\u68c0\u9a8c\u5217\u8868")
    public ResponseData<List<QueryItemsVo>> queryInspectionChecklist(@RequestBody @Valid QueryInspectionChecklistDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.treatmentItemsService.queryInspectionChecklist(parameter);
    }

    @PostMapping(value={"/v1/queryExecutionRecords"})
    @Operation(description="\u67e5\u8be2\u6267\u884c\u8bb0\u5f55")
    @ApiOperation(value="\u67e5\u8be2\u6267\u884c\u8bb0\u5f55", httpMethod="POST", notes="\u67e5\u8be2\u6267\u884c\u8bb0\u5f55")
    public ResponseData<PageResult<QueryExecutionRecordsVo>> queryExecutionRecords(@RequestBody @Valid QueryExecutionRecordsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.treatmentItemsService.queryExecutionRecords(parameter);
    }

    @PostMapping(value={"/v1/printBarcode"})
    @Operation(description="\u6253\u5370\u6761\u7801")
    @ApiOperation(value="\u6253\u5370\u6761\u7801", httpMethod="POST", notes="\u6253\u5370\u6761\u7801")
    public ResponseData<String> printBarcode(@RequestBody @Valid ImplementDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.treatmentItemsService.printBarcode(parameter);
    }

    @PostMapping(value={"/v1/printTreatment"})
    @Operation(description="\u6253\u5370\u9879\u76ee")
    @ApiOperation(value="\u6253\u5370\u9879\u76ee", httpMethod="POST", notes="\u6253\u5370\u9879\u76ee")
    public ResponseData<List<PrintTemplateVo>> printTreatment(@RequestBody @Valid PrintItemsDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.treatmentItemsService.printTreatment(parameter);
    }

    @PostMapping(value={"/v1/queryItemRecords"})
    @Operation(description="\u67e5\u8be2\u6267\u884c\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u6267\u884c\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u6267\u884c\u5217\u8868")
    public ResponseData<PageResult<QueryItemsVo>> queryItemRecords(@RequestBody @Valid QueryItemRecordsDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.treatmentItemsService.queryItemRecords(parameter);
    }

    @PostMapping(value={"/v1/queryItemRecordsExcel"})
    @Operation(description="\u67e5\u8be2\u6267\u884c\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u6267\u884c\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u6267\u884c\u5217\u8868")
    public void queryItemRecordsExcel(HttpServletResponse response, @RequestBody @Valid QueryItemRecordsDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setSize(Integer.valueOf(999999999));
        parameter.setQueryType("excel");
        ResponseData pageResultResponseData = this.treatmentItemsService.queryItemRecords(parameter);
        List records = ((PageResult)pageResultResponseData.getData()).getRecords();
        records.forEach(item -> {
            Integer paymentStatus = item.getPaymentStatus();
            if (paymentStatus != null) {
                PaymentStatusEnum valueEnum = PaymentStatusEnum.getValueEnum((Integer)paymentStatus);
                String desc = valueEnum.getDesc();
                item.setPaymentStatusStr(desc);
                String patientSex = item.getPatientSex();
                if (StringUtil.isNotBlank((String)patientSex)) {
                    if (patientSex.equals("1")) {
                        item.setPatientSex("\u7537");
                    } else if (patientSex.equals("2")) {
                        item.setPatientSex("\u5973");
                    }
                }
            }
        });
        List excelQueryItemsVos = BeanUtil.copyList((List)records, ExcelQueryItemsVo.class);
        EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)"\u8bca\u7597\u8bb0\u5f55", (String)"\u8bca\u7597\u8bb0\u5f55", (List)excelQueryItemsVos, ExcelQueryItemsVo.class);
    }

    @PostMapping(value={"/v1/exportItemRecords"})
    @Operation(description="\u5bfc\u51fa\u6267\u884c\u5217\u8868")
    @ApiOperation(value="\u5bfc\u51fa\u6267\u884c\u5217\u8868", httpMethod="POST", notes="\u5bfc\u51fa\u6267\u884c\u5217\u8868")
    public void exportItemRecords(HttpServletResponse response, @RequestBody @Valid QueryItemRecordsDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setCurrent(Integer.valueOf(1));
        parameter.setSize(Integer.valueOf(9999999));
        ResponseData pageResultResponseData = this.treatmentItemsService.queryItemRecords(parameter);
        List records = ((PageResult)pageResultResponseData.getData()).getRecords();
        List collect = records.stream().map(map -> {
            QueryItemsExport queryItemsExport = new QueryItemsExport();
            BeanUtils.copyProperties((Object)map, (Object)queryItemsExport);
            queryItemsExport.setPatientSex(queryItemsExport.getPatientSex().equals("1") ? "\u7537" : "\u5973");
            Integer paymentStatus = map.getPaymentStatus();
            switch (paymentStatus) {
                case 10: {
                    queryItemsExport.setPaymentStatus("\u5f85\u4ed8\u6b3e");
                    break;
                }
                case 20: {
                    queryItemsExport.setPaymentStatus("\u5df2\u652f\u4ed8");
                    break;
                }
                case 25: {
                    queryItemsExport.setPaymentStatus("\u5df2\u9000\u6b3e[\u90e8\u5206\u9000\u6b3e]");
                    break;
                }
                case 30: {
                    queryItemsExport.setPaymentStatus("\u5df2\u9000\u6b3e[\u5168\u989d\u9000\u6b3e]");
                }
            }
            return queryItemsExport;
        }).collect(Collectors.toList());
        EasyExcelUtil.exportExcel((HttpServletResponse)response, (String)"\u6267\u884c\u5217\u8868", (String)"sheet", collect, QueryItemsExport.class);
    }

    @PostMapping(value={"/queryDiagInfo"})
    @Operation(description="\u9879\u76eeid\u67e5\u8be2\u6162\u75c5")
    @ApiOperation(value="\u9879\u76eeid\u67e5\u8be2\u6162\u75c5", httpMethod="POST", notes="\u9879\u76eeid\u67e5\u8be2\u6162\u75c5")
    public ResponseData<QueryItemsVo> queryDiagInfo(@RequestBody @Valid QueryItemsDto dto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        dto.setTenantId(this.commonRequest.getTenant());
        return this.treatmentItemsService.queryDiagInfo(dto);
    }
}

