/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.HsSettlementReportDto;
import com.byh.outpatient.api.dto.hsSettlement.CityWorkerHsSettlementInfo;
import com.byh.outpatient.api.dto.hsSettlement.ExcelHsSettlementInfo;
import com.byh.outpatient.api.dto.hsSettlement.HsInfoDto;
import com.byh.outpatient.api.dto.hsSettlement.HsSettlementDetailDto;
import com.byh.outpatient.api.dto.hsSettlement.HsSettlementInfoDto;
import com.byh.outpatient.api.dto.hsSettlement.HsSettlementReportListDto;
import com.byh.outpatient.api.dto.hsSettlement.QueryDetailDto;
import com.byh.outpatient.api.dto.hsSettlement.ReconciliationTotalDto;
import com.byh.outpatient.api.dto.hsSettlement.TendencyDto;
import com.byh.outpatient.api.dto.hsSettlement.setlinfo;
import com.byh.outpatient.api.enums.HsAreaCityEnum;
import com.byh.outpatient.api.enums.HsTendencyTypeEnum;
import com.byh.outpatient.api.enums.InsutypeEnum;
import com.byh.outpatient.api.enums.OutHsIcdContrastEnum;
import com.byh.outpatient.api.enums.SettlementMethodEnum;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoByHifmi;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoNew;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoSummary;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoSummaryByOffsiteDetail;
import com.byh.outpatient.api.excel.ExcelHsSettlementInfoSummaryByOffsiteDetailSW;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.hsModel.request.GetSettlementInfoRequest;
import com.byh.outpatient.api.hsModel.request.ReconciliationTotalRequest;
import com.byh.outpatient.api.hsModel.respones.HsBaseResponse;
import com.byh.outpatient.api.hsModel.respones.ReconciliationTotalResponse;
import com.byh.outpatient.api.model.OutHsIcdContrastEntity;
import com.byh.outpatient.api.model.admission.AdmissionEntity;
import com.byh.outpatient.api.model.hsSettlement.HsSettlementInfoEntity;
import com.byh.outpatient.api.model.hsSettlement.OutHsSettlementInfoDetaiEntity;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.sysModel.request.SysDictValueDTO;
import com.byh.outpatient.api.sysModel.respones.SysDictValueVo;
import com.byh.outpatient.api.util.DateUtils;
import com.byh.outpatient.api.util.ExceptionUtils;
import com.byh.outpatient.api.util.HyposensitizationUtil;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.hsSettlement.DictValueVo;
import com.byh.outpatient.api.vo.hsSettlement.ExportHsSettlementByCheckId;
import com.byh.outpatient.api.vo.hsSettlement.ExportHsSettlementByDept;
import com.byh.outpatient.api.vo.hsSettlement.ExportHsSettlementTotal;
import com.byh.outpatient.api.vo.hsSettlement.HsInfoForPieChart;
import com.byh.outpatient.api.vo.hsSettlement.HsInfoForPieChartDetail;
import com.byh.outpatient.api.vo.hsSettlement.HsInfoVo;
import com.byh.outpatient.api.vo.hsSettlement.HsPatientDiseInfoVo;
import com.byh.outpatient.api.vo.hsSettlement.HsRegistrationVo;
import com.byh.outpatient.api.vo.hsSettlement.HsSettlementDetailVo;
import com.byh.outpatient.api.vo.hsSettlement.HsSettlementReportListVo;
import com.byh.outpatient.api.vo.hsSettlement.SettlementInfoSeries;
import com.byh.outpatient.api.vo.hsSettlement.TendencyTotalVo;
import com.byh.outpatient.api.vo.hsSettlement.TendencyVo;
import com.byh.outpatient.api.vo.hsSettlement.TotalHsSettlmentRes;
import com.byh.outpatient.data.repository.AdmissionMapper;
import com.byh.outpatient.data.repository.OutHsIcdContrastMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoDetailMapper;
import com.byh.outpatient.data.repository.OutHsSettlementInfoMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.data.repository.PatientMapper;
import com.byh.outpatient.web.feign.HsServiceFeign;
import com.byh.outpatient.web.feign.SysServiceFeign;
import com.byh.outpatient.web.service.HsSettlementReportService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HsSettlmentReportServiceImpl
implements HsSettlementReportService {
    private static final Logger log = LoggerFactory.getLogger(HsSettlmentReportServiceImpl.class);
    private Logger logger = LoggerFactory.getLogger(HsSettlmentReportServiceImpl.class);
    @Autowired
    private OutOrderPaymentMapper outOrderPaymentMapper;
    @Resource
    private OutHsSettlementInfoMapper outHsSettlementInfoMapper;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Resource
    private OutHsSettlementInfoDetailMapper outHsSettlementInfoDetailMapper;
    @Resource
    private OutHsIcdContrastMapper outHsIcdContrastMapper;
    @Resource
    private PatientMapper patientMapper;
    @Resource
    private AdmissionMapper admissionMapper;
    @Autowired
    private HsServiceFeign hsServiceFeign;

    public List<Map<String, String>> selectDiseCodgGroupList() {
        List diseInfoVoList = this.outHsSettlementInfoMapper.selectDiseCodgGroupList();
        List patientDiseInfoList = this.patientMapper.selectPatientDiseInfoList(diseInfoVoList);
        List<Map<String, String>> diseInfoList = patientDiseInfoList.stream().map(diseInfoVo -> {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("value", diseInfoVo.getDiseaseCode());
            map.put("label", diseInfoVo.getDiseaseName() + "\uff08" + diseInfoVo.getPersonCount().toString() + " \u4eba\uff09");
            return map;
        }).collect(Collectors.toList());
        return diseInfoList;
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void updatePatientByHsSetllement() {
        List diseInfoList = this.outHsSettlementInfoMapper.selectDiseList();
        Map diseInfoMap = diseInfoList.stream().collect(Collectors.toMap(HsPatientDiseInfoVo::getPatientId, Function.identity()));
        List patientIds = diseInfoList.stream().map(HsPatientDiseInfoVo::getPatientId).distinct().collect(Collectors.toList());
        int batchSize = 1000;
        ArrayList batches = new ArrayList();
        for (int i = 0; i < patientIds.size(); i += batchSize) {
            batches.add(patientIds.subList(i, Math.min(i + batchSize, patientIds.size())));
        }
        int threadCount = 50;
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        ArrayList futures = new ArrayList();
        ConcurrentLinkedQueue successList = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue failList = new ConcurrentLinkedQueue();
        for (List list : batches) {
            Future<?> future = executor.submit(() -> {
                for (String patientId : batch) {
                    try {
                        HsPatientDiseInfoVo diseInfoVo = (HsPatientDiseInfoVo)diseInfoMap.get(patientId);
                        if (diseInfoVo == null) continue;
                        String diseCodg = diseInfoVo.getDiseCodg();
                        String diseName = diseInfoVo.getDiseName();
                        int updateRows = this.patientMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(PatientEntity::getChronicDiseaseCode, (Object)diseCodg)).set(PatientEntity::getChronicDisease, (Object)diseName)).eq(PatientEntity::getId, (Object)patientId));
                        if (updateRows > 0) {
                            successList.add(patientId);
                            continue;
                        }
                        failList.add(patientId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        failList.add(patientId);
                    }
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        executor.shutdown();
        ArrayList successPatientIds = new ArrayList(successList);
        ArrayList arrayList = new ArrayList(failList);
        String failPatientIdsStr = String.join((CharSequence)",", arrayList);
        System.out.println(failPatientIdsStr);
        System.out.println("\u6570\u636e\u5237\u65b0\u6210\u529f\uff01");
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void insertHsCerterInfo(HsSettlementInfoDto dto) {
        ObjectMapper objectMapper;
        setlinfo setlinfo2 = dto.getSetlinfo();
        List detailList = dto.getSetldetail();
        Integer tenantId = dto.getTenantId();
        String mdtrtId = setlinfo2.getMdtrt_id();
        String setlId = setlinfo2.getSetl_id();
        LambdaQueryWrapper hsSettlementQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)hsSettlementQueryWrapper.eq(tenantId != null, HsSettlementInfoEntity::getTenantId, (Object)tenantId)).eq(HsSettlementInfoEntity::getSetl_id, (Object)setlId);
        HsSettlementInfoEntity dbHsSettlementInfo = (HsSettlementInfoEntity)this.outHsSettlementInfoMapper.selectOne((Wrapper)hsSettlementQueryWrapper);
        if (dbHsSettlementInfo != null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u8bf7\u52ff\u91cd\u590d\u63d2\u5165\u533b\u4fdd\u7ed3\u7b97\u4fe1\u606f\uff01");
        }
        if (setlinfo2.getMedfee_sumamt().compareTo(BigDecimal.ZERO) > 0) {
            setlinfo2.setSettlmentStatus("1");
        } else {
            setlinfo2.setSettlmentStatus("2");
        }
        setlinfo2.setTenantId(tenantId);
        HsRegistrationVo registrationVo = this.outHsSettlementInfoMapper.selectRegistrationByMdtrtId(tenantId, mdtrtId);
        String mdtrtCertType = "";
        String insuplcAdmdvs = "";
        if (registrationVo == null || StrUtil.isEmpty((CharSequence)registrationVo.getParam())) {
            LambdaQueryWrapper admissionQueryWrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)admissionQueryWrapper.eq(tenantId != null, AdmissionEntity::getTenantId, (Object)tenantId)).eq(AdmissionEntity::getPatientCardNo, (Object)setlinfo2.getCertno());
            List admissionList = this.admissionMapper.selectList((Wrapper)admissionQueryWrapper);
            insuplcAdmdvs = admissionList.stream().map(AdmissionEntity::getInsuplcAdmdvs).filter(Objects::nonNull).filter(StrUtil::isNotEmpty).findFirst().orElse("");
            mdtrtCertType = "01";
        } else {
            try {
                objectMapper = new ObjectMapper();
                Map map = (Map)objectMapper.readValue(registrationVo.getParam(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                mdtrtCertType = map.getOrDefault("mdtrt_cert_type", "");
                insuplcAdmdvs = map.getOrDefault("insuplc_admdvs", "");
            }
            catch (Exception e) {
                ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
            }
        }
        if (StrUtil.isEmpty((CharSequence)insuplcAdmdvs)) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u53c2\u4fdd\u533a\u5212\u4e3a\u7a7a\uff01");
        }
        setlinfo2.setMdtrt_cert_type(mdtrtCertType);
        setlinfo2.setInsuplc_admdvs(insuplcAdmdvs);
        try {
            objectMapper = new ObjectMapper();
            String setlDetailInfo = objectMapper.writeValueAsString((Object)detailList);
            setlinfo2.setSetlDetail(setlDetailInfo);
        }
        catch (Exception e) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
        }
        this.outHsSettlementInfoMapper.insertHsSettlementInfo(setlinfo2);
        if (!detailList.isEmpty()) {
            detailList.forEach(detail -> {
                detail.setTenantId(tenantId);
                detail.setSetlId(setlId);
            });
            this.outHsSettlementInfoMapper.insertHsSettlementDetailInfo(detailList);
        }
    }

    public List<HsInfoForPieChart> getHsInfoForPieChart(HsInfoDto dto) {
        HsInfoVo hsInfoVo = this.outHsSettlementInfoMapper.getHsInfoForCard(dto);
        ArrayList<HsInfoForPieChart> list = new ArrayList<HsInfoForPieChart>();
        if (hsInfoVo != null) {
            String[] names = new String[]{"\u5e02\u804c\u5de5", "\u5e02\u5c45\u6c11", "\u7701\u4f01\u4e1a", "\u7701\u673a\u5173", "\u7701\u5185\u5f02\u5730\uff08\u804c\u5de5\uff09", "\u7701\u5185\u5f02\u5730\uff08\u5c45\u6c11\uff09", "\u7701\u5916\u5f02\u5730\uff08\u804c\u5de5\uff09", "\u7701\u5916\u5f02\u5730\uff08\u5c45\u6c11\uff09", "\u5e02\u79bb\u4f11", "\u7701\u79bb\u4f11", "\u7701\u5185\u5f02\u5730\uff08\u79bb\u4f11\uff09"};
            Integer[] countValues = new Integer[]{hsInfoVo.getCityWorkerHsCount(), hsInfoVo.getCityInhabitantHsCount(), hsInfoVo.getProvinceFirmHsCount(), hsInfoVo.getProvinceOrganHsCount(), hsInfoVo.getInProvinceWorkerCount(), hsInfoVo.getInProvinceInhabitantCount(), hsInfoVo.getOutProvinceWorkerCount(), hsInfoVo.getOutProvinceInhabitantCount(), hsInfoVo.getCityRetireCount(), hsInfoVo.getProvinceRetireCount(), hsInfoVo.getInProvinceRetireCount()};
            Integer totalCount = hsInfoVo.getTotalCount();
            HsInfoForPieChart countPieChart = new HsInfoForPieChart();
            countPieChart.setName("\u7b26\u5408\u7ed3\u7b97\u6b21\u6570");
            countPieChart.setTotalData(BigDecimal.valueOf(totalCount.intValue()));
            countPieChart.setDetailList(this.createPieChartDetails(names, null, null, countValues, totalCount, false));
            list.add(countPieChart);
            BigDecimal[] fundPaySumamtValues = new BigDecimal[]{hsInfoVo.getCityWorkerFundPaySumamt(), hsInfoVo.getCityInhabitantFundPaySumamt(), hsInfoVo.getProvinceFirmFundPaySumamt(), hsInfoVo.getProvinceOrganFundPaySumamt(), hsInfoVo.getInProvinceWorkerFundPaySumamt(), hsInfoVo.getInProvinceInhabitantFundPaySumamt(), hsInfoVo.getOutProvinceWorkerFundPaySumamt(), hsInfoVo.getOutProvinceInhabitantFundPaySumamt(), hsInfoVo.getCityRetireFundPaySumamt(), hsInfoVo.getProvinceRetireFundPaySumamt(), hsInfoVo.getInProvinceRetireFundPaySumamt()};
            BigDecimal totalFundPaySumamt = hsInfoVo.getTotalFundPaySumamt();
            HsInfoForPieChart fundPaySumamtPieChart = new HsInfoForPieChart();
            fundPaySumamtPieChart.setName("\u57fa\u91d1\u652f\u4ed8\u603b\u989d");
            fundPaySumamtPieChart.setTotalData(totalFundPaySumamt);
            fundPaySumamtPieChart.setDetailList(this.createPieChartDetails(names, fundPaySumamtValues, totalFundPaySumamt, null, null, true));
            list.add(fundPaySumamtPieChart);
            BigDecimal[] acctPayValues = new BigDecimal[]{hsInfoVo.getCityWorkerAcctPay(), hsInfoVo.getCityInhabitantAcctPay(), hsInfoVo.getProvinceFirmAcctPay(), hsInfoVo.getProvinceOrganAcctPay(), hsInfoVo.getInProvinceWorkerAcctPay(), hsInfoVo.getInProvinceInhabitantAcctPay(), hsInfoVo.getOutProvinceWorkerAcctPay(), hsInfoVo.getOutProvinceInhabitantAcctPay(), hsInfoVo.getCityRetireAcctPay(), hsInfoVo.getProvinceRetireAcctPay(), hsInfoVo.getInProvinceRetireAcctPay()};
            BigDecimal totalAcctPay = hsInfoVo.getTotalAcctPay();
            HsInfoForPieChart acctPayPieChart = new HsInfoForPieChart();
            acctPayPieChart.setName("\u4e2a\u8d26\u652f\u4ed8\u91d1\u989d");
            acctPayPieChart.setTotalData(totalAcctPay);
            acctPayPieChart.setDetailList(this.createPieChartDetails(names, acctPayValues, totalAcctPay, null, null, true));
            list.add(acctPayPieChart);
            BigDecimal[] medfeeSumamtValues = new BigDecimal[]{hsInfoVo.getCityWorkerMedfeeSumamt(), hsInfoVo.getCityInhabitantMedfeeSumamt(), hsInfoVo.getProvinceFirmMedfeeSumamt(), hsInfoVo.getProvinceOrganMedfeeSumamt(), hsInfoVo.getInProvinceWorkerMedfeeSumamt(), hsInfoVo.getInProvinceInhabitantMedfeeSumamt(), hsInfoVo.getOutProvinceWorkerMedfeeSumamt(), hsInfoVo.getOutProvinceInhabitantMedfeeSumamt(), hsInfoVo.getCityRetireMedfeeSumamt(), hsInfoVo.getProvinceRetireMedfeeSumamt(), hsInfoVo.getInProvinceRetireMedfeeSumamt()};
            BigDecimal totalMedfeeSumamt = hsInfoVo.getTotalMedfeeSumamt();
            HsInfoForPieChart medfeeSumamtPieChart = new HsInfoForPieChart();
            medfeeSumamtPieChart.setName("\u533b\u7597\u8d39\u7528\u603b\u989d");
            medfeeSumamtPieChart.setTotalData(totalMedfeeSumamt);
            medfeeSumamtPieChart.setDetailList(this.createPieChartDetails(names, medfeeSumamtValues, totalMedfeeSumamt, null, null, true));
            list.add(medfeeSumamtPieChart);
            String[] settleNames = new String[]{"\u7535\u5b50\u533b\u4fdd", "\u533b\u4fdd\u5361"};
            Integer[] settleValues = new Integer[]{hsInfoVo.getElecHsCount(), hsInfoVo.getCardHsCount()};
            Integer totalHsCount = hsInfoVo.getHsCount();
            HsInfoForPieChart hsCountPieChart = new HsInfoForPieChart();
            hsCountPieChart.setName("\u7ed3\u7b97\u65b9\u5f0f");
            hsCountPieChart.setTotalData(BigDecimal.valueOf(totalHsCount.intValue()));
            hsCountPieChart.setDetailList(this.createPieChartDetails(settleNames, null, null, settleValues, totalHsCount, false));
            list.add(hsCountPieChart);
        }
        return list;
    }

    private List<HsInfoForPieChartDetail> createPieChartDetails(String[] names, BigDecimal[] values, BigDecimal totalValue, Integer[] intValues, Integer intTotalValue, boolean isMoney) {
        ArrayList<HsInfoForPieChartDetail> details = new ArrayList<HsInfoForPieChartDetail>();
        for (int i = 0; i < names.length; ++i) {
            HsInfoForPieChartDetail detail = isMoney ? this.createMoneyPieChartDetail(names[i], values[i], totalValue) : this.createTotalPieChartDetail(names[i], intValues[i], intTotalValue);
            details.add(detail);
        }
        return details;
    }

    private HsInfoForPieChartDetail createMoneyPieChartDetail(String name, BigDecimal value, BigDecimal totalValue) {
        HsInfoForPieChartDetail detail = new HsInfoForPieChartDetail();
        detail.setValue(value);
        detail.setName(name);
        detail.setDataPercent(this.dataPercentForMoney(value, totalValue));
        return detail;
    }

    private String dataPercentForMoney(BigDecimal value, BigDecimal totalValue) {
        if (totalValue == null || BigDecimal.ZERO.compareTo(totalValue) == 0 || value == null) {
            return "0.00%";
        }
        BigDecimal percentage = value.multiply(BigDecimal.valueOf(100L)).divide(totalValue, 2, RoundingMode.HALF_UP);
        if (percentage.compareTo(BigDecimal.ZERO) == 0 && value.compareTo(BigDecimal.ZERO) > 0) {
            percentage = value.multiply(BigDecimal.valueOf(100L)).divide(totalValue, 4, RoundingMode.HALF_UP);
        }
        return percentage + "%";
    }

    private HsInfoForPieChartDetail createTotalPieChartDetail(String name, Integer value, Integer totalValue) {
        HsInfoForPieChartDetail detail = new HsInfoForPieChartDetail();
        detail.setValue(BigDecimal.valueOf(value.intValue()));
        detail.setName(name);
        detail.setDataPercent(this.dataPercentForCount(value, totalValue));
        return detail;
    }

    private String dataPercentForCount(Integer value, Integer totalValue) {
        if (totalValue == null || totalValue == 0 || value == null) {
            return "0.00%";
        }
        BigDecimal percentage = BigDecimal.valueOf(value.intValue()).multiply(BigDecimal.valueOf(100L)).divide(BigDecimal.valueOf(totalValue.intValue()), 2, RoundingMode.HALF_UP);
        if (percentage.compareTo(BigDecimal.ZERO) == 0 && value > 0) {
            percentage = BigDecimal.valueOf(value.intValue()).multiply(BigDecimal.valueOf(100L)).divide(BigDecimal.valueOf(totalValue.intValue()), 4, RoundingMode.HALF_UP);
        }
        return percentage + "%";
    }

    public HsInfoVo getHsInfoForCard(HsInfoDto dto) {
        HsInfoVo hsInfoVo = this.outHsSettlementInfoMapper.getHsInfoForCard(dto);
        hsInfoVo.setElecHsRate(this.dataPercentForCount(hsInfoVo.getElecHsCount(), hsInfoVo.getHsCount()));
        return hsInfoVo;
    }

    public TendencyTotalVo getTendencyInfo(TendencyDto dto) {
        List tendencyVoList = new ArrayList();
        if (dto.getType().equals(HsTendencyTypeEnum.TOTAL_INFO.getValue())) {
            tendencyVoList = this.outHsSettlementInfoMapper.getTotalTendencyList(dto);
        } else if (dto.getType().equals(HsTendencyTypeEnum.CITY_WORKER.getValue())) {
            dto.setInsuType("310");
            dto.setClrType("11");
            dto.setInsuplcAdmdvs("1");
            dto.setPayFlag("1");
        } else if (dto.getType().equals(HsTendencyTypeEnum.CITY_INHABITANT.getValue())) {
            dto.setInsuType("390");
            dto.setClrType("11");
            dto.setInsuplcAdmdvs("1");
            dto.setPayFlag("1");
        } else if (dto.getType().equals(HsTendencyTypeEnum.PROVINCE_FIRM.getValue())) {
            dto.setInsuType("310");
            dto.setClrType("99901");
            dto.setInsuplcAdmdvs("2");
            dto.setPayFlag("1");
        } else if (dto.getType().equals(HsTendencyTypeEnum.PROVINCE_ORGAN.getValue())) {
            dto.setInsuType("310");
            dto.setClrType("99902");
            dto.setInsuplcAdmdvs("2");
            dto.setPayFlag("1");
        } else if (dto.getType().equals(HsTendencyTypeEnum.IN_PROVINCE_WORKER.getValue())) {
            dto.setInsuType("310");
            dto.setClrType("9994");
            dto.setInsuplcAdmdvs("3");
        } else if (dto.getType().equals(HsTendencyTypeEnum.IN_PROVINCE_INHABITANT.getValue())) {
            dto.setInsuType("390");
            dto.setClrType("9994");
            dto.setInsuplcAdmdvs("3");
        } else if (dto.getType().equals(HsTendencyTypeEnum.OUT_PROVINCE_WORKER.getValue())) {
            dto.setInsuType("310");
            dto.setClrType("9901");
            dto.setInsuplcAdmdvs("4");
        } else if (dto.getType().equals(HsTendencyTypeEnum.OUT_PROVINCE_INHABITANT.getValue())) {
            dto.setInsuType("390");
            dto.setClrType("9901");
            dto.setInsuplcAdmdvs("4");
        } else if (dto.getType().equals(HsTendencyTypeEnum.CITY_RETIRE.getValue())) {
            dto.setInsuType("340");
            dto.setClrType("11");
            dto.setInsuplcAdmdvs("1");
        } else if (dto.getType().equals(HsTendencyTypeEnum.PROVINCE_RETIRE.getValue())) {
            dto.setInsuType("340");
            dto.setClrType("99903");
            dto.setInsuplcAdmdvs("2");
        } else if (dto.getType().equals(HsTendencyTypeEnum.IN_PROVINCE_RETIRE.getValue())) {
            dto.setInsuType("340");
            dto.setClrType("9994");
            dto.setInsuplcAdmdvs("3");
        }
        tendencyVoList = this.outHsSettlementInfoMapper.getTendencyListByType(dto);
        TendencyTotalVo totalVo = new TendencyTotalVo();
        if (!tendencyVoList.isEmpty()) {
            ArrayList<String> data = new ArrayList<String>();
            String startDate = dto.getStartDate();
            String endDate = dto.getEndDate();
            LocalDate start = LocalDate.parse(startDate);
            LocalDate end = LocalDate.parse(endDate);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            while (!start.isAfter(end)) {
                data.add(start.format(formatter));
                start = start.plusDays(1L);
            }
            ArrayList<SettlementInfoSeries> series = new ArrayList<SettlementInfoSeries>();
            String[] names = new String[]{"\u7b26\u5408\u7ed3\u7b97\u7b14\u6570", "\u57fa\u91d1\u652f\u4ed8\u603b\u989d", "\u4e2a\u8d26\u652f\u4ed8\u91d1\u989d", "\u533b\u7597\u8d39\u7528\u603b\u989d"};
            List<List> dataLists = Arrays.asList(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
            for (TendencyVo vo : tendencyVoList) {
                dataLists.get(0).add(vo.getHsCount());
                dataLists.get(1).add(vo.getFundPaySumamt());
                dataLists.get(2).add(vo.getAcctPay());
                dataLists.get(3).add(vo.getMedfeeSumamt());
            }
            for (int i = 0; i < names.length; ++i) {
                SettlementInfoSeries settlementInfoSeries = new SettlementInfoSeries();
                settlementInfoSeries.setName(names[i]);
                settlementInfoSeries.setData(dataLists.get(i));
                if (i == 0) {
                    settlementInfoSeries.setType("bar");
                    settlementInfoSeries.setUnit("\u6b21");
                } else {
                    settlementInfoSeries.setType("line");
                    settlementInfoSeries.setUnit("\u5143");
                }
                series.add(settlementInfoSeries);
            }
            totalVo.setData(data);
            totalVo.setSeries(series);
        }
        return totalVo;
    }

    public void exportHsSettlementInfoReport(HttpServletResponse response, HsSettlementReportDto dto) {
        Integer tenantId = dto.getTenantId();
        String range = dto.getStartDate() + " \u81f3 " + dto.getEndDate();
        List icdList = this.outHsSettlementInfoMapper.selectReportListByIcd(dto);
        List dayCheckList = this.outHsSettlementInfoMapper.selectReportListByCheckId(dto);
        List checkList = dayCheckList.stream().filter(item -> StrUtil.isNotEmpty((CharSequence)item.getCheckName())).collect(Collectors.toList());
        List dayTotalList = this.outHsSettlementInfoMapper.selectTotalReportList(dto);
        LocalDate today = LocalDate.now();
        LocalDate firstDayOfMonth = today.withDayOfMonth(1);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String totalQueryStartDate = firstDayOfMonth.format(formatter);
        String totalQueryEndDate = today.format(formatter);
        HsSettlementReportDto totalDto = new HsSettlementReportDto();
        totalDto.setTenantId(tenantId);
        totalDto.setStartDate(totalQueryStartDate);
        totalDto.setEndDate(totalQueryEndDate);
        List totalList = this.outHsSettlementInfoMapper.selectTotalReportList(totalDto);
        LambdaQueryWrapper hsIcdQueryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, OutHsIcdContrastEntity::getTenantId, (Object)tenantId);
        List hsIcdContrastList = this.outHsIcdContrastMapper.selectList((Wrapper)hsIcdQueryWrapper);
        Map<String, String> hsIcdContrastMap = hsIcdContrastList.stream().collect(Collectors.toMap(OutHsIcdContrastEntity::getIcdCode, OutHsIcdContrastEntity::getType));
        List totalIcdList = this.outHsSettlementInfoMapper.selectReportListByIcd(totalDto);
        ArrayList<ExportHsSettlementByDept> totalDeptList = new ArrayList<ExportHsSettlementByDept>();
        if (!totalIcdList.isEmpty()) {
            ArrayList<ExportHsSettlementByDept> oldTotalDeptList = new ArrayList<ExportHsSettlementByDept>();
            for (Object entity : totalIcdList) {
                ExportHsSettlementByDept oldDept = new ExportHsSettlementByDept();
                BeanUtils.copyProperties((Object)entity, (Object)oldDept);
                String type = hsIcdContrastMap.getOrDefault(entity.getIcdCode(), null);
                if (StrUtil.isNotEmpty((CharSequence)type)) {
                    String typeName = Optional.ofNullable(OutHsIcdContrastEnum.getEnumLabel((String)type)).map(OutHsIcdContrastEnum::getLabel).orElse(null);
                    if (StrUtil.isNotEmpty((CharSequence)typeName)) {
                        oldDept.setDeptName(typeName);
                    } else {
                        oldDept.setDeptName("\u4e8c\u7c7b\u6162\u75c5");
                    }
                } else {
                    oldDept.setDeptName("\u4e8c\u7c7b\u6162\u75c5");
                }
                oldTotalDeptList.add(oldDept);
            }
            HashMap<String, ExportHsSettlementByDept> groupedMap = new HashMap<String, ExportHsSettlementByDept>();
            for (ExportHsSettlementByDept item2 : oldTotalDeptList) {
                if (item2 == null || !StrUtil.isNotEmpty((CharSequence)item2.getDeptName())) continue;
                String deptName = item2.getDeptName();
                groupedMap.putIfAbsent(deptName, new ExportHsSettlementByDept(deptName, Integer.valueOf(0), Integer.valueOf(0), "0"));
                ExportHsSettlementByDept current = (ExportHsSettlementByDept)groupedMap.get(deptName);
                current.setElecHsCount(Integer.valueOf(current.getElecHsCount() + item2.getElecHsCount()));
                current.setHsCount(Integer.valueOf(current.getHsCount() + item2.getHsCount()));
            }
            for (ExportHsSettlementByDept dept : groupedMap.values()) {
                int hsCount = dept.getHsCount();
                int elecHsCount = dept.getElecHsCount();
                String elecHsRate = elecHsCount == 0 ? "0%" : String.format("%.2f%%", (double)elecHsCount / (double)hsCount * 100.0);
                dept.setElecHsRate(elecHsRate);
                totalDeptList.add(dept);
            }
            int totalElecHsCount = totalDeptList.stream().mapToInt(ExportHsSettlementByDept::getElecHsCount).sum();
            int totalHsCount = totalDeptList.stream().mapToInt(ExportHsSettlementByDept::getHsCount).sum();
            String totalElecHsRate = totalElecHsCount == 0 ? "0%" : String.format("%.2f%%", (double)totalElecHsCount / (double)totalHsCount * 100.0);
            ExportHsSettlementByDept totalDept = new ExportHsSettlementByDept();
            totalDept.setDeptName("\u5408\u8ba1");
            totalDept.setElecHsCount(Integer.valueOf(totalElecHsCount));
            totalDept.setHsCount(Integer.valueOf(totalHsCount));
            totalDept.setElecHsRate(totalElecHsRate);
            totalDeptList.add(totalDept);
        }
        List monthCheckList = this.outHsSettlementInfoMapper.selectReportListByCheckId(totalDto);
        List totalCheckList = monthCheckList.stream().filter(item -> StrUtil.isNotEmpty((CharSequence)item.getCheckName())).collect(Collectors.toList());
        String totalRange = totalQueryStartDate + " \u81f3 " + totalQueryEndDate;
        ArrayList<ExportHsSettlementByDept> newDeptList = new ArrayList<ExportHsSettlementByDept>();
        if (!icdList.isEmpty()) {
            ArrayList<ExportHsSettlementByDept> oldDeptList = new ArrayList<ExportHsSettlementByDept>();
            for (Object entity : icdList) {
                ExportHsSettlementByDept oldDept = new ExportHsSettlementByDept();
                BeanUtils.copyProperties((Object)entity, (Object)oldDept);
                String type = hsIcdContrastMap.getOrDefault(entity.getIcdCode(), null);
                if (StrUtil.isNotEmpty((CharSequence)type)) {
                    String typeName = Optional.ofNullable(OutHsIcdContrastEnum.getEnumLabel((String)type)).map(OutHsIcdContrastEnum::getLabel).orElse(null);
                    if (StrUtil.isNotEmpty((CharSequence)typeName)) {
                        oldDept.setDeptName(typeName);
                    } else {
                        oldDept.setDeptName("\u4e8c\u7c7b\u6162\u75c5");
                    }
                } else {
                    oldDept.setDeptName("\u4e8c\u7c7b\u6162\u75c5");
                }
                oldDeptList.add(oldDept);
            }
            HashMap<String, ExportHsSettlementByDept> groupedMap = new HashMap<String, ExportHsSettlementByDept>();
            for (ExportHsSettlementByDept item3 : oldDeptList) {
                if (item3 == null || !StrUtil.isNotEmpty((CharSequence)item3.getDeptName())) continue;
                String deptName = item3.getDeptName();
                groupedMap.putIfAbsent(deptName, new ExportHsSettlementByDept(deptName, Integer.valueOf(0), Integer.valueOf(0), "0"));
                ExportHsSettlementByDept current = (ExportHsSettlementByDept)groupedMap.get(deptName);
                current.setElecHsCount(Integer.valueOf(current.getElecHsCount() + item3.getElecHsCount()));
                current.setHsCount(Integer.valueOf(current.getHsCount() + item3.getHsCount()));
            }
            for (ExportHsSettlementByDept dept : groupedMap.values()) {
                int hsCount = dept.getHsCount();
                int elecHsCount = dept.getElecHsCount();
                String elecHsRate = elecHsCount == 0 ? "0%" : String.format("%.2f%%", (double)elecHsCount / (double)hsCount * 100.0);
                dept.setElecHsRate(elecHsRate);
                newDeptList.add(dept);
            }
            int totalElecHsCount = newDeptList.stream().mapToInt(ExportHsSettlementByDept::getElecHsCount).sum();
            int totalHsCount = newDeptList.stream().mapToInt(ExportHsSettlementByDept::getHsCount).sum();
            String totalElecHsRate = totalElecHsCount == 0 ? "0%" : String.format("%.2f%%", (double)totalElecHsCount / (double)totalHsCount * 100.0);
            ExportHsSettlementByDept totalDept = new ExportHsSettlementByDept();
            totalDept.setDeptName("\u5408\u8ba1");
            totalDept.setElecHsCount(Integer.valueOf(totalElecHsCount));
            totalDept.setHsCount(Integer.valueOf(totalHsCount));
            totalDept.setElecHsRate(totalElecHsRate);
            newDeptList.add(totalDept);
        }
        if (!checkList.isEmpty()) {
            int totalElecHsCount = checkList.stream().mapToInt(ExportHsSettlementByCheckId::getElecHsCount).sum();
            int totalHsCount = checkList.stream().mapToInt(ExportHsSettlementByCheckId::getHsCount).sum();
            String totalElecHsRate = totalElecHsCount == 0 ? "0%" : String.format("%.2f%%", (double)totalElecHsCount / (double)totalHsCount * 100.0);
            ExportHsSettlementByCheckId totalCheck = new ExportHsSettlementByCheckId();
            totalCheck.setCheckName("\u5408\u8ba1");
            totalCheck.setElecHsCount(Integer.valueOf(totalElecHsCount));
            totalCheck.setHsCount(Integer.valueOf(totalHsCount));
            totalCheck.setElecHsRate(totalElecHsRate);
            checkList.add(totalCheck);
        }
        if (!totalCheckList.isEmpty()) {
            int totalElecHsCount = totalCheckList.stream().mapToInt(ExportHsSettlementByCheckId::getElecHsCount).sum();
            int totalHsCount = totalCheckList.stream().mapToInt(ExportHsSettlementByCheckId::getHsCount).sum();
            String totalElecHsRate = totalElecHsCount == 0 ? "0%" : String.format("%.2f%%", (double)totalElecHsCount / (double)totalHsCount * 100.0);
            ExportHsSettlementByCheckId totalCheck = new ExportHsSettlementByCheckId();
            totalCheck.setCheckName("\u5408\u8ba1");
            totalCheck.setElecHsCount(Integer.valueOf(totalElecHsCount));
            totalCheck.setHsCount(Integer.valueOf(totalHsCount));
            totalCheck.setElecHsRate(totalElecHsRate);
            totalCheckList.add(totalCheck);
        }
        try {
            int i;
            String fileName = URLEncoder.encode("\u7edf\u8ba1\u62a5\u8868", "UTF-8").replaceAll("\\+", "%20");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ExcelWriter excelWriter = EasyExcel.write((OutputStream)outputStream).build();
            WriteSheet sheet = EasyExcel.writerSheet((String)"\u7edf\u8ba1\u62a5\u8868").build();
            ArrayList<List<Object>> deptData = new ArrayList<List<Object>>();
            deptData.add(Arrays.asList(range, "", "", ""));
            deptData.add(Arrays.asList("\u90e8\u95e8", "\u7535\u5b50\u533b\u4fdd\u7ed3\u7b97\u6b21\u6570", "\u603b\u7ed3\u7b97\u6b21\u6570", "\u7535\u5b50\u533b\u4fdd\u7ed3\u7b97\u7387"));
            for (ExportHsSettlementByDept entity : newDeptList) {
                String deptName = entity.getDeptName();
                Integer elecHsCount = entity.getElecHsCount();
                Integer hsCount = entity.getHsCount();
                String elecHsRate = entity.getElecHsRate();
                deptData.add(Arrays.asList(deptName, elecHsCount, hsCount, elecHsRate));
            }
            excelWriter.write(deptData, sheet);
            int deptRowCount = deptData.size();
            ArrayList<List<Object>> checkData = new ArrayList<List<Object>>();
            checkData.add(Arrays.asList("", "", "", ""));
            checkData.add(Arrays.asList("", "", "", ""));
            checkData.add(Arrays.asList(range, "", "", ""));
            checkData.add(Arrays.asList("\u6536\u8d39\u5458\u59d3\u540d", "\u7535\u5b50\u533b\u4fdd\u7ed3\u7b97\u6b21\u6570", "\u7ed3\u7b97\u603b\u6b21\u6570", "\u7535\u5b50\u533b\u4fdd\u7ed3\u7b97\u7387"));
            for (ExportHsSettlementByCheckId entity : checkList) {
                String checkName = entity.getCheckName();
                Integer elecHsCount = entity.getElecHsCount();
                Integer hsCount = entity.getHsCount();
                String elecHsRate = entity.getElecHsRate();
                checkData.add(Arrays.asList(checkName, elecHsCount, hsCount, elecHsRate));
            }
            excelWriter.write(checkData, sheet);
            int checkRowCount = checkData.size();
            ArrayList<List<Object>> dayTotalData = new ArrayList<List<Object>>();
            dayTotalData.add(Arrays.asList("", "", ""));
            dayTotalData.add(Arrays.asList("", "", ""));
            dayTotalData.add(Arrays.asList(range, "", ""));
            dayTotalData.add(Arrays.asList("\u7535\u5b50\u533b\u4fdd\u7ed3\u7b97\u6b21\u6570", "\u7ed3\u7b97\u603b\u6b21\u6570", "\u7535\u5b50\u533b\u4fdd\u7ed3\u7b97\u7387"));
            for (ExportHsSettlementTotal entity : dayTotalList) {
                Integer elecHsCount = entity.getElecHsCount();
                Integer hsCount = entity.getHsCount();
                String elecHsRate = entity.getElecHsRate();
                dayTotalData.add(Arrays.asList(elecHsCount, hsCount, elecHsRate));
            }
            excelWriter.write(dayTotalData, sheet);
            int dayTotalRowCount = dayTotalData.size();
            ArrayList<List<Object>> monthDeptData = new ArrayList<List<Object>>();
            monthDeptData.add(Arrays.asList("", "", "", ""));
            monthDeptData.add(Arrays.asList("", "", "", ""));
            monthDeptData.add(Arrays.asList(totalRange, "", "", ""));
            monthDeptData.add(Arrays.asList("\u90e8\u95e8", "\u7535\u5b50\u533b\u4fdd\u7ed3\u7b97\u6b21\u6570", "\u7ed3\u7b97\u603b\u6b21\u6570", "\u7535\u5b50\u533b\u4fdd\u7ed3\u7b97\u7387"));
            for (ExportHsSettlementByDept entity : totalDeptList) {
                String deptName = entity.getDeptName();
                Integer elecHsCount = entity.getElecHsCount();
                Integer hsCount = entity.getHsCount();
                String elecHsRate = entity.getElecHsRate();
                monthDeptData.add(Arrays.asList(deptName, elecHsCount, hsCount, elecHsRate));
            }
            excelWriter.write(monthDeptData, sheet);
            int monthDeptRowCount = monthDeptData.size();
            ArrayList<List<Object>> monthCheckData = new ArrayList<List<Object>>();
            monthCheckData.add(Arrays.asList("", "", "", ""));
            monthCheckData.add(Arrays.asList("", "", "", ""));
            monthCheckData.add(Arrays.asList(totalRange, "", "", ""));
            monthCheckData.add(Arrays.asList("\u6536\u8d39\u5458\u59d3\u540d", "\u7535\u5b50\u533b\u4fdd\u7ed3\u7b97\u6b21\u6570", "\u7ed3\u7b97\u603b\u6b21\u6570", "\u7535\u5b50\u533b\u4fdd\u7ed3\u7b97\u7387"));
            for (ExportHsSettlementByCheckId entity : totalCheckList) {
                String checkName = entity.getCheckName();
                Integer elecHsCount = entity.getElecHsCount();
                Integer hsCount = entity.getHsCount();
                String elecHsRate = entity.getElecHsRate();
                monthCheckData.add(Arrays.asList(checkName, elecHsCount, hsCount, elecHsRate));
            }
            excelWriter.write(monthCheckData, sheet);
            int monthCheckRowCOunt = monthCheckData.size();
            ArrayList<List<Object>> totalData = new ArrayList<List<Object>>();
            totalData.add(Arrays.asList("", "", ""));
            totalData.add(Arrays.asList("", "", ""));
            totalData.add(Arrays.asList(totalRange, "", ""));
            totalData.add(Arrays.asList("\u7535\u5b50\u533b\u4fdd\u7ed3\u7b97\u6b21\u6570", "\u7ed3\u7b97\u603b\u6b21\u6570", "\u7535\u5b50\u533b\u4fdd\u7ed3\u7b97\u7387"));
            for (ExportHsSettlementTotal entity : totalList) {
                Integer elecHsCount = entity.getElecHsCount();
                Integer hsCount = entity.getHsCount();
                String elecHsRate = entity.getElecHsRate();
                totalData.add(Arrays.asList(elecHsCount, hsCount, elecHsRate));
            }
            excelWriter.write(totalData, sheet);
            int totalRowCount = totalData.size();
            excelWriter.finish();
            byte[] excelBytes = outputStream.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(excelBytes);
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet poiSheet = workbook.getSheetAt(0);
            Font headerFont = workbook.createFont();
            headerFont.setBold(true);
            headerFont.setColor(IndexedColors.RED.getIndex());
            headerFont.setFontHeightInPoints((short)14);
            CellStyle headerCellStyle = workbook.createCellStyle();
            headerCellStyle.setFont(headerFont);
            headerCellStyle.setAlignment(HorizontalAlignment.CENTER);
            headerCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            poiSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 3));
            Row headerRow = poiSheet.getRow(0);
            Cell headerCell = headerRow.getCell(0);
            if (headerCell == null) {
                headerCell = headerRow.createCell(0);
            }
            headerCell.setCellStyle(headerCellStyle);
            int checkHeadRow = deptRowCount + 2;
            poiSheet.addMergedRegion(new CellRangeAddress(checkHeadRow, checkHeadRow, 0, 3));
            Row checkHeaderRow = poiSheet.getRow(checkHeadRow);
            Cell checkHeaderCell = checkHeaderRow.getCell(0);
            if (checkHeaderCell == null) {
                checkHeaderCell = checkHeaderRow.createCell(0);
            }
            checkHeaderCell.setCellStyle(headerCellStyle);
            int dayTotalHeadRow = deptRowCount + checkRowCount + 2;
            poiSheet.addMergedRegion(new CellRangeAddress(dayTotalHeadRow, dayTotalHeadRow, 0, 2));
            Row dayTotalHeaderRow = poiSheet.getRow(dayTotalHeadRow);
            Cell dayTotalHeaderCell = dayTotalHeaderRow.getCell(0);
            if (dayTotalHeaderCell == null) {
                dayTotalHeaderCell = dayTotalHeaderRow.createCell(0);
            }
            dayTotalHeaderCell.setCellStyle(headerCellStyle);
            int monthDeptHeadRow = deptRowCount + checkRowCount + dayTotalRowCount + 2;
            poiSheet.addMergedRegion(new CellRangeAddress(monthDeptHeadRow, monthDeptHeadRow, 0, 3));
            Row monthDeptHeaderRow = poiSheet.getRow(monthDeptHeadRow);
            Cell monthDeptHeaderCell = monthDeptHeaderRow.getCell(0);
            if (monthDeptHeaderCell == null) {
                monthDeptHeaderCell = monthDeptHeaderRow.createCell(0);
            }
            monthDeptHeaderCell.setCellStyle(headerCellStyle);
            int monthCheckHeadRow = deptRowCount + checkRowCount + monthDeptRowCount + dayTotalRowCount + 2;
            poiSheet.addMergedRegion(new CellRangeAddress(monthCheckHeadRow, monthCheckHeadRow, 0, 3));
            Row monthCheckHeaderRow = poiSheet.getRow(monthCheckHeadRow);
            Cell monthCheckHeaderCell = monthCheckHeaderRow.getCell(0);
            if (monthCheckHeaderCell == null) {
                monthCheckHeaderCell = monthCheckHeaderRow.getCell(0);
            }
            monthCheckHeaderCell.setCellStyle(headerCellStyle);
            int totalHeadRow = deptRowCount + checkRowCount + monthDeptRowCount + monthCheckRowCOunt + dayTotalRowCount + 2;
            poiSheet.addMergedRegion(new CellRangeAddress(totalHeadRow, totalHeadRow, 0, 2));
            Row totalHeaderRow = poiSheet.getRow(totalHeadRow);
            Cell totalHeaderCell = totalHeaderRow.getCell(0);
            if (totalHeaderCell == null) {
                totalHeaderCell = totalHeaderRow.createCell(0);
            }
            totalHeaderCell.setCellStyle(headerCellStyle);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            int totalRow = deptRowCount + checkRowCount + totalRowCount + monthDeptRowCount + monthCheckRowCOunt + dayTotalRowCount + 10;
            for (i = 0; i < totalRow; ++i) {
                Row row = poiSheet.getRow(i);
                if (row == null) continue;
                for (int j = 0; j < row.getLastCellNum(); ++j) {
                    Cell cell = row.getCell(j);
                    if (cell == null || i == 0 || i == checkHeadRow || i == totalHeadRow || i == monthDeptHeadRow || i == monthCheckHeadRow || i == dayTotalHeadRow) continue;
                    cell.setCellStyle(cellStyle);
                }
            }
            poiSheet.setDefaultRowHeightInPoints(25.0f);
            for (i = 0; i < 5; ++i) {
                poiSheet.setColumnWidth(i, 7680);
            }
            try (ServletOutputStream responseOutputStream = response.getOutputStream();){
                workbook.write((OutputStream)responseOutputStream);
            }
            workbook.close();
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
            e.printStackTrace();
        }
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void insertDetailList(QueryDetailDto dto) {
        Integer tenantId = dto.getTenantId();
        List hsInfoList = this.outHsSettlementInfoMapper.selectListBySetlTime(dto);
        if (!hsInfoList.isEmpty()) {
            ArrayList<OutHsSettlementInfoDetaiEntity> detailList = new ArrayList<OutHsSettlementInfoDetaiEntity>();
            for (HsSettlementInfoEntity entity : hsInfoList) {
                String setlId = entity.getSetl_id();
                String setlDetail = entity.getSetldetail();
                if ("null".equals(setlDetail) || "[]".equals(setlDetail) || !StrUtil.isNotEmpty((CharSequence)setlDetail)) continue;
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    JsonNode jsonArray = objectMapper.readTree(setlDetail);
                    for (JsonNode jsonNode : jsonArray) {
                        OutHsSettlementInfoDetaiEntity detail = new OutHsSettlementInfoDetaiEntity();
                        String fundPayType = jsonNode.has("fund_pay_type") ? jsonNode.get("fund_pay_type").asText() : null;
                        String fundPayTypeName = jsonNode.has("fund_pay_type_name") ? jsonNode.get("fund_pay_type_name").asText() : null;
                        BigDecimal fundPayAmt = jsonNode.has("fund_payamt") ? jsonNode.get("fund_payamt").decimalValue() : BigDecimal.ZERO;
                        BigDecimal inscpScpAmt = jsonNode.has("inscp_scp_amt") ? jsonNode.get("inscp_scp_amt").decimalValue() : BigDecimal.ZERO;
                        String setlProcInfo = jsonNode.has("setl_proc_info") ? jsonNode.get("setl_proc_info").asText() : null;
                        detail.setTenantId(tenantId);
                        detail.setSetlId(setlId);
                        detail.setFundPayType(fundPayType);
                        if (!StrUtil.isBlank((CharSequence)detail.getFundPayType())) {
                            SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
                            sysDictValueDTO.setType("fund_pay_type");
                            sysDictValueDTO.setValue(detail.getFundPayType());
                            ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, tenantId + "");
                            List data = ((Page)pageResponseData.getData()).getRecords();
                            detail.setFundPayTypeName(data == null || data.isEmpty() ? "" : ((SysDictValueVo)data.get(0)).getLabel());
                        }
                        detail.setFundPayamt(fundPayAmt);
                        detail.setInscpScpAmt(inscpScpAmt);
                        detail.setSetlProcInfo(setlProcInfo);
                        detailList.add(detail);
                    }
                }
                catch (Exception e) {
                    ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)e.getMessage());
                }
            }
            if (!detailList.isEmpty()) {
                List setlIds = detailList.stream().map(OutHsSettlementInfoDetaiEntity::getSetlId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
                LambdaQueryWrapper detailDeleteWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(tenantId != null, OutHsSettlementInfoDetaiEntity::getTenantId, (Object)tenantId)).in(OutHsSettlementInfoDetaiEntity::getSetlId, setlIds);
                this.outHsSettlementInfoDetailMapper.delete((Wrapper)detailDeleteWrapper);
                this.outHsSettlementInfoDetailMapper.insertList(detailList);
            }
        }
    }

    public ResponseData<PageResult<HsSettlementReportListVo>> hsSettlementList(HsSettlementReportListDto hsSettlementReportListDto) {
        if (Objects.isNull(hsSettlementReportListDto.getSettlementMethod())) {
            hsSettlementReportListDto.setSettlementMethod(SettlementMethodEnum.STATUS_MEDICARE_STTLE.getValue());
        }
        PageHelper.startPage((int)hsSettlementReportListDto.getCurrent(), (int)hsSettlementReportListDto.getSize());
        List hsSettlementReportListVos = this.outOrderPaymentMapper.queryHsSettlment(hsSettlementReportListDto);
        for (HsSettlementReportListVo record : hsSettlementReportListVos) {
            String patientName = HyposensitizationUtil.hyposensitizationForName((String)record.getPatientName());
            String cardNo = HyposensitizationUtil.hyposensitizationForCardNo((String)record.getPatientCardNo());
            record.setPatientName(patientName);
            record.setPatientCardNo(cardNo);
        }
        PageInfo pageInfo = new PageInfo(hsSettlementReportListVos);
        PageResult pageResult = new PageResult(hsSettlementReportListDto.getCurrent(), hsSettlementReportListDto.getSize());
        pageResult.setTotal(Integer.parseInt(String.valueOf(pageInfo.getTotal())));
        pageResult.setPages(pageInfo.getPages());
        pageResult.setRecords(hsSettlementReportListVos);
        pageResult.setCurrent(hsSettlementReportListDto.getCurrent());
        pageResult.setSize(hsSettlementReportListDto.getSize());
        return ResponseData.success((Object)pageResult);
    }

    public ResponseData<?> hsSettlementDetail(HsSettlementDetailDto hsSettlementDetailDto) {
        GetSettlementInfoRequest getSettlementInfoRequest = new GetSettlementInfoRequest();
        getSettlementInfoRequest.setPsn_no(hsSettlementDetailDto.getPsnNo());
        getSettlementInfoRequest.setMdtrt_id(hsSettlementDetailDto.getMdtrtId());
        getSettlementInfoRequest.setSetl_id(hsSettlementDetailDto.getSetlId());
        getSettlementInfoRequest.setSign_no(hsSettlementDetailDto.getSignNo());
        getSettlementInfoRequest.setOpter(hsSettlementDetailDto.getOpter());
        getSettlementInfoRequest.setOpter_name(hsSettlementDetailDto.getOpterName());
        getSettlementInfoRequest.setOpter_type(hsSettlementDetailDto.getOpterType());
        getSettlementInfoRequest.setInsuplc_admdvs(hsSettlementDetailDto.getInsuplcAdmdvs());
        getSettlementInfoRequest.setTenantId(hsSettlementDetailDto.getTenantId());
        log.info("\u8c03\u7528\u533b\u4fdd\u67e5\u8be2\u7ed3\u7b97\u4fe1\u606f\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)getSettlementInfoRequest));
        ResponseData hsBaseResponseResponseData = this.hsServiceFeign.settlementInfo(getSettlementInfoRequest);
        log.info("\u8c03\u7528\u533b\u4fdd\u67e5\u8be2\u7ed3\u7b97\u4fe1\u606f\u8fd4\u56de{}", (Object)JSONObject.toJSONString((Object)hsBaseResponseResponseData));
        if (!Objects.isNull(hsBaseResponseResponseData) && hsBaseResponseResponseData.isSuccess() && !Objects.isNull(hsBaseResponseResponseData.getData())) {
            JSONObject output = (JSONObject)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput();
            if (Objects.isNull(output.get((Object)"setlinfo"))) {
                HsSettlementInfoEntity hsSettlementInfoEntity = this.outHsSettlementInfoMapper.queryHsSettlmentInfo(hsSettlementDetailDto.getSetlId());
                HsSettlementDetailVo hsSettlementDetailVo = new HsSettlementDetailVo();
                hsSettlementDetailVo.setSetlinfo(hsSettlementInfoEntity);
                List list = (List)JSONObject.parseObject((String)hsSettlementInfoEntity.getSetldetail(), List.class);
                hsSettlementDetailVo.setSetldetail(list);
                return ResponseData.success((Object)hsSettlementDetailVo);
            }
            return ResponseData.success((Object)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput());
        }
        return ResponseData.success();
    }

    public ResponseData<List<ReconciliationTotalResponse>> reconciliationTotalNew(ReconciliationTotalDto reconciliationTotalDto) {
        String lastDay = DateUtils.getLastDay((int)reconciliationTotalDto.getYear(), (int)reconciliationTotalDto.getMonth());
        String firstDay = DateUtils.getFirstDay((int)reconciliationTotalDto.getYear(), (int)reconciliationTotalDto.getMonth());
        reconciliationTotalDto.setStartDate(firstDay);
        reconciliationTotalDto.setEndDate(lastDay);
        List totalHsSettlmentResList = this.outHsSettlementInfoMapper.queryHsSettlmentTotalList(reconciliationTotalDto);
        if (totalHsSettlmentResList.size() < 1) {
            return ResponseData.error((String)"\u5f53\u6708\u6ca1\u6709\u7ed3\u7b97\u5355\uff01");
        }
        ArrayList<ReconciliationTotalResponse> resultList = new ArrayList<ReconciliationTotalResponse>();
        for (TotalHsSettlmentRes totalHsSettlmentRes : totalHsSettlmentResList) {
            ReconciliationTotalRequest reconciliationTotalRequest = new ReconciliationTotalRequest();
            reconciliationTotalRequest.setClr_type(reconciliationTotalDto.getClrType());
            reconciliationTotalRequest.setOpter(reconciliationTotalDto.getOpter());
            reconciliationTotalRequest.setOpter_name(reconciliationTotalDto.getOpterName());
            reconciliationTotalRequest.setOpter_type(reconciliationTotalDto.getOpterType());
            reconciliationTotalRequest.setAcct_pay(totalHsSettlmentRes.getAcctPay());
            reconciliationTotalRequest.setFund_pay_sumamt(totalHsSettlmentRes.getFundPaySumamt());
            reconciliationTotalRequest.setMedfee_sumamt(totalHsSettlmentRes.getMedfeeSumamt());
            reconciliationTotalRequest.setTenantId(reconciliationTotalDto.getTenantId());
            reconciliationTotalRequest.setInsutype(totalHsSettlmentRes.getInsutype());
            reconciliationTotalRequest.setFixmedins_setl_cnt(totalHsSettlmentRes.getFixmedinsSetlCnt());
            reconciliationTotalRequest.setStmt_begndate(firstDay + " 00:00:00");
            reconciliationTotalRequest.setStmt_enddate(lastDay + " 23:59:59");
            reconciliationTotalRequest.setSetl_optins(reconciliationTotalDto.getSetlOptins());
            log.info("---\u5bf9\u603b\u8d26\u63a5\u53e3\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)reconciliationTotalRequest));
            ResponseData reconciliationTotalResponseResponseData = this.hsServiceFeign.reconciliationTotal(reconciliationTotalRequest);
            log.info("+++\u5bf9\u603b\u8d26\u63a5\u53e3\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)reconciliationTotalResponseResponseData));
            if (!Objects.isNull(reconciliationTotalResponseResponseData) && reconciliationTotalResponseResponseData.isSuccess()) {
                ReconciliationTotalResponse data = (ReconciliationTotalResponse)reconciliationTotalResponseResponseData.getData();
                data.setStartDate(firstDay + " 00:00:00");
                data.setEndDate(lastDay + " 23:59:59");
                BeanUtils.copyProperties((Object)totalHsSettlmentRes, (Object)data);
                data.setClrType(reconciliationTotalDto.getClrType());
                resultList.add(data);
                continue;
            }
            return ResponseData.error((String)this.handleMsg(reconciliationTotalResponseResponseData.getMsg()));
        }
        return ResponseData.success(resultList);
    }

    public ResponseData<List<ReconciliationTotalResponse>> reconciliationTotal(ReconciliationTotalDto reconciliationTotalDto) {
        String lastDay = DateUtils.getLastDay((int)reconciliationTotalDto.getYear(), (int)reconciliationTotalDto.getMonth());
        String firstDay = DateUtils.getFirstDay((int)reconciliationTotalDto.getYear(), (int)reconciliationTotalDto.getMonth());
        List totalHsSettlmentResList = this.outOrderPaymentMapper.queryHsSettlmentTotalList(reconciliationTotalDto);
        if (totalHsSettlmentResList.size() < 1) {
            return ResponseData.error((String)"\u5f53\u6708\u6ca1\u6709\u7ed3\u7b97\u5355\uff01");
        }
        ArrayList<ReconciliationTotalResponse> resultList = new ArrayList<ReconciliationTotalResponse>();
        for (TotalHsSettlmentRes totalHsSettlmentRes : totalHsSettlmentResList) {
            ReconciliationTotalRequest reconciliationTotalRequest = new ReconciliationTotalRequest();
            reconciliationTotalRequest.setClr_type(reconciliationTotalDto.getClrType());
            reconciliationTotalRequest.setOpter(reconciliationTotalDto.getOpter());
            reconciliationTotalRequest.setOpter_name(reconciliationTotalDto.getOpterName());
            reconciliationTotalRequest.setOpter_type(reconciliationTotalDto.getOpterType());
            reconciliationTotalRequest.setAcct_pay(totalHsSettlmentRes.getAcctPay());
            reconciliationTotalRequest.setFund_pay_sumamt(totalHsSettlmentRes.getFundPaySumamt());
            reconciliationTotalRequest.setMedfee_sumamt(totalHsSettlmentRes.getMedfeeSumamt());
            reconciliationTotalRequest.setTenantId(reconciliationTotalDto.getTenantId());
            reconciliationTotalRequest.setInsutype(totalHsSettlmentRes.getInsutype());
            reconciliationTotalRequest.setFixmedins_setl_cnt(totalHsSettlmentRes.getFixmedinsSetlCnt());
            reconciliationTotalRequest.setStmt_begndate(firstDay + " 00:00:00");
            reconciliationTotalRequest.setStmt_enddate(lastDay + " 23:59:59");
            log.info("---\u5bf9\u603b\u8d26\u63a5\u53e3\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)reconciliationTotalRequest));
            ResponseData reconciliationTotalResponseResponseData = this.hsServiceFeign.reconciliationTotal(reconciliationTotalRequest);
            log.info("+++\u5bf9\u603b\u8d26\u63a5\u53e3\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)reconciliationTotalResponseResponseData));
            if (!Objects.isNull(reconciliationTotalResponseResponseData) && reconciliationTotalResponseResponseData.isSuccess()) {
                ReconciliationTotalResponse data = (ReconciliationTotalResponse)reconciliationTotalResponseResponseData.getData();
                data.setStartDate(firstDay + " 00:00:00");
                data.setEndDate(lastDay + " 23:59:59");
                BeanUtils.copyProperties((Object)totalHsSettlmentRes, (Object)data);
                data.setClrType(reconciliationTotalDto.getClrType());
                resultList.add(data);
                continue;
            }
            return ResponseData.error((String)this.handleMsg(reconciliationTotalResponseResponseData.getMsg()));
        }
        return ResponseData.success(resultList);
    }

    private String handleMsg(String str) {
        InsutypeEnum[] values = InsutypeEnum.values();
        for (int i = 0; i < values.length; ++i) {
            if (!str.contains(values[0].getValue())) continue;
            str = str.replace(values[0].getValue(), values[0].getDesc());
        }
        return str;
    }

    public List<ExcelHsSettlementInfo> exportHsSettlementInfoList(ReconciliationTotalDto reconciliationTotalDto) {
        String firstDay = DateUtils.getFirstDay((int)reconciliationTotalDto.getYear(), (int)reconciliationTotalDto.getMonth()) + " 00:00:00";
        String lastDay = DateUtils.getLastDay((int)reconciliationTotalDto.getYear(), (int)reconciliationTotalDto.getMonth()) + " 23:59:59";
        reconciliationTotalDto.setStartDate(firstDay);
        reconciliationTotalDto.setEndDate(lastDay);
        List list = this.outHsSettlementInfoMapper.queryExprotList(reconciliationTotalDto);
        return list;
    }

    public List<ExcelHsSettlementInfoNew> urbanEmployeesHsSettlementInfo(ReconciliationTotalDto reconciliationTotalDto) {
        if (reconciliationTotalDto.getStartDate() == null) {
            String firstDay = DateUtils.getFirstDay((int)reconciliationTotalDto.getYear(), (int)reconciliationTotalDto.getMonth()) + " 00:00:00";
            reconciliationTotalDto.setStartDate(firstDay);
        }
        if (reconciliationTotalDto.getEndDate() == null) {
            String lastDay = DateUtils.getLastDay((int)reconciliationTotalDto.getYear(), (int)reconciliationTotalDto.getMonth()) + " 23:59:59";
            reconciliationTotalDto.setEndDate(lastDay);
        }
        List list = this.outHsSettlementInfoMapper.urbanEmployeesHsSettlementInfo(reconciliationTotalDto);
        return list;
    }

    public List<ExcelHsSettlementInfoSummary> hsSettlmentInfoSummary(ReconciliationTotalDto entity) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        List excelHsSettlementInfoSummaries = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryNew(entity);
        return excelHsSettlementInfoSummaries;
    }

    public List<List<?>> hsSettlmentInfoSummaryByMedType(ReconciliationTotalDto entity) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ArrayList data = new ArrayList();
        Integer tenantId = entity.getTenantId();
        List dictValueList = this.outHsSettlementInfoMapper.selectDictListByType("admdvs", tenantId);
        Map<String, String> dictMap = dictValueList.stream().collect(Collectors.toMap(DictValueVo::getValue, DictValueVo::getLabel));
        entity.setInsutype("310");
        entity.setMedType("11");
        entity.setIsOffsite("0");
        List list1 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByMedType(entity);
        list1 = this.getInsuplcAdmdvsLabelForTotal(list1, dictMap);
        data.add(list1);
        entity.setInsutype("310");
        entity.setMedType("14");
        entity.setIsOffsite("0");
        List list2 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByMedType(entity);
        list2 = this.getInsuplcAdmdvsLabelForTotal(list2, dictMap);
        data.add(list2);
        entity.setInsutype("310");
        entity.setMedType(null);
        entity.setIsOffsite("0");
        entity.setHifmiPay(new BigDecimal(10));
        List list3 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByMedType(entity);
        list3 = this.getInsuplcAdmdvsLabelForTotal(list3, dictMap);
        data.add(list3);
        entity.setInsutype("390");
        entity.setMedType("11");
        entity.setHifmiPay(null);
        entity.setIsOffsite("0");
        List list4 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByMedType(entity);
        list4 = this.getInsuplcAdmdvsLabelForTotal(list4, dictMap);
        data.add(list4);
        entity.setInsutype("390");
        entity.setMedType("14");
        entity.setIsOffsite("0");
        List list5 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByMedType(entity);
        list5 = this.getInsuplcAdmdvsLabelForTotal(list5, dictMap);
        data.add(list5);
        entity.setInsutype("390");
        entity.setMedType(null);
        entity.setHifmiPay(new BigDecimal(10));
        entity.setIsOffsite("0");
        List list6 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByMedType(entity);
        list6 = this.getInsuplcAdmdvsLabelForTotal(list6, dictMap);
        data.add(list6);
        entity.setInsutype("310");
        entity.setMedType("11");
        entity.setHifmiPay(null);
        entity.setIsOffsite("0");
        List list7 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByMedTypeDetail(entity);
        list7 = this.getInsuplcAdmdvsLabelForDetail(list7, dictMap);
        data.add(list7);
        entity.setInsutype("310");
        entity.setMedType("14");
        entity.setIsOffsite("0");
        List list8 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByMedTypeDetail(entity);
        list8 = this.getInsuplcAdmdvsLabelForDetail(list8, dictMap);
        data.add(list8);
        entity.setHifmiPay(null);
        entity.setInsutype("390");
        entity.setMedType("11");
        entity.setIsOffsite("0");
        List list9 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByMedTypeDetail(entity);
        list9 = this.getInsuplcAdmdvsLabelForDetail(list9, dictMap);
        data.add(list9);
        entity.setInsutype("390");
        entity.setMedType("14");
        entity.setIsOffsite("0");
        List list10 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByMedTypeDetail(entity);
        list10 = this.getInsuplcAdmdvsLabelForDetail(list10, dictMap);
        data.add(list10);
        entity.setHifmiPay(null);
        entity.setIsOffsite("1");
        List list11 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByOffsite(entity);
        data.add(list11);
        entity.setIsOffsite("1");
        List list12 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByOffsiteDetail(entity);
        for (Object object : list12) {
            ExcelHsSettlementInfoSummaryByOffsiteDetail detail = (ExcelHsSettlementInfoSummaryByOffsiteDetail)object;
            String insuplcAdmdvs = detail.getInsuplcAdmdvs();
            String dictLabel = dictMap.get(insuplcAdmdvs);
            detail.setInsuplcAdmdvs(dictLabel);
        }
        data.add(list12);
        entity.setHifmiPay(null);
        entity.setIsOffsite("1");
        List list13 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByOffsiteSW(entity);
        data.add(list13);
        entity.setIsOffsite("1");
        List list14 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByOffsiteDetailSW(entity);
        for (Object object : list14) {
            ExcelHsSettlementInfoSummaryByOffsiteDetailSW detail = (ExcelHsSettlementInfoSummaryByOffsiteDetailSW)object;
            String insuplcAdmdvs = detail.getInsuplcAdmdvs();
            String dictLabel = dictMap.get(insuplcAdmdvs);
            detail.setInsuplcAdmdvs(dictLabel);
        }
        data.add(list14);
        entity.setInsutype("310");
        entity.setMedType(null);
        entity.setHifmiPay(new BigDecimal(10));
        entity.setIsOffsite("0");
        List listNew1 = this.outHsSettlementInfoMapper.excelHsSettlementInfoByHifmi(entity);
        listNew1 = this.getInsuplcAdmdvsLabelForCity(listNew1, dictMap);
        data.add(listNew1);
        entity.setInsutype("390");
        entity.setMedType(null);
        entity.setHifmiPay(new BigDecimal(10));
        entity.setIsOffsite("0");
        List listNew2 = this.outHsSettlementInfoMapper.excelHsSettlementInfoByHifmi(entity);
        listNew2 = this.getInsuplcAdmdvsLabelForCity(listNew2, dictMap);
        data.add(listNew2);
        return data;
    }

    private List<?> getInsuplcAdmdvsLabelForCity(List<?> list, Map<String, String> dictMap) {
        for (Object object : list) {
            ExcelHsSettlementInfoByHifmi hifmi = (ExcelHsSettlementInfoByHifmi)object;
            String insuplcAdmdvs = hifmi.getInsuplcAdmdvs();
            String dictLabel = dictMap.get(insuplcAdmdvs);
            hifmi.setInsuplcAdmdvs(dictLabel);
        }
        return list;
    }

    private List<?> getInsuplcAdmdvsLabelForTotal(List<?> list, Map<String, String> dictMap) {
        for (Object object : list) {
            ExcelHsSettlementInfoSummary summary = (ExcelHsSettlementInfoSummary)object;
            String insuplcAdmdvs = summary.getInsuplcAdmdvs();
            String dictLabel = dictMap.get(insuplcAdmdvs);
            summary.setInsuplcAdmdvs(dictLabel);
        }
        return list;
    }

    public List<?> getInsuplcAdmdvsLabelForDetail(List<?> list, Map<String, String> dictMap) {
        for (Object object : list) {
            ExcelHsSettlementInfoNew infoNew = (ExcelHsSettlementInfoNew)object;
            String insuplcAdmdvs = infoNew.getInsuplcAdmdvs();
            String dictLabel = dictMap.get(insuplcAdmdvs);
            infoNew.setInsuplcAdmdvs(dictLabel);
        }
        return list;
    }

    public List<List<?>> hsSettlmentInfoSummaryByClrType(ReconciliationTotalDto entity) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ArrayList data = new ArrayList();
        entity.setClrType("99902");
        List excelHsSettlementInfoSummaryByClrTypes = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByClrType(entity);
        data.add(excelHsSettlementInfoSummaryByClrTypes);
        List excelHsSettlementInfoSummaryByClrTypeDetails = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByClrTypeDetail(entity);
        data.add(excelHsSettlementInfoSummaryByClrTypeDetails);
        entity.setClrType("99901");
        List excelHsSettlementInfoSummaryByClrTypes1 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByClrType(entity);
        data.add(excelHsSettlementInfoSummaryByClrTypes1);
        List excelHsSettlementInfoSummaryByClrTypeDetails1 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByClrTypeDetail(entity);
        data.add(excelHsSettlementInfoSummaryByClrTypeDetails1);
        entity.setClrType("99903");
        List excelHsSettlementInfoSummaryByClrTypes2 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByClrType(entity);
        data.add(excelHsSettlementInfoSummaryByClrTypes2);
        List excelHsSettlementInfoSummaryByClrTypeDetails2 = this.outHsSettlementInfoMapper.hsSettlmentInfoSummaryByClrTypeDetail(entity);
        data.add(excelHsSettlementInfoSummaryByClrTypeDetails2);
        return data;
    }

    public List<?> parseMedType(List<?> list) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> aClass;
        if (list.size() != 0 && (aClass = list.get(0).getClass()).getMethod("getInsuplcAdmdvs", new Class[0]) != null) {
            for (Object o : list) {
                String invoke = (String)aClass.getMethod("getInsuplcAdmdvs", new Class[0]).invoke(o, new Object[0]);
                if (!invoke.matches("\\d+")) continue;
                String labelByValue = HsAreaCityEnum.getLabelByValue((Integer)Integer.valueOf(invoke));
                aClass.getMethod("setInsuplcAdmdvs", String.class).invoke(o, labelByValue);
            }
        }
        return list;
    }

    public List<CityWorkerHsSettlementInfo> cityWorkerHsSettlementInfo(ReconciliationTotalDto reconciliationTotalDto) {
        return null;
    }

    public ResponseData<HsSettlementInfoEntity> hsSettlementDetailLocal(HsSettlementDetailDto hsSettlementDetailDto) {
        HsSettlementInfoEntity hsSettlementInfoEntity = this.outHsSettlementInfoMapper.queryHsSettlmentInfo(hsSettlementDetailDto.getSetlId());
        try {
            GetSettlementInfoRequest getSettlementInfoRequest = new GetSettlementInfoRequest();
            getSettlementInfoRequest.setPsn_no(hsSettlementInfoEntity.getPsn_no());
            getSettlementInfoRequest.setMdtrt_id(hsSettlementInfoEntity.getMdtrt_id());
            getSettlementInfoRequest.setSetl_id(hsSettlementDetailDto.getSetlId());
            getSettlementInfoRequest.setSign_no(hsSettlementDetailDto.getSignNo());
            getSettlementInfoRequest.setOpter(hsSettlementDetailDto.getOpter());
            getSettlementInfoRequest.setOpter_name(hsSettlementDetailDto.getOpterName());
            getSettlementInfoRequest.setOpter_type(hsSettlementDetailDto.getOpterType());
            getSettlementInfoRequest.setInsuplc_admdvs(hsSettlementInfoEntity.getInsuplc_admdvs());
            getSettlementInfoRequest.setTenantId(hsSettlementDetailDto.getTenantId());
            log.info("\u8c03\u7528\u533b\u4fdd\u67e5\u8be2\u7ed3\u7b97\u4fe1\u606f\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)getSettlementInfoRequest));
            ResponseData hsBaseResponseResponseData = this.hsServiceFeign.costDetail(getSettlementInfoRequest);
            log.info("\u8c03\u7528\u533b\u4fdd\u67e5\u8be2\u7ed3\u7b97\u4fe1\u606f\u8fd4\u56de{}", (Object)JSONObject.toJSONString((Object)hsBaseResponseResponseData));
            if (!Objects.isNull(hsBaseResponseResponseData) && hsBaseResponseResponseData.isSuccess()) {
                List output = (List)((HsBaseResponse)hsBaseResponseResponseData.getData()).getOutput();
                hsSettlementInfoEntity.setFeeDetail(output);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.success((Object)hsSettlementInfoEntity);
    }
}

