/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.QueryOutIcdItemDto;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.exception.BusinessException;
import com.byh.outpatient.api.model.OutIcdItem;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.StringPinyinUtil;
import com.byh.outpatient.data.repository.OutIcdItemMapper;
import com.byh.outpatient.web.service.OutIcdItemService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class OutIcdItemServiceImpl
implements OutIcdItemService {
    private static final Logger log = LoggerFactory.getLogger(OutIcdItemServiceImpl.class);
    @Autowired
    private OutIcdItemMapper outIcdItemMapper;

    @Transactional(rollbackFor={BusinessException.class})
    public void changeForPyCode(Integer tenantId) {
        List icdItemList = this.outIcdItemMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutIcdItem::getTenantId, (Object)tenantId));
        for (OutIcdItem outIcdItem : icdItemList) {
            String pyCode = StringPinyinUtil.toFirstChar((String)outIcdItem.getIcdName());
            outIcdItem.setIcdNamePinyin(pyCode);
            this.outIcdItemMapper.update(null, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(OutIcdItem::getId, (Object)outIcdItem.getId())).set(OutIcdItem::getIcdNamePinyin, (Object)pyCode));
        }
    }

    public ResponseData<PageInfo<OutIcdItem>> queryIcd(QueryOutIcdItemDto parameter) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"tenant_id", (Object)parameter.getTenantId())).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq(!ObjectUtils.isEmpty((Object)parameter.getIcdCode()), (Object)"icd_code", (Object)parameter.getIcdCode())).eq(!ObjectUtils.isEmpty((Object)parameter.getDiagnosticType()), (Object)"diagnostic_type", (Object)parameter.getDiagnosticType())).eq(!ObjectUtils.isEmpty((Object)parameter.getMedicalInsuranceDiagnosisType()), (Object)"medical_insurance_diagnosis_type", (Object)parameter.getMedicalInsuranceDiagnosisType())).and(!ObjectUtils.isEmpty((Object)parameter.getIcdSerch()), i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)i.like(!ObjectUtils.isEmpty((Object)parameter.getDiagnosticType()), (Object)"icd_code", (Object)parameter.getIcdSerch())).or()).like((Object)"icd_name", (Object)parameter.getIcdSerch())).or()).like((Object)"icd_name_pinyin", (Object)parameter.getIcdSerch());
        })).orderByAsc((Object)"length(icd_name)  ");
        PageHelper.startPage((int)parameter.getPage(), (int)parameter.getPageSize());
        List outIcdItems = this.outIcdItemMapper.selectList((Wrapper)wrapper);
        PageInfo outIcdItemPageInfo = new PageInfo(outIcdItems);
        return ResponseData.success((Object)outIcdItemPageInfo);
    }

    public void addIcd(OutIcdItem entity) {
        entity.setStatus(Byte.valueOf((byte)1));
        entity.setCreateTime(new Date());
        this.outIcdItemMapper.insert((Object)entity);
    }

    public void editIcd(OutIcdItem entity) {
        entity.setUpdateTime(new Date());
        QueryWrapper updateWrapper = new QueryWrapper();
        updateWrapper.eq((Object)"id", (Object)entity.getId());
        this.outIcdItemMapper.update((Object)entity, (Wrapper)updateWrapper);
    }

    public void delIcd(OutIcdItem entity) {
        entity.setStatus(Byte.valueOf((byte)0));
        entity.setUpdateTime(new Date());
        QueryWrapper updateWrapper = new QueryWrapper();
        updateWrapper.eq((Object)"id", (Object)entity.getId());
        this.outIcdItemMapper.update((Object)entity, (Wrapper)updateWrapper);
    }

    public ResponseData<List<OutIcdItem>> queryIcdByCode(List<String> icdCodes, Integer tenantId) {
        log.info("idcCodes:{},tnantId:{}", icdCodes, (Object)tenantId);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant_id", (Object)tenantId);
        wrapper.eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue());
        wrapper.in((Object)"icd_code", icdCodes);
        List outIcdItems = this.outIcdItemMapper.selectList((Wrapper)wrapper);
        return ResponseData.success((Object)outIcdItems);
    }
}

