/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.byh.outpatient.api.dto.pay.ApplyForARefundDto;
import com.byh.outpatient.api.dto.pay.PayDto;
import com.byh.outpatient.api.dto.pay.PayRefundDto;
import com.byh.outpatient.api.dto.pay.PayReqDto;
import com.byh.outpatient.api.dto.pay.PaymentReturnDto;
import com.byh.outpatient.api.dto.prescription.OutPrescriptionDto;
import com.byh.outpatient.api.enums.DeliveryStatusEnum;
import com.byh.outpatient.api.enums.MedicalInsuranceTypeEnum;
import com.byh.outpatient.api.enums.OperationTypeEnum;
import com.byh.outpatient.api.enums.OutpatientDataStatusEnum;
import com.byh.outpatient.api.enums.PaymentMethodEnum;
import com.byh.outpatient.api.enums.PaymentRecordsStatusEnum;
import com.byh.outpatient.api.enums.PaymentStatusEnum;
import com.byh.outpatient.api.enums.PaymentTypeEnum;
import com.byh.outpatient.api.enums.RefundMethodEnum;
import com.byh.outpatient.api.enums.SettlementMethodEnum;
import com.byh.outpatient.api.enums.SourceEnum;
import com.byh.outpatient.api.model.order.OutOrder;
import com.byh.outpatient.api.model.order.OutOrderPayment;
import com.byh.outpatient.api.model.order.OutOrderPaymentRecord;
import com.byh.outpatient.api.model.order.OutTenantConfiguration;
import com.byh.outpatient.api.model.patient.PatientEntity;
import com.byh.outpatient.api.sysModel.request.SysEasyEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.util.UUIDUtils;
import com.byh.outpatient.api.vo.order.PayRefundVo;
import com.byh.outpatient.api.vo.order.PayVo;
import com.byh.outpatient.api.vo.pay.PayNotifyReqVO;
import com.byh.outpatient.api.vo.pay.RefundCallBackReqVo;
import com.byh.outpatient.data.repository.OutOrderMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentMapper;
import com.byh.outpatient.data.repository.OutOrderPaymentRecordMapper;
import com.byh.outpatient.data.repository.OutTenantConfigurationMapper;
import com.byh.outpatient.web.factroy.PayFactory;
import com.byh.outpatient.web.feign.SdkServiceFeign;
import com.byh.outpatient.web.manger.OrderPayManage;
import com.byh.outpatient.web.mvc.controller.RocketMQProducerController;
import com.byh.outpatient.web.mvc.exception.RunDisplayException;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.rocket.RocketMQProducer;
import com.byh.outpatient.web.service.OutInvoiceService;
import com.byh.outpatient.web.service.OutPrescriptionService;
import com.byh.outpatient.web.service.PayService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayWechatPaymentCodeImpl
implements PayService,
InitializingBean {
    private static Logger log = LoggerFactory.getLogger(PayWechatPaymentCodeImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(RocketMQProducerController.class);
    private static final String topic = "rocketMQ-out-doctor";
    private static final String patientTopic = "rocketMQ-out-patientTopic";
    private static final String patientPaymentTopic = "rocketMQ-out-patientPaymentTopic";
    private static final String prescriptionDetailTopic = "rocketMQ-out-prescriptionDetailTopic";
    private static final String treatmentItemsTopic = "rocketMQ-out-treatmentItemsTopic";
    @Resource
    private RocketMQProducer rocketMQProducer;
    @Autowired
    private CommonRequest commonRequest;
    @Resource
    private OutPrescriptionService outPrescriptionService;
    @Autowired
    private OutOrderPaymentMapper outOrderPaymentMapper;
    @Autowired
    private OutOrderPaymentRecordMapper outOrderPaymentRecordMapper;
    @Autowired
    private OutOrderMapper outOrderMapper;
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private OutTenantConfigurationMapper outTenantConfigurationMapper;
    @Autowired
    private OutInvoiceService outInvoiceService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private SdkServiceFeign sdkServiceFeign;

    private void FPrint(List<OutOrder> outOrderList) {
        SysEasyEntity sysEasyEntity = new SysEasyEntity();
        for (OutOrder outOrder : outOrderList) {
            String prescriptionNo;
            if (outOrder == null || !StringUtils.isNotBlank((CharSequence)(prescriptionNo = outOrder.getPrescriptionNo()))) continue;
            sysEasyEntity.setId(prescriptionNo);
            this.sdkServiceFeign.printerReceipt(sysEasyEntity);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(rollbackFor={Exception.class})
    public ResponseData<PayVo> firstPayment(PayDto parameter, PaymentMethodEnum paymentMethodEnum, OutOrderPayment outOrderPayment, List<OutOrder> outOrderList) {
        if (!PaymentTypeEnum.ONLINE_PAYMENT.getValue().equals(parameter.getPaymentType())) {
            return ResponseData.error((String)"\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u53ea\u5141\u8bb8\u7ebf\u4e0a\u652f\u4ed8\uff01");
        }
        if (SourceEnum.ONLINE.getValue().equals(parameter.getSource())) {
            return this.onlieHlwyyPay(parameter, paymentMethodEnum, outOrderPayment, outOrderList);
        }
        if (StringUtils.isEmpty((CharSequence)parameter.getAuthCode())) {
            return ResponseData.error((String)"\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u8bf7\u4f20\u5165\u4ed8\u6b3e\u7801\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        queryWrapper.eq((Object)"tenant_id", (Object)parameter.getTenantId());
        queryWrapper.eq((Object)"biz_sys_seq", (Object)"YHS");
        OutTenantConfiguration outTenantConfiguration = (OutTenantConfiguration)this.outTenantConfigurationMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.isNull(outTenantConfiguration)) {
            return ResponseData.error((String)"\u8bf7\u68c0\u67e5\u652f\u4ed8\u914d\u7f6e");
        }
        String transactionNo = UUIDUtils.getTransactionNo();
        PayReqDto payReqDto = new PayReqDto();
        payReqDto.setBizSysSeq(outTenantConfiguration.getBizSysSeq());
        payReqDto.setPayType("MICROPAY");
        payReqDto.setPayChannel(paymentMethodEnum.getPayChannel());
        payReqDto.setMerchantId(outTenantConfiguration.getMerchantSeq());
        payReqDto.setApplyCode(outTenantConfiguration.getApplyCode());
        payReqDto.setOrderSeq(transactionNo);
        payReqDto.setPayAmount(outOrderPayment.getTotalAmount());
        payReqDto.setProductInfo(outOrderPayment.getPayOrderName());
        payReqDto.setApplyKey(outTenantConfiguration.getApplyKey());
        payReqDto.setAuthCode(parameter.getAuthCode());
        payReqDto.setTotalAmount(outOrderPayment.getTotalAmount());
        ResponseData tradeServer = this.orderPayManage.createTradeServer(payReqDto);
        if (!tradeServer.isSuccess()) {
            return ResponseData.error((String)tradeServer.getMsg());
        }
        PaymentReturnDto paymentReturnDto = (PaymentReturnDto)JSONObject.parseObject((String)((String)tradeServer.getData()), PaymentReturnDto.class);
        if (!paymentReturnDto.getReturnCode().equals("SUCCESS")) {
            return ResponseData.error((String)paymentReturnDto.getErrCodeDes());
        }
        if (!paymentReturnDto.getErrCode().equals("USERPAYING") && !paymentReturnDto.getErrCode().equals("SUCCESS")) {
            return ResponseData.error((String)paymentReturnDto.getErrCodeDes());
        }
        PaymentStatusEnum paymentStatusEnum = PaymentStatusEnum.PAYMENT_CONFIRMED;
        if (paymentReturnDto.getErrCode().equals("USERPAYING")) {
            paymentStatusEnum = PaymentStatusEnum.PAYMENT_REQUIRE_CUSTOMER_PASSWORD;
        }
        outOrderPayment.setPaymentType(parameter.getPaymentType());
        outOrderPayment.setActualPayment(outOrderPayment.getActualPayment() == null ? new BigDecimal(0) : outOrderPayment.getActualPayment());
        outOrderPayment.setActualPayment(outOrderPayment.getActualPayment().add(outOrderPayment.getTotalAmount()));
        outOrderPayment.setPaymentStatus(paymentStatusEnum.getValue());
        outOrderPayment.setPaymentMethod(paymentMethodEnum.getValue());
        outOrderPayment.setPaymentTime(new Date());
        outOrderPayment.setPaymentExpirationTime(null);
        outOrderPayment.setCheckerId(parameter.getOperatorId());
        outOrderPayment.setCheckerName(parameter.getOperatorName());
        int size = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        if (size == 0) {
            throw new RunDisplayException("\u53d8\u66f4\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        ArrayList<Object> outOrderPaymentRecords = new ArrayList<Object>();
        for (OutOrder order : outOrderList) {
            List list;
            order.setPayOrderNo(outOrderPayment.getPayOrderNo());
            order.setActualPayment(order.getTotalAmount());
            order.setPaymentStatus(paymentStatusEnum.getValue());
            int num = this.outOrderMapper.updateById((Object)order);
            if (num == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setDeliveryStatus(order.getDeliveryStatus());
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(outOrderPaymentRecord.getTotalAmount());
            outOrderPaymentRecord.setPaymentStatus(outOrderPayment.getPaymentStatus());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            if (outOrderPaymentRecord.getId() == null && (list = this.outOrderPaymentRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrderPaymentRecord::getTransactionNumber, (Object)transactionNo)).eq(OutOrderPaymentRecord::getPaymentStatus, (Object)outOrderPayment.getPaymentStatus())).eq(OutOrderPaymentRecord::getOrderNo, (Object)order.getOrderNo())).eq(OutOrderPaymentRecord::getAmount, (Object)order.getAmount())).eq(OutOrderPaymentRecord::getOperationType, (Object)OperationTypeEnum.PAYMENT.getValue()))).size() > 0) {
                Integer id = ((OutOrderPaymentRecord)list.get(0)).getId();
                outOrderPaymentRecord.setId(id);
            }
            outOrderPaymentRecords.add(outOrderPaymentRecord);
        }
        Integer recordSize = this.outOrderPaymentRecordMapper.batchInsert(outOrderPaymentRecords);
        if (recordSize.intValue() != outOrderList.size()) {
            throw new RunDisplayException("\u8bb0\u5f55\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        PayVo payVo = new PayVo();
        BeanUtils.copyProperties((Object)outOrderPayment, (Object)payVo);
        payVo.setName(outOrderPayment.getPatientName());
        payVo.setTransactionNumber(transactionNo);
        payVo.setOperationType(OperationTypeEnum.PAYMENT.getValue());
        List strings = this.outOrderMapper.dispenseMedicineByOrder(outOrderList);
        for (String string : strings) {
            void var20_24;
            OutPrescriptionDto dto = new OutPrescriptionDto();
            dto.setPrescriptionNo(string);
            Integer n = this.commonRequest.getTenant();
            Integer userId = this.commonRequest.getUserId();
            String userName = this.commonRequest.getUserName();
            if (n == null) {
                Integer n2 = parameter.getTenantId();
            }
            if (userId == null) {
                userId = (int)parameter.getOperatorId();
            }
            if (StringUtils.isBlank((CharSequence)userName)) {
                userName = parameter.getOperatorName();
            }
            dto.setTenantId((Integer)var20_24);
            dto.setOperatorId(userId);
            dto.setOperatorName(userName);
            dto.setMethodType("\u3010PayWechatPaymentCodeImpl\u3011\uff1afirstPayment");
            this.outPrescriptionService.dispenseMedicine(dto);
        }
        try {
            List outOrderPayments;
            String payOrderNo;
            String source;
            outOrderPayment.setPaymentStatusStr(PaymentStatusEnum.getValueEnum((Integer)outOrderPayment.getPaymentStatus()).getDesc());
            outOrderPayment.setPaymentMethodName(PaymentMethodEnum.getValueEnum((Integer)outOrderPayment.getPaymentMethod()).getDesc());
            outOrderPayment.setSettlementMethodName(SettlementMethodEnum.getValueEnum((Integer)outOrderPayment.getSettlementMethod()).getDesc());
            switch (source = outOrderPayment.getSource() != null ? outOrderPayment.getSource() : "") {
                case "1": {
                    outOrderPayment.setSource("\u7ebf\u4e0a");
                    break;
                }
                case "2": {
                    outOrderPayment.setSource("\u7ebf\u4e0b");
                }
            }
            Integer status = outOrderPayment.getStatus();
            switch (status) {
                case 0: {
                    outOrderPayment.setStatusName("\u5220\u9664");
                    break;
                }
                case 1: {
                    outOrderPayment.setStatusName("\u6b63\u5e38");
                    break;
                }
                case 2: {
                    outOrderPayment.setStatusName("\u5df2\u8fc7\u671f");
                    break;
                }
                case 3: {
                    outOrderPayment.setStatusName("\u5df2\u4f5c\u5e9f");
                }
            }
            for (OutOrder outOrder : outOrderList) {
                String source1;
                switch (source1 = outOrder.getSource() != null ? outOrder.getSource() : "") {
                    case "1": {
                        outOrder.setSource("\u7ebf\u4e0a");
                        break;
                    }
                    case "2": {
                        outOrder.setSource("\u7ebf\u4e0b");
                    }
                }
                Integer status1 = outOrder.getStatus();
                switch (status1) {
                    case 0: {
                        outOrder.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        outOrder.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        outOrder.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        outOrder.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                outOrder.setPaymentStatusStr(PaymentStatusEnum.getValueEnum((Integer)outOrder.getPaymentStatus()).getDesc());
                outOrder.setDeliveryStatusName(DeliveryStatusEnum.getValueEnum((Integer)(outOrder.getDeliveryStatus() != null ? outOrder.getDeliveryStatus() : 0)).getDesc());
            }
            for (OutOrderPaymentRecord outOrderPaymentRecord : outOrderPaymentRecords) {
                Integer status1 = outOrderPaymentRecord.getStatus();
                switch (status1) {
                    case 0: {
                        outOrderPaymentRecord.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        outOrderPaymentRecord.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        outOrderPaymentRecord.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        outOrderPaymentRecord.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                outOrderPaymentRecord.setPaymentMethodName(PaymentMethodEnum.getValueEnum((Integer)outOrderPaymentRecord.getPaymentMethod()).getDesc());
                outOrderPaymentRecord.setPaymentStatusName(PaymentStatusEnum.getValueEnum((Integer)outOrderPaymentRecord.getPaymentStatus()).getDesc());
                if (outOrderPaymentRecord.getDeliveryStatus() != null) {
                    outOrderPaymentRecord.setDeliveryStatusName(DeliveryStatusEnum.getValueEnum((Integer)outOrderPaymentRecord.getDeliveryStatus()).getDesc());
                }
                if (outOrderPaymentRecord.getMedicalInsuranceType() != null) {
                    outOrderPaymentRecord.setMedicalInsuranceTypeName(MedicalInsuranceTypeEnum.getEnum((Integer)outOrderPaymentRecord.getMedicalInsuranceType()).getDesc());
                }
                outOrderPaymentRecord.setSettlementMethodName(SettlementMethodEnum.getValueEnum((Integer)outOrderPaymentRecord.getSettlementMethod()).getDesc());
                Integer paymentType = outOrderPaymentRecord.getPaymentType();
                switch (paymentType) {
                    case 1: {
                        outOrderPaymentRecord.setPaymentTypeName("\u5728\u7ebf\u652f\u4ed8");
                        break;
                    }
                    case 2: {
                        outOrderPaymentRecord.setPaymentTypeName("\u7ebf\u4e0b\u652f\u4ed8");
                    }
                }
                Integer operationType = outOrderPaymentRecord.getOperationType();
                switch (operationType) {
                    case 1: {
                        outOrderPaymentRecord.setOperationTypeName("\u652f\u4ed8");
                        break;
                    }
                    case 2: {
                        outOrderPaymentRecord.setOperationTypeName("\u9000\u6b3e");
                    }
                }
            }
            ArrayList<PatientEntity> patientList = new ArrayList<PatientEntity>();
            ArrayList<OutOrderPayment> arrayList = new ArrayList<OutOrderPayment>();
            PatientEntity entity = new PatientEntity();
            if (outOrderPayment.getId() == null && StringUtils.isNotBlank((CharSequence)(payOrderNo = outOrderPayment.getPayOrderNo())) && (outOrderPayments = this.outOrderPaymentMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutOrderPayment::getPayOrderNo, (Object)payOrderNo))).size() > 0) {
                outOrderPayment.setId(((OutOrderPayment)outOrderPayments.get(0)).getId());
            }
            entity.setMsg("PayWechatPaymentCodeImpl.firstPayment-" + outOrderPayment.getId());
            entity.setId(outOrderPayment.getPatientId());
            outOrderPayment.setOrderList(outOrderList);
            outOrderPayment.setPaymentRecordList(outOrderPaymentRecords);
            arrayList.add(outOrderPayment);
            entity.setPaymentList(arrayList);
            patientList.add(entity);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            String msg = JSONObject.toJSONString(patientList);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(patientPaymentTopic, "TAG4", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.success((Object)payVo);
    }

    private ResponseData<PayVo> onlieHlwyyPay(PayDto parameter, PaymentMethodEnum paymentMethodEnum, OutOrderPayment outOrderPayment, List<OutOrder> outOrderList) {
        outOrderPayment.setPaymentType(parameter.getPaymentType());
        outOrderPayment.setActualPayment(outOrderPayment.getTotalAmount());
        outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        outOrderPayment.setPaymentMethod(paymentMethodEnum.getValue());
        outOrderPayment.setPaymentTime(new Date());
        outOrderPayment.setPaymentExpirationTime(null);
        outOrderPayment.setPaymentTransactionNo(outOrderPayment.getPayOrderNo());
        outOrderPayment.setCheckerId(parameter.getOperatorId());
        outOrderPayment.setCheckerName(parameter.getOperatorName());
        int size = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        if (size == 0) {
            throw new RunDisplayException("\u53d8\u66f4\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        ArrayList<OutOrderPaymentRecord> outOrderPaymentRecords = new ArrayList<OutOrderPaymentRecord>();
        String transactionNo = UUIDUtils.getTransactionNo();
        for (OutOrder order : outOrderList) {
            order.setActualPayment(order.getTotalAmount());
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            int num = this.outOrderMapper.updateById((Object)order);
            if (num == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(outOrderPaymentRecord.getTotalAmount());
            outOrderPaymentRecord.setPaymentStatus(outOrderPayment.getPaymentStatus());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            outOrderPaymentRecords.add(outOrderPaymentRecord);
        }
        Integer recordSize = this.outOrderPaymentRecordMapper.batchInsert(outOrderPaymentRecords);
        if (recordSize.intValue() != outOrderList.size()) {
            throw new RunDisplayException("\u8bb0\u5f55\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        PayVo payVo = new PayVo();
        BeanUtils.copyProperties((Object)outOrderPayment, (Object)payVo);
        payVo.setName(outOrderPayment.getPatientName());
        payVo.setTransactionNumber(transactionNo);
        payVo.setOperationType(OperationTypeEnum.PAYMENT.getValue());
        return ResponseData.success((Object)payVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<PayRefundVo> firstPayRefund(PayRefundDto parameter, PaymentMethodEnum paymentMethodEnum, OutOrderPayment outOrderPayment, List<OutOrder> outOrderList) {
        if (!RefundMethodEnum.ORIGINAL_REFUND.getValue().equals(parameter.getRefundMethod())) {
            return ResponseData.error((String)"\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u53ea\u5141\u8bb8\u539f\u8def\u9000\u6b3e\uff01");
        }
        if (SourceEnum.ONLINE.getValue().equals(parameter.getSource())) {
            return this.firstPayRefundOnline(parameter, paymentMethodEnum, outOrderPayment, outOrderList);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status", (Object)PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
        queryWrapper.eq((Object)"tenant_id", (Object)parameter.getTenantId());
        queryWrapper.eq((Object)"biz_sys_seq", (Object)"YHS");
        OutTenantConfiguration outTenantConfiguration = (OutTenantConfiguration)this.outTenantConfigurationMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.isNull(outTenantConfiguration)) {
            return ResponseData.error((String)"\u8bf7\u68c0\u67e5\u652f\u4ed8\u914d\u7f6e");
        }
        String transactionNo = UUIDUtils.getTransactionNo();
        ApplyForARefundDto applyForARefundDto = new ApplyForARefundDto();
        applyForARefundDto.setPayChannel(paymentMethodEnum.getPayChannel());
        applyForARefundDto.setMchCode(outTenantConfiguration.getMerchantSeq());
        applyForARefundDto.setOutTradeNo(transactionNo);
        applyForARefundDto.setDealTradeNo(outOrderPayment.getOtherPaymentParameters());
        applyForARefundDto.setTotalAmount(outOrderPayment.getTotalAmount());
        applyForARefundDto.setRefundAmount(parameter.getRefundableAmount());
        applyForARefundDto.setApplyCode(outTenantConfiguration.getApplyCode());
        applyForARefundDto.setApplyKey(outTenantConfiguration.getApplyKey());
        ResponseData tradeServer = this.orderPayManage.applyForARefund(applyForARefundDto);
        if (!tradeServer.isSuccess()) {
            return ResponseData.error((String)tradeServer.getMsg());
        }
        QueryWrapper queryOrder = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryOrder.eq((Object)"pay_order_no", (Object)outOrderPayment.getPayOrderNo())).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        Integer refundableOrders = this.outOrderMapper.selectCount((Wrapper)queryOrder);
        PaymentStatusEnum paymentStatusEnum = refundableOrders > outOrderList.size() ? PaymentStatusEnum.PAYMENT_PARTIAL_REFUND : PaymentStatusEnum.PAYMENT_REFUNDED;
        outOrderPayment.setRefundAmount(outOrderPayment.getRefundAmount() == null ? new BigDecimal(0) : outOrderPayment.getRefundAmount());
        outOrderPayment.setRefundAmount(outOrderPayment.getRefundAmount().add(parameter.getRefundableAmount()));
        outOrderPayment.setActualPayment(outOrderPayment.getActualPayment().subtract(parameter.getRefundableAmount()));
        outOrderPayment.setPaymentStatus(paymentStatusEnum.getValue());
        outOrderPayment.setRefundTime(new Date());
        outOrderPayment.setRefundCheckerId(parameter.getOperatorId());
        outOrderPayment.setRefundCheckerName(parameter.getOperatorName());
        int size = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        if (size == 0) {
            throw new RunDisplayException("\u53d8\u66f4\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        ArrayList<Object> outOrderPaymentRecords = new ArrayList<Object>();
        for (OutOrder order : outOrderList) {
            List list;
            order.setRefundAmount(parameter.getRefundAmount());
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUND_CONFIRMED.getValue());
            int num = this.outOrderMapper.updateById((Object)order);
            if (num == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            Object outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setDeliveryStatus(order.getDeliveryStatus());
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount().negate());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(parameter.getRefundAmount().negate());
            outOrderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUND_CONFIRMED.getValue());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(-1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT_REFUND.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            if (outOrderPaymentRecord.getId() == null && (list = this.outOrderPaymentRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(OutOrderPaymentRecord::getTransactionNumber, (Object)transactionNo)).eq(OutOrderPaymentRecord::getPaymentStatus, (Object)outOrderPayment.getPaymentStatus())).eq(OutOrderPaymentRecord::getOrderNo, (Object)order.getOrderNo())).eq(OutOrderPaymentRecord::getAmount, (Object)order.getAmount())).eq(OutOrderPaymentRecord::getOperationType, (Object)OperationTypeEnum.PAYMENT.getValue()))).size() > 0) {
                Integer n = ((OutOrderPaymentRecord)list.get(0)).getId();
                outOrderPaymentRecord.setId(n);
            }
            outOrderPaymentRecords.add(outOrderPaymentRecord);
        }
        Integer recordSize = this.outOrderPaymentRecordMapper.batchInsert(outOrderPaymentRecords);
        if (recordSize.intValue() != outOrderList.size()) {
            throw new RunDisplayException("\u8bb0\u5f55\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        PayVo payVo = new PayVo();
        BeanUtils.copyProperties((Object)outOrderPayment, (Object)payVo);
        payVo.setName(outOrderPayment.getPatientName());
        payVo.setTransactionNumber(transactionNo);
        payVo.setOperationType(OperationTypeEnum.PAYMENT.getValue());
        try {
            List outOrderPayments;
            String payOrderNo;
            outOrderPayment.setPaymentStatusStr(PaymentStatusEnum.getValueEnum((Integer)outOrderPayment.getPaymentStatus()).getDesc());
            outOrderPayment.setPaymentMethodName(PaymentMethodEnum.getValueEnum((Integer)outOrderPayment.getPaymentMethod()).getDesc());
            outOrderPayment.setSettlementMethodName(SettlementMethodEnum.getValueEnum((Integer)outOrderPayment.getSettlementMethod()).getDesc());
            String source = outOrderPayment.getSource() != null ? outOrderPayment.getSource() : "";
            switch (source) {
                case "1": {
                    outOrderPayment.setSource("\u7ebf\u4e0a");
                    break;
                }
                case "2": {
                    outOrderPayment.setSource("\u7ebf\u4e0b");
                }
            }
            Integer status = outOrderPayment.getStatus();
            switch (status) {
                case 0: {
                    outOrderPayment.setStatusName("\u5220\u9664");
                    break;
                }
                case 1: {
                    outOrderPayment.setStatusName("\u6b63\u5e38");
                    break;
                }
                case 2: {
                    outOrderPayment.setStatusName("\u5df2\u8fc7\u671f");
                    break;
                }
                case 3: {
                    outOrderPayment.setStatusName("\u5df2\u4f5c\u5e9f");
                }
            }
            for (OutOrder outOrder : outOrderList) {
                String source1;
                switch (source1 = outOrder.getSource() != null ? outOrder.getSource() : "") {
                    case "1": {
                        outOrder.setSource("\u7ebf\u4e0a");
                        break;
                    }
                    case "2": {
                        outOrder.setSource("\u7ebf\u4e0b");
                    }
                }
                Integer status1 = outOrder.getStatus();
                switch (status1) {
                    case 0: {
                        outOrder.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        outOrder.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        outOrder.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        outOrder.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                outOrder.setPaymentStatusStr(PaymentStatusEnum.getValueEnum((Integer)outOrder.getPaymentStatus()).getDesc());
                outOrder.setDeliveryStatusName(DeliveryStatusEnum.getValueEnum((Integer)(outOrder.getDeliveryStatus() != null ? outOrder.getDeliveryStatus() : 0)).getDesc());
            }
            for (OutOrderPaymentRecord outOrderPaymentRecord : outOrderPaymentRecords) {
                Integer status1 = outOrderPaymentRecord.getStatus();
                switch (status1) {
                    case 0: {
                        outOrderPaymentRecord.setStatusName("\u5220\u9664");
                        break;
                    }
                    case 1: {
                        outOrderPaymentRecord.setStatusName("\u6b63\u5e38");
                        break;
                    }
                    case 2: {
                        outOrderPaymentRecord.setStatusName("\u5df2\u8fc7\u671f");
                        break;
                    }
                    case 3: {
                        outOrderPaymentRecord.setStatusName("\u5df2\u4f5c\u5e9f");
                    }
                }
                outOrderPaymentRecord.setPaymentMethodName(PaymentMethodEnum.getValueEnum((Integer)outOrderPaymentRecord.getPaymentMethod()).getDesc());
                outOrderPaymentRecord.setPaymentStatusName(PaymentStatusEnum.getValueEnum((Integer)outOrderPaymentRecord.getPaymentStatus()).getDesc());
                if (outOrderPaymentRecord.getDeliveryStatus() != null) {
                    outOrderPaymentRecord.setDeliveryStatusName(DeliveryStatusEnum.getValueEnum((Integer)outOrderPaymentRecord.getDeliveryStatus()).getDesc());
                }
                if (outOrderPaymentRecord.getMedicalInsuranceType() != null) {
                    outOrderPaymentRecord.setMedicalInsuranceTypeName(MedicalInsuranceTypeEnum.getEnum((Integer)outOrderPaymentRecord.getMedicalInsuranceType()).getDesc());
                }
                outOrderPaymentRecord.setSettlementMethodName(SettlementMethodEnum.getValueEnum((Integer)outOrderPaymentRecord.getSettlementMethod()).getDesc());
                Integer paymentType = outOrderPaymentRecord.getPaymentType();
                switch (paymentType) {
                    case 1: {
                        outOrderPaymentRecord.setPaymentTypeName("\u5728\u7ebf\u652f\u4ed8");
                        break;
                    }
                    case 2: {
                        outOrderPaymentRecord.setPaymentTypeName("\u7ebf\u4e0b\u652f\u4ed8");
                    }
                }
                Integer operationType = outOrderPaymentRecord.getOperationType();
                switch (operationType) {
                    case 1: {
                        outOrderPaymentRecord.setOperationTypeName("\u652f\u4ed8");
                        break;
                    }
                    case 2: {
                        outOrderPaymentRecord.setOperationTypeName("\u9000\u6b3e");
                    }
                }
            }
            ArrayList<PatientEntity> patientList = new ArrayList<PatientEntity>();
            ArrayList<OutOrderPayment> arrayList = new ArrayList<OutOrderPayment>();
            PatientEntity entity = new PatientEntity();
            if (outOrderPayment.getId() == null && StringUtils.isNotBlank((CharSequence)(payOrderNo = outOrderPayment.getPayOrderNo())) && (outOrderPayments = this.outOrderPaymentMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(OutOrderPayment::getPayOrderNo, (Object)payOrderNo))).size() > 0) {
                outOrderPayment.setId(((OutOrderPayment)outOrderPayments.get(0)).getId());
            }
            entity.setMsg("PayWechatPaymentCodeImpl.firstPayRefund-" + outOrderPayment.getId());
            entity.setId(outOrderPayment.getPatientId());
            outOrderPayment.setOrderList(outOrderList);
            outOrderPayment.setPaymentRecordList(outOrderPaymentRecords);
            arrayList.add(outOrderPayment);
            entity.setPaymentList(arrayList);
            patientList.add(entity);
            String uuid = UUIDUtils.getRandom((int)15, (boolean)true);
            String msg = JSONObject.toJSONString(patientList);
            this.rocketMQProducer.asyncSendCallbackTimeoutLevel(patientPaymentTopic, "TAG4", msg, (SendCallback)new /* Unavailable Anonymous Inner Class!! */, 5000L, 1, uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.success((Object)payVo);
    }

    private ResponseData<PayRefundVo> firstPayRefundOnline(PayRefundDto parameter, PaymentMethodEnum paymentMethodEnum, OutOrderPayment outOrderPayment, List<OutOrder> outOrderList) {
        QueryWrapper queryOrder = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryOrder.eq((Object)"pay_order_no", (Object)outOrderPayment.getPayOrderNo())).eq((Object)"status", (Object)OutpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"payment_status", (Object)PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        Integer refundableOrders = this.outOrderMapper.selectCount((Wrapper)queryOrder);
        PaymentStatusEnum paymentStatusEnum = refundableOrders > outOrderList.size() ? PaymentStatusEnum.PAYMENT_PARTIAL_REFUND : PaymentStatusEnum.PAYMENT_REFUNDED;
        outOrderPayment.setRefundAmount(outOrderPayment.getRefundAmount() == null ? new BigDecimal(0) : outOrderPayment.getRefundAmount());
        outOrderPayment.setRefundAmount(outOrderPayment.getRefundAmount().add(parameter.getRefundableAmount()));
        outOrderPayment.setActualPayment(outOrderPayment.getActualPayment().subtract(parameter.getRefundableAmount()));
        outOrderPayment.setPaymentStatus(paymentStatusEnum.getValue());
        outOrderPayment.setRefundTime(new Date());
        outOrderPayment.setRefundTransactionNo(outOrderPayment.getPayOrderNo());
        outOrderPayment.setRefundCheckerId(parameter.getOperatorId());
        outOrderPayment.setRefundCheckerName(parameter.getOperatorName());
        int size = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        if (size == 0) {
            throw new RunDisplayException("\u53d8\u66f4\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        ArrayList<OutOrderPaymentRecord> outOrderPaymentRecords = new ArrayList<OutOrderPaymentRecord>();
        String transactionNo = UUIDUtils.getTransactionNo();
        for (OutOrder order : outOrderList) {
            int num;
            order.setRefundAmount(parameter.getRefundAmount());
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            if (order.getDeliveryStatus().equals(DeliveryStatusEnum.DELIVERY_SHIPPED.getValue())) {
                order.setDeliveryStatus(DeliveryStatusEnum.DELIVERY_REQUIRED.getValue());
            }
            if ((num = this.outOrderMapper.updateById((Object)order)) == 0) {
                throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
            }
            OutOrderPaymentRecord outOrderPaymentRecord = new OutOrderPaymentRecord();
            BeanUtils.copyProperties((Object)outOrderPayment, (Object)outOrderPaymentRecord);
            outOrderPaymentRecord.setPaymentTime(new Date());
            outOrderPaymentRecord.setOrderNo(order.getOrderNo());
            outOrderPaymentRecord.setStatus(PaymentRecordsStatusEnum.STATUS_NORMAL.getValue());
            outOrderPaymentRecord.setAmount(order.getAmount().negate());
            outOrderPaymentRecord.setTotalAmount(order.getAmount());
            outOrderPaymentRecord.setActualPayment(outOrderPaymentRecord.getTotalAmount().negate());
            outOrderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            outOrderPaymentRecord.setQuantity(Integer.valueOf(-1));
            outOrderPaymentRecord.setOperationType(OperationTypeEnum.PAYMENT_REFUND.getValue());
            outOrderPaymentRecord.setTransactionNumber(transactionNo);
            outOrderPaymentRecords.add(outOrderPaymentRecord);
        }
        Integer recordSize = this.outOrderPaymentRecordMapper.batchInsert(outOrderPaymentRecords);
        if (recordSize.intValue() != outOrderList.size()) {
            throw new RunDisplayException("\u8bb0\u5f55\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        PayVo payVo = new PayVo();
        BeanUtils.copyProperties((Object)outOrderPayment, (Object)payVo);
        payVo.setName(outOrderPayment.getPatientName());
        payVo.setTransactionNumber(transactionNo);
        payVo.setOperationType(OperationTypeEnum.PAYMENT.getValue());
        return ResponseData.success((Object)payVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> paymentCallback(PayNotifyReqVO parameter, List<OutOrder> outOrderList, List<OutOrderPaymentRecord> outOrderPaymentRecords, OutOrderPayment outOrderPayment) {
        int num;
        outOrderPayment.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
        outOrderPayment.setPaymentTime(parameter.getPayTime());
        outOrderPayment.setPaymentTransactionNo(parameter.getTradeNo());
        outOrderPayment.setOtherPaymentParameters(parameter.getDealTradeNo());
        int size = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        if (size == 0) {
            throw new RunDisplayException("\u53d8\u66f4\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        for (OutOrder order : outOrderList) {
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_COMPLETED.getValue());
            if (order.getDeliveryStatus().equals(DeliveryStatusEnum.DELIVERY_SHIPPED.getValue())) {
                order.setDeliveryStatus(DeliveryStatusEnum.DELIVERY_REQUIRED.getValue());
            }
            if ((num = this.outOrderMapper.updateById((Object)order)) != 0) continue;
            throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
        }
        for (OutOrderPaymentRecord outOrderPaymentRecord : outOrderPaymentRecords) {
            outOrderPaymentRecord.setPaymentStatus(outOrderPayment.getPaymentStatus());
            outOrderPaymentRecord.setOtherPaymentParameters(parameter.getDealTradeNo());
            num = this.outOrderPaymentRecordMapper.updateById((Object)outOrderPaymentRecord);
            if (num != 0) continue;
            throw new RunDisplayException("\u53d8\u66f4\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        return ResponseData.success((Object)true);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> refundCallback(RefundCallBackReqVo parameter, List<OutOrder> outOrderList, List<OutOrderPaymentRecord> outOrderPaymentRecords, OutOrderPayment outOrderPayment) {
        int num;
        outOrderPayment.setRefundTime(parameter.getRefundTime());
        outOrderPayment.setRefundTransactionNo(parameter.getDealTradeNo());
        int size = this.outOrderPaymentMapper.updateById((Object)outOrderPayment);
        if (size == 0) {
            throw new RunDisplayException("\u53d8\u66f4\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
        }
        for (OutOrder order : outOrderList) {
            order.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            num = this.outOrderMapper.updateById((Object)order);
            if (num != 0) continue;
            throw new RunDisplayException("\u53d8\u66f4\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
        }
        for (OutOrderPaymentRecord outOrderPaymentRecord : outOrderPaymentRecords) {
            outOrderPaymentRecord.setPaymentStatus(PaymentStatusEnum.PAYMENT_REFUNDED.getValue());
            outOrderPaymentRecord.setOtherPaymentParameters(parameter.getDealTradeNo());
            num = this.outOrderPaymentRecordMapper.updateById((Object)outOrderPaymentRecord);
            if (num != 0) continue;
            throw new RunDisplayException("\u53d8\u66f4\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        return ResponseData.success((Object)true);
    }

    public void afterPropertiesSet() throws Exception {
        PayFactory.registeringPaymentService((Integer)PaymentMethodEnum.PAY_WECHAT_PAYMENT_CODE.getValue(), (PayService)this);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

