/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.model.OutFollowUpSettingsEntity;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutFollowUpSettingsService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OutFollowUpSettingsController {
    @Autowired
    private OutFollowUpSettingsService outFollowUpSettingsService;
    @Autowired
    private CommonRequest commonRequest;

    @RequestMapping(value={"/out/follow/up/settings/select"})
    public ResponseData outFollowUpSettingsSelect() throws ParseException {
        OutFollowUpSettingsEntity entity = new OutFollowUpSettingsEntity();
        Integer tenant = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        entity.setTenantId(tenant);
        entity.setCreateId(userId);
        entity.setCreateTime(format.format(new Date()));
        OutFollowUpSettingsEntity list = this.outFollowUpSettingsService.outFollowUpSettingsSelect(entity);
        return ResponseData.success((Object)list);
    }

    @RequestMapping(value={"/out/follow/up/settings/update"})
    public ResponseData outFollowUpSettingsUpdate(@RequestBody @Valid OutFollowUpSettingsEntity entity) throws ParseException {
        Integer deptId = entity.getDeptId();
        if (deptId == null) {
            return ResponseData.error((String)"\u90e8\u95e8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer tenant = this.commonRequest.getTenant();
        Integer userId = this.commonRequest.getUserId();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        entity.setTenantId(tenant);
        entity.setUpdateId(userId);
        entity.setUpdateTime(format.format(new Date()));
        this.outFollowUpSettingsService.outFollowUpSettingsUpdate(entity);
        return ResponseData.success().update();
    }
}

