/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import com.byh.outpatient.api.dto.QueryScheduleRecordDto;
import com.byh.outpatient.api.dto.schdule.ExportRecordDto;
import com.byh.outpatient.api.dto.schdule.ScheduleRecordDto;
import com.byh.outpatient.api.dto.schedule.QueryRecordDto;
import com.byh.outpatient.api.dto.schedule.RegRecordDto;
import com.byh.outpatient.api.model.schedule.ScheduleRecordDetailEntity;
import com.byh.outpatient.api.model.schedule.ScheduleRecordEntity;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.schedule.QueryScheduleRecordVo;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.ScheduleService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Validated
@RequestMapping(value={"/schedule"})
public class ScheduleController {
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/downLoadRecord"})
    @ApiOperation(value="\u5bfc\u51fa\u6307\u5b9a\u65f6\u95f4\u6bb5\u5185\u7684\u533b\u751f\u6392\u73ed")
    public void downLoadRecord(HttpServletResponse response, @RequestBody @Valid ExportRecordDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.scheduleService.downLoadRecord(response, dto);
    }

    @PostMapping(value={"/selectListByHis"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u65f6\u95f4\u5bf9\u5e94\u79d1\u5ba4\u533b\u751f\u7684\u6392\u73ed\u4fe1\u606f\uff08\u4e91HIS\u8c03\u7528\uff09")
    public ResponseData selectListByHis(@RequestBody @Valid RegRecordDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.scheduleService.selectListByHis(dto));
    }

    @PostMapping(value={"/selectListBySelf"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u65f6\u95f4\u5bf9\u5e94\u79d1\u5ba4\u533b\u751f\u7684\u6392\u73ed\u4fe1\u606f\uff08\u81ea\u52a9\u673a\u8c03\u7528\uff09")
    public ResponseData selectListBySelf(@RequestBody @Valid QueryRecordDto dto) {
        dto.setTenantId(dto.getTenantId());
        return ResponseData.success((Object)this.scheduleService.selectListBySelf(dto));
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u6392\u73ed\u4fe1\u606f")
    @UserOptLogger(operation="\u5220\u9664\u6392\u73ed\u4fe1\u606f")
    public ResponseData delete(@RequestBody ScheduleRecordEntity entity) {
        this.scheduleService.delete(entity);
        return ResponseData.success((Object)"\u6392\u73ed\u4fe1\u606f\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/exportRecordTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u6392\u73ed\u6a21\u7248")
    public void exportRecordTemplate(HttpServletResponse response, @RequestBody @Valid ExportRecordDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.scheduleService.exportRecordTemplate(response, dto);
    }

    @PostMapping(value={"/importRecord"})
    @ApiOperation(value="\u5bfc\u5165\u6392\u73ed\u4fe1\u606f")
    public ResponseData importRecord(@RequestPart(value="file") MultipartFile file) throws Exception {
        this.scheduleService.importRecord(file, this.commonRequest.getTenant(), this.commonRequest.getUserId(), this.commonRequest.getUserName());
        return ResponseData.success((Object)"\u5bfc\u5165\u6392\u73ed\u4fe1\u606f\uff01");
    }

    @UserOptLogger(operation="\u63d2\u5165\u6392\u73ed\u4fe1\u606f")
    @PostMapping(value={"/insertRecord"})
    @ApiOperation(value="\u63d2\u5165\u6392\u73ed\u4fe1\u606f", httpMethod="POST", notes="\u63d2\u5165\u6392\u73ed\u4fe1\u606f")
    public ResponseData insertRecord(@RequestBody @Valid List<ScheduleRecordDto> scheduleRecordDtoList) {
        this.scheduleService.insertRecord(scheduleRecordDtoList, this.commonRequest.getTenant(), this.commonRequest.getUserId(), this.commonRequest.getUserName());
        return ResponseData.success((Object)"\u6392\u73ed\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryRecord"})
    @ApiOperation(value="\u67e5\u8be2\u6392\u73ed\u4fe1\u606f", httpMethod="POST", notes="\u67e5\u8be2\u6392\u73ed\u4fe1\u606f")
    public ResponseData<PageResult<QueryScheduleRecordVo>> queryRecord(@RequestBody @Valid QueryScheduleRecordDto queryScheduleRecordDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        queryScheduleRecordDto.setTenantId(this.commonRequest.getTenant());
        return this.scheduleService.queryRecord(queryScheduleRecordDto);
    }

    @PostMapping(value={"/queryRecordByDeptDoctorId"})
    @ApiOperation(value="\u6839\u636e\u79d1\u5ba4\u533b\u751fid\u67e5\u8be2\u6392\u73ed\u4fe1\u606f\u4e00\u5468\u7684\u6392\u73ed\u4fe1\u606f", httpMethod="POST", notes="\u6839\u636e\u79d1\u5ba4\u533b\u751fid\u67e5\u8be2\u6392\u73ed\u4fe1\u606f\u4e00\u5468\u7684\u6392\u73ed\u4fe1\u606f")
    public ResponseData<List<QueryScheduleRecordVo>> queryRecordByDeptDoctorId(@RequestBody @Valid QueryScheduleRecordDto queryScheduleRecordDto, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        queryScheduleRecordDto.setTenantId(this.commonRequest.getTenant());
        return this.scheduleService.queryRecordByDeptDoctorId(queryScheduleRecordDto);
    }

    @GetMapping(value={"/queryRecordDetail"})
    @ApiOperation(value="\u67e5\u8be2\u6392\u73ed\u8be6\u60c5\u4fe1\u606f", httpMethod="GET", notes="\u67e5\u8be2\u6392\u73ed\u8be6\u60c5\u4fe1\u606f")
    public ResponseData<List<ScheduleRecordDetailEntity>> queryRecordDetail(@RequestParam(value="scheduleCode", required=true) String scheduleCode, @RequestParam(value="reservationId", required=false) Integer reservationId) {
        return this.scheduleService.queryRecordDetail(scheduleCode, reservationId);
    }

    @UserOptLogger(operation="\u6392\u73ed\u8be6\u60c5\u72b6\u6001\u4fee\u6539")
    @GetMapping(value={"/updateDetailStatus"})
    @ApiOperation(value="\u6392\u73ed\u8be6\u60c5\u72b6\u6001\u4fee\u6539(1:\u6b63\u5e38/2:\u6682\u505c)", httpMethod="GET", notes="\u6392\u73ed\u8be6\u60c5\u72b6\u6001\u4fee\u6539")
    public ResponseData updateDetailStatus(@RequestParam(value="id", required=true) Integer detailId, @RequestParam(value="status", required=true) String status) {
        return this.scheduleService.updateDetailStatus(detailId, status);
    }

    @UserOptLogger(operation="\u6392\u73ed\u8bb0\u5f55\u72b6\u6001\u4fee\u6539")
    @GetMapping(value={"/updateRecordStatus"})
    @ApiOperation(value="\u6392\u73ed\u8bb0\u5f55\u72b6\u6001\u4fee\u6539(0:\u5220\u9664/1:\u6b63\u5e38/2:\u6682\u505c/3:\u505c\u8bca)", httpMethod="GET", notes="\u6392\u73ed\u8be6\u60c5\u72b6\u6001\u4fee\u6539")
    public ResponseData updateRecordStatus(@RequestParam(value="id", required=true) Integer detailId, @RequestParam(value="status", required=true) String status) {
        return this.scheduleService.updateRecordStatus(detailId, status);
    }
}

