/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller.netHospital;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.netHospital.QueryDTO;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.netHospital.DrugSellStatisticsVo;
import com.byh.outpatient.api.vo.netHospital.DrugStatisticsVo;
import com.byh.outpatient.api.vo.netHospital.KeyValueQueryVo;
import com.byh.outpatient.api.vo.netHospital.KeyValueVo;
import com.byh.outpatient.api.vo.netHospital.PurchaseMedicineVo;
import com.byh.outpatient.web.service.OutPrescriptionService;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/drugStatistics"})
public class DrugStatisticsController {
    private final OutPrescriptionService outPrescriptionService;

    @ApiOperation(value="\u836f\u54c1\u9500\u552e\u7edf\u8ba1")
    @GetMapping(value={"/drugSell"})
    public ResponseData drugSell(String drugsId) {
        DrugStatisticsVo drugStatisticsVo = this.outPrescriptionService.queryDrugSell(drugsId, "0");
        DrugStatisticsVo drugStatisticsVo1 = this.outPrescriptionService.queryDrugSell(drugsId, "1");
        DrugSellStatisticsVo drugSellStatisticsVo = new DrugSellStatisticsVo();
        drugSellStatisticsVo.setDrugTotalNum(drugStatisticsVo.getDrugNum());
        drugSellStatisticsVo.setSellTotalNum(drugStatisticsVo.getSellNum());
        drugSellStatisticsVo.setDrugTodayNum(drugStatisticsVo1.getDrugNum());
        drugSellStatisticsVo.setSellTodayNum(drugStatisticsVo1.getSellNum());
        return ResponseData.success((Object)drugSellStatisticsVo);
    }

    @ApiOperation(value="\u8d2d\u836f\u6570\u91cf/\u4eba\u6570\u7edf\u8ba1")
    @PostMapping(value={"/purchaseMedicine"})
    public ResponseData purchaseMedicine(@RequestBody QueryDTO dto) {
        PurchaseMedicineVo purchaseMedicineVo = new PurchaseMedicineVo();
        ArrayList<KeyValueVo> purchaseMedicineDrugNumList = new ArrayList<KeyValueVo>();
        ArrayList<KeyValueVo> purchaseMedicinePeopleNumList = new ArrayList<KeyValueVo>();
        List list = this.outPrescriptionService.purchaseMedicine(dto);
        if (!list.isEmpty()) {
            for (KeyValueQueryVo keyValueQueryVo : list) {
                KeyValueVo keyValueVo1 = new KeyValueVo();
                KeyValueVo keyValueVo2 = new KeyValueVo();
                keyValueVo1.setKey(keyValueQueryVo.getK());
                keyValueVo1.setValue(keyValueQueryVo.getV1());
                keyValueVo2.setKey(keyValueQueryVo.getK());
                keyValueVo2.setValue(keyValueQueryVo.getV2());
                purchaseMedicineDrugNumList.add(keyValueVo2);
                purchaseMedicinePeopleNumList.add(keyValueVo1);
            }
        }
        purchaseMedicineVo.setPurchaseMedicineDrugNumList(purchaseMedicineDrugNumList);
        purchaseMedicineVo.setPurchaseMedicinePeopleNumList(purchaseMedicinePeopleNumList);
        purchaseMedicineVo.setPurchaseMedicineDrugNum(Integer.valueOf(purchaseMedicineDrugNumList.stream().mapToInt(KeyValueVo::getValue).sum()));
        purchaseMedicineVo.setPurchaseMedicinePeopleNum(Integer.valueOf(purchaseMedicinePeopleNumList.stream().mapToInt(KeyValueVo::getValue).sum()));
        return ResponseData.success((Object)purchaseMedicineVo);
    }

    @PostMapping(value={"/list"})
    public ResponseData selectDrugList(@RequestBody QueryDTO dto) {
        Page page = new Page();
        page.setCurrent(dto.getCurrent() == null ? 1L : (long)dto.getCurrent().intValue());
        page.setSize(dto.getCurrent() == null ? -1L : (long)dto.getSize().intValue());
        IPage iPage = this.outPrescriptionService.pageList(page, dto);
        List records = iPage.getRecords();
        return ResponseData.success((Object)records);
    }

    @GetMapping(value={"/selectPatientList"})
    public ResponseData selectPatientList(String drugsId) {
        List list = this.outPrescriptionService.selectPatientList(drugsId);
        return ResponseData.success((Object)list);
    }

    public DrugStatisticsController(OutPrescriptionService outPrescriptionService) {
        this.outPrescriptionService = outPrescriptionService;
    }
}

