/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.utils;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitMqUtils {
    private static final Logger log = LoggerFactory.getLogger(RabbitMqUtils.class);
    public static final int ONE_THOUSAND = 1000;
    public static final int TIMEOUT_DURATION = 60;
    public static final int PRESCRIPTION_TIME_OUT = 172800;
    public static final int OUTPATIENT_ARCHIVING_TIME_OUT = 86400;
    public static final int PAYMENT_ORDER_TIMEOUT = 65;
    public static final String X_DELAY = "x-delay";

    public static void sendOrdinary(RabbitTemplate rabbitTemplate, String msg) {
        Message message = (Message)MessageBuilder.withBody((byte[])msg.getBytes()).setContentType("application/json").setContentEncoding("utf-8").setMessageId(UUID.randomUUID() + "").build();
        log.info("\u3010\u53d1\u9001\u8005\u3011\u6d88\u606f\u5185\u5bb9\u3010{}\u3011 \u4ea4\u6362\u673a\u3010{}\u3011 \u8def\u7531\u3010{}\u3011 \u6d88\u606fID\u3010{}\u3011", new Object[]{msg, "outpatient.demo.queue", "outpatient.demo.routeKey", message.getMessageProperties().getMessageId()});
        rabbitTemplate.convertAndSend("outpatient.ordinary.exchange", "outpatient.demo.routeKey", (Object)message);
    }

    public static void sendOrderTimeoutAndUnpaid(RabbitTemplate rabbitTemplate, String msg) {
        rabbitTemplate.convertAndSend("outpatient.delayed.exchange", "outpatient.delayed.orderOvertime.key", (Object)msg, message -> {
            message.getMessageProperties().setHeader(X_DELAY, (Object)60000);
            message.getMessageProperties().setContentEncoding("utf-8");
            message.getMessageProperties().setMessageId(UUID.randomUUID() + "");
            log.info("\u3010\u53d1\u9001\u8005\u3011\u6d88\u606f\u5185\u5bb9\u3010{}\u3011 \u4ea4\u6362\u673a\u3010{}\u3011 \u8def\u7531\u3010{}\u3011 \u6d88\u606fID\u3010{}\u3011", new Object[]{msg, "outpatient.delayed.orderOvertime.queue", "outpatient.delayed.orderOvertime.key", message.getMessageProperties().getMessageId()});
            return message;
        });
        log.info("\u53d1\u9001\u8ba2\u5355\u8d85\u65f6\u68c0\u6d4bMQ:{}\u53d1\u9001\u6210\u529f,\u8fc7\u671f\u65f6\u95f4:{}\u79d2\u3002", (Object)msg, (Object)60);
    }

    public static void sendPrescriptionTimeoutAndUnpaid(RabbitTemplate rabbitTemplate, String msg) {
        rabbitTemplate.convertAndSend("outpatient.delayed.exchange", "outpatient.delayed.prescriptionOvertime.key", (Object)msg, message -> {
            message.getMessageProperties().setHeader(X_DELAY, (Object)172800000);
            message.getMessageProperties().setContentEncoding("utf-8");
            message.getMessageProperties().setMessageId(UUID.randomUUID() + "");
            log.info("\u3010\u53d1\u9001\u8005\u3011\u6d88\u606f\u5185\u5bb9\u3010{}\u3011 \u4ea4\u6362\u673a\u3010{}\u3011 \u8def\u7531\u3010{}\u3011 \u6d88\u606fID\u3010{}\u3011", new Object[]{msg, "outpatient.delayed.prescriptionOvertime.queue", "outpatient.delayed.prescriptionOvertime.key", message.getMessageProperties().getMessageId()});
            return message;
        });
        log.info("\u53d1\u9001\u8ba2\u5355\u8d85\u65f6\u68c0\u6d4bMQ:{}\u53d1\u9001\u6210\u529f,\u8fc7\u671f\u65f6\u95f4:{}\u79d2\u3002", (Object)msg, (Object)172800);
    }

    public static void sendOutpatientArchivingTimeout(RabbitTemplate rabbitTemplate, String msg) {
        rabbitTemplate.convertAndSend("outpatient.delayed.exchange", "outpatient.delayed.outpatientArchivingOvertime.key", (Object)msg, message -> {
            message.getMessageProperties().setHeader(X_DELAY, (Object)86400000);
            message.getMessageProperties().setContentEncoding("utf-8");
            message.getMessageProperties().setMessageId(UUID.randomUUID() + "");
            log.info("\u3010\u53d1\u9001\u8005\u3011\u6d88\u606f\u5185\u5bb9\u3010{}\u3011 \u4ea4\u6362\u673a\u3010{}\u3011 \u8def\u7531\u3010{}\u3011 \u6d88\u606fID\u3010{}\u3011", new Object[]{msg, "outpatient.delayed.outpatientArchivingOvertime.queue", "outpatient.delayed.outpatientArchivingOvertime.key", message.getMessageProperties().getMessageId()});
            return message;
        });
        log.info("\u53d1\u9001\u8ba2\u5355\u8d85\u65f6\u68c0\u6d4bMQ:{}\u53d1\u9001\u6210\u529f,\u8fc7\u671f\u65f6\u95f4:{}\u79d2\u3002", (Object)msg, (Object)86400);
    }

    public static void sendPaymentOrderTimeout(RabbitTemplate rabbitTemplate, String msg) {
        rabbitTemplate.convertAndSend("outpatient.delayed.exchange", "outpatient.payment.order.timeout.key", (Object)msg, message -> {
            message.getMessageProperties().setHeader(X_DELAY, (Object)65000);
            message.getMessageProperties().setContentEncoding("utf-8");
            message.getMessageProperties().setMessageId(UUID.randomUUID() + "");
            log.info("\u3010\u53d1\u9001\u8005\u3011\u6d88\u606f\u5185\u5bb9\u3010{}\u3011 \u4ea4\u6362\u673a\u3010{}\u3011 \u8def\u7531\u3010{}\u3011 \u6d88\u606fID\u3010{}\u3011", new Object[]{msg, "outpatient.payment.order.timeout.queue", "outpatient.payment.order.timeout.key", message.getMessageProperties().getMessageId()});
            return message;
        });
        log.info("\u53d1\u9001\u8ba2\u5355\u8d85\u65f6\u672a\u652f\u4ed8\u68c0\u6d4bMQ:{}\u53d1\u9001\u6210\u529f,\u8fc7\u671f\u65f6\u95f4:{}\u6beb\u79d2\u3002", (Object)msg, (Object)60000);
    }

    public static void sendReservationTimeout(RabbitTemplate rabbitTemplate, String msg, Long delaySecond) {
        rabbitTemplate.convertAndSend("outpatient.delayed.exchange", "outpatient.delayed.resverationOvertime.key", (Object)msg, message -> {
            message.getMessageProperties().setHeader(X_DELAY, (Object)delaySecond);
            message.getMessageProperties().setContentEncoding("utf-8");
            message.getMessageProperties().setMessageId(UUID.randomUUID() + "");
            log.info("\u3010\u53d1\u9001\u8005\u3011\u6d88\u606f\u5185\u5bb9\u3010{}\u3011 \u4ea4\u6362\u673a\u3010{}\u3011 \u8def\u7531\u3010{}\u3011 \u6d88\u606fID\u3010{}\u3011", new Object[]{msg, "outpatient.delayed.resverationOvertime.queue", "outpatient.delayed.resverationOvertime.key", message.getMessageProperties().getMessageId()});
            return message;
        });
        log.info("\u53d1\u9001\u9884\u7ea6\u8d85\u65f6\u66f4\u6539\u4e3a\u723d\u7ea6\u68c0\u6d4bMQ:{}\u53d1\u9001\u6210\u529f,\u8fc7\u671f\u65f6\u95f4:{}\u6beb\u79d2\u3002", (Object)msg, (Object)delaySecond);
    }
}

