/*
 * Decompiled with CFR 0.152.
 */
package com.byh.outpatient.web.mvc.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.outpatient.api.dto.medicalRecord.OutpatientInfomationDto;
import com.byh.outpatient.api.dto.medicalRecord.PerformSkinTestDto;
import com.byh.outpatient.api.dto.medicalRecord.QueryHistoricalPrescriptionListDto;
import com.byh.outpatient.api.dto.medicalRecord.QuerySkinTestDto;
import com.byh.outpatient.api.dto.medicalRecord.QueryWesternMedicinePrescriptionDto;
import com.byh.outpatient.api.dto.medicalRecord.WisQueryHistoricalPrescriptionListDto;
import com.byh.outpatient.api.dto.netHospital.NetPrescriptionDto;
import com.byh.outpatient.api.dto.netHospital.PatientInfoDto;
import com.byh.outpatient.api.dto.netHospital.PrescriptionsDTO;
import com.byh.outpatient.api.dto.prescription.CheckDrugOpenLevelDto;
import com.byh.outpatient.api.dto.prescription.CheckObtainDrugDto;
import com.byh.outpatient.api.dto.prescription.OnlinePrescriptionCheckDto;
import com.byh.outpatient.api.dto.prescription.OutPrescriptionDto;
import com.byh.outpatient.api.dto.prescription.SavePrescriptionDrugsDto;
import com.byh.outpatient.api.dto.prescription.SavePrescriptionDto;
import com.byh.outpatient.api.dto.prescription.VoidPrescriptionDto;
import com.byh.outpatient.api.model.hl.HlRimpEntity;
import com.byh.outpatient.api.model.medicalRecord.OutMedicalRecordDiagnosis;
import com.byh.outpatient.api.model.prescription.OutPrescription;
import com.byh.outpatient.api.model.prescription.OutTisanePrescription;
import com.byh.outpatient.api.model.prescription.OutTisaneUpdatePrescription;
import com.byh.outpatient.api.sysModel.request.SysEasyEntity;
import com.byh.outpatient.api.util.PageResult;
import com.byh.outpatient.api.util.ResponseData;
import com.byh.outpatient.api.vo.prescription.MyPrescriptionVo;
import com.byh.outpatient.api.vo.prescription.PatientDrugByOutpatientVo;
import com.byh.outpatient.api.vo.prescription.PrescriptionHistoryVo;
import com.byh.outpatient.api.vo.prescription.PrescriptionInfoVo;
import com.byh.outpatient.api.vo.prescription.QueryPrescriptionPrintingDataVo;
import com.byh.outpatient.api.vo.prescription.QueryPrescriptionsListVo;
import com.byh.outpatient.api.vo.prescription.QueryPrescriptionsVo;
import com.byh.outpatient.api.vo.prescription.QuerySkinTestListVo;
import com.byh.outpatient.api.vo.prescription.QueryWesternMedicinePrescriptionsVo;
import com.byh.outpatient.api.vo.prescription.WesternMedicinePrescriptionVo;
import com.byh.outpatient.api.vo.prescription.WesternMedicinePrescriptionsVo;
import com.byh.outpatient.api.vo.prescription.WisPrescriptionHistoryVo;
import com.byh.outpatient.api.vo.thirdUseDrugVerify.RationDrugUseVo;
import com.byh.outpatient.data.repository.HlRimpMapper;
import com.byh.outpatient.data.repository.OutMedicalRecordDiagnosisMapper;
import com.byh.outpatient.web.aspect.IpUtils;
import com.byh.outpatient.web.aspect.UserOptLogger;
import com.byh.outpatient.web.mvc.utils.CommonRequest;
import com.byh.outpatient.web.service.OutPrescriptionService;
import com.byh.outpatient.web.service.OutSkinRecordsMapperService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outPrescription"})
public class OutPrescriptionController {
    private static final Logger log = LoggerFactory.getLogger(OutPrescriptionController.class);
    @Resource
    private OutPrescriptionService outPrescriptionService;
    @Resource
    private OutSkinRecordsMapperService outSkinRecordsMapperService;
    @Autowired
    private CommonRequest commonRequest;
    @Resource
    private OutMedicalRecordDiagnosisMapper outMedicalRecordDiagnosisMapper;
    @Resource
    private HlRimpMapper hlRimpMapper;

    @ApiOperation(value="\u6821\u9a8c\u8be5\u533b\u751f\u662f\u5426\u6709\u5f00\u53d6\u8be5\u836f\u54c1\u7684\u6743\u9650")
    @PostMapping(value={"/checkOpenDrugOpenLevel"})
    public ResponseData checkOpenDrugOpenLevel(@RequestBody @Valid CheckDrugOpenLevelDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setDoctorId(this.commonRequest.getUserId());
        return ResponseData.success((Object)this.outPrescriptionService.checkOpenDrugOpenLevel(dto));
    }

    @ApiOperation(value="\u5b9a\u65f6\u4f5c\u5e9f\u5f85\u4ed8\u6b3e\u7684\u5904\u65b9")
    @UserOptLogger(operation="\u5b9a\u65f6\u4f5c\u5e9f\u5f85\u4ed8\u6b3e\u7684\u5904\u65b9")
    @PostMapping(value={"/timingVoidPrescription"})
    public ResponseData timingVoidPrescription(@RequestBody VoidPrescriptionDto dto) {
        dto.setTenantId(dto.getTenantId());
        this.outPrescriptionService.timingVoidPrescription();
        return ResponseData.success((Object)"\u5904\u65b9\u4f5c\u5e9f\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4f5c\u5e9f\u6307\u5b9a\u65f6\u95f4\u5f85\u4ed8\u6b3e\u7684\u5904\u65b9")
    @UserOptLogger(operation="\u5904\u65b9")
    @PostMapping(value={"/voidPrescriptionByDate"})
    public ResponseData voidPrescriptionByDate(@RequestBody VoidPrescriptionDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.outPrescriptionService.voidPrescriptionByDate(dto);
        return ResponseData.success((Object)"\u5904\u65b9\u4f5c\u5e9f\u6210\u529f\uff01");
    }

    @PostMapping(value={"/v1/queryPrescriptions"})
    @Operation(description="\u6839\u636e\u95e8\u8bca\u53f7\uff0c\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    @ApiOperation(value="\u5904\u65b9-\u67e5\u8be2\u5904\u65b9\u5217\u8868", httpMethod="POST", notes="\u5904\u65b9-\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    public ResponseData<QueryWesternMedicinePrescriptionsVo> queryPrescriptions(@RequestBody @Valid OutpatientInfomationDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.queryPrescriptions(parameter);
    }

    @PostMapping(value={"/queryPrescriptionsByPatientId"})
    @Operation(description="\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u5904\u65b9")
    @ApiOperation(value="\u5904\u65b9-\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u5904\u65b9", httpMethod="POST", notes="\u5904\u65b9-\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u5904\u65b9")
    public ResponseData<QueryPrescriptionsVo> queryPrescriptionsByPatientId(@RequestBody @Valid PatientInfoDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.outPrescriptionService.queryPrescriptionsByPatientId(parameter);
    }

    @PostMapping(value={"/v1/savePrescription"})
    @Operation(description="\u4fdd\u5b58\u5904\u65b9")
    @ApiOperation(value="\u5904\u65b9-\u4fdd\u5b58\u5904\u65b9", httpMethod="POST", notes="\u5904\u65b9-\u4fdd\u5b58\u5904\u65b9")
    public ResponseData<RationDrugUseVo> savePrescription(@RequestBody @Valid SavePrescriptionDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        this.drugIndication(parameter);
        String[] warehouses = new String[]{"2024122210263130864", "2025021410061088294", "2025021410061088295"};
        List<String> warList = Arrays.asList(warehouses);
        Integer prescriptionClassifyType = parameter.getPrescriptionClassifyType();
        if (prescriptionClassifyType == 5) {
            String warehouse = parameter.getWarehouse();
            if (!warList.contains(warehouse)) {
                return ResponseData.error((String)"\u836f\u623f\u975e\u5904\u65b9\u6d41\u8f6c\u836f\u623f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u5f00\u5904\u65b9\uff01");
            }
            for (SavePrescriptionDrugsDto drug : parameter.getDrugList()) {
                String drugWarehouse = drug.getPharmacyId();
                if (warList.contains(drugWarehouse)) continue;
                return ResponseData.error((String)"\u836f\u623f\u975e\u5904\u65b9\u6d41\u8f6c\u836f\u623f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u5f00\u5904\u65b9\uff01");
            }
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.savePrescription(parameter);
    }

    private void drugIndication(SavePrescriptionDto parameter) {
        QueryWrapper outDiagnosis = new QueryWrapper();
        outDiagnosis.eq((Object)"tenant_id", (Object)1);
        outDiagnosis.eq((Object)"outpatient_no", (Object)parameter.getOutpatientNo());
        List outMedicalRecordDiagnoses = this.outMedicalRecordDiagnosisMapper.selectList((Wrapper)outDiagnosis);
        List diagCodes = !StrUtil.isEmptyIfStr((Object)outMedicalRecordDiagnoses) ? outMedicalRecordDiagnoses.stream().map(OutMedicalRecordDiagnosis::getIcdCode).filter(StrUtil::isNotEmpty).collect(Collectors.toList()) : null;
        List drugList = parameter.getDrugList();
        if (!StrUtil.isEmptyIfStr((Object)drugList)) {
            drugList.forEach(a -> {
                String medicalInsuranceCode = a.getMedicalInsuranceCode();
                List hlRimpEntities = this.hlRimpMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(HlRimpEntity::getProjectCode, (Object)medicalInsuranceCode));
                if (!hlRimpEntities.isEmpty() && !diagCodes.isEmpty()) {
                    List hlRimpDiagCodes = hlRimpEntities.stream().map(HlRimpEntity::getDiagCode).filter(StrUtil::isNotEmpty).collect(Collectors.toList());
                    for (String diagCode : diagCodes) {
                        if (hlRimpDiagCodes.contains(diagCode)) {
                            log.info("\u76f4\u63a5\u653e\u884c", (Object)diagCode);
                            continue;
                        }
                        throw new RuntimeException("\u8bca\u65ad\u4ee3\u7801 " + diagCode + " \u4e0d\u5b58\u5728\u4e8e \u3010\u9650\u9002\u5e94\u75c7-\u4e8b\u60c5\u3011 \u4e2d\uff0c\u8bf7\u4f60\u6838\u5bf9\u76f8\u5bf9\u5e94\u4fe1\u606f\uff01");
                    }
                }
            });
        }
    }

    @PostMapping(value={"/v1/updateExamineStatus"})
    @Operation(description="\u66f4\u65b0\u5904\u65b9\u63a8\u9001\u72b6\u6001")
    @ApiOperation(value="\u5904\u65b9-\u66f4\u65b0\u5904\u65b9\u63a8\u9001\u72b6\u6001", httpMethod="POST", notes="\u5904\u65b9-\u66f4\u65b0\u5904\u65b9\u63a8\u9001\u72b6\u6001")
    public ResponseData<RationDrugUseVo> updateExamineStatus(@RequestBody @Valid OutPrescription parameter, BindingResult bindingResult) {
        return this.outPrescriptionService.updateExamineStatus(parameter);
    }

    @PostMapping(value={"/v1/checkPrescription"})
    @Operation(description="\u5904\u65b9\u6821\u9a8c")
    @ApiOperation(value="\u5904\u65b9-\u6821\u9a8c\u5904\u65b9", httpMethod="POST", notes="\u5904\u65b9-\u6821\u9a8c\u5904\u65b9")
    public ResponseData<RationDrugUseVo> checkPrescription(@RequestBody @Valid SavePrescriptionDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.checkPrescription(parameter);
    }

    @PostMapping(value={"/v1/queryPrescriptionsByNo"})
    @Operation(description="\u6839\u636e\u5904\u65b9\u53f7\u67e5\u8be2\u5904\u65b9")
    @ApiOperation(value="\u5904\u65b9-\u6839\u636e\u5904\u65b9\u53f7\u67e5\u8be2\u5904\u65b9", httpMethod="POST", notes="\u5904\u65b9-\u6839\u636e\u5904\u65b9\u53f7\u67e5\u8be2\u5904\u65b9")
    public ResponseData<QueryPrescriptionsVo> queryPrescriptionsByNo(@RequestBody @Valid OutPrescriptionDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.queryPrescriptionsByNo(parameter);
    }

    @GetMapping(value={"/v1/queryPrescriptionsByJSKFNo"})
    @ApiOperation(value="\u67e5\u8be2\u5904\u65b9\u8be6\u60c5", httpMethod="GET", notes="\u67e5\u8be2\u5904\u65b9\u8be6\u60c5")
    public ResponseData queryPrescriptionsByJSKFNo(@RequestParam(value="prescriptionNo", required=true) String prescriptionNo) {
        return this.outPrescriptionService.queryPrescriptionsByJSKFNo(prescriptionNo);
    }

    @UserOptLogger(operation="\u5220\u9664\u5904\u65b9")
    @PostMapping(value={"/v1/deletePrescriptionsByNo"})
    @Operation(description="\u6839\u636e\u5904\u65b9\u53f7\u5220\u9664\u5904\u65b9")
    @ApiOperation(value="\u5904\u65b9-\u6839\u636e\u5904\u65b9\u53f7\u5220\u9664\u5904\u65b9", httpMethod="POST", notes="\u5904\u65b9-\u6839\u636e\u5904\u65b9\u53f7\u5220\u9664\u5904\u65b9")
    public ResponseData<String> deletePrescriptionsByNo(@RequestBody @Valid OutPrescriptionDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.deletePrescriptionsByNo(parameter);
    }

    @UserOptLogger(operation="mainId\u5220\u9664\u5904\u65b9")
    @PostMapping(value={"/v1/deletePrescriptionsByMainId"})
    @Operation(description="\u6839\u636emainId\u5220\u9664\u5904\u65b9")
    @ApiOperation(value="\u5904\u65b9-\u6839\u636emainId\u5220\u9664\u5904\u65b9", httpMethod="POST", notes="\u5904\u65b9-\u6839\u636emainId\u5220\u9664\u5904\u65b9")
    public ResponseData<String> deletePrescriptionsByMainId(@RequestBody @Valid OutPrescriptionDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.deletePrescriptionsByMainId(parameter);
    }

    @PostMapping(value={"/v1/queryHistoricalPrescriptionList"})
    @Operation(description="\u67e5\u8be2\u5386\u53f2\u5904\u65b9\u5217\u8868")
    @ApiOperation(value="\u5904\u65b9-\u67e5\u8be2\u5386\u53f2\u5904\u65b9\u5217\u8868", httpMethod="POST", notes="\u5904\u65b9-\u67e5\u8be2\u5386\u53f2\u5904\u65b9\u5217\u8868")
    public ResponseData<PageResult<PrescriptionHistoryVo>> queryHistoricalPrescriptionList(@RequestBody @Valid QueryHistoricalPrescriptionListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.queryHistoricalPrescriptionList(parameter);
    }

    @PostMapping(value={"/v1/queryWesternMedicine"})
    @Operation(description="\u67e5\u8be2\u897f\u836f\u5904\u65b9")
    @ApiOperation(value="\u5904\u65b9-\u67e5\u8be2\u897f\u836f\u5904\u65b9", httpMethod="POST", notes="\u5904\u65b9-\u67e5\u8be2\u897f\u836f\u5904\u65b9")
    public ResponseData<List<WesternMedicinePrescriptionVo>> queryWesternMedicine(@RequestBody @Valid QueryWesternMedicinePrescriptionDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.queryWesternMedicine(parameter);
    }

    @PostMapping(value={"/v1/querySkinTestList"})
    @Operation(description="\u67e5\u8be2\u76ae\u8bd5\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u76ae\u8bd5\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u76ae\u8bd5\u5217\u8868")
    public ResponseData<PageResult<QuerySkinTestListVo>> querySkinTestList(@RequestBody @Valid QuerySkinTestDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outSkinRecordsMapperService.querySkinTestList(parameter);
    }

    @PostMapping(value={"/v1/performSkinTest"})
    @Operation(description="\u6267\u884c\u76ae\u8bd5")
    @ApiOperation(value="\u6267\u884c\u76ae\u8bd5", httpMethod="POST", notes="\u6267\u884c\u76ae\u8bd5")
    public ResponseData<String> performSkinTest(@RequestBody @Valid PerformSkinTestDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outSkinRecordsMapperService.performSkinTest(parameter);
    }

    @PostMapping(value={"/v1/queryPrescriptionPrintingData"})
    @Operation(description="\u6839\u636e\u5904\u65b9\u53f7\u67e5\u8be2\u5904\u65b9\u6253\u5370\u6570\u636e")
    @ApiOperation(value="\u6839\u636e\u5904\u65b9\u53f7\u67e5\u8be2\u5904\u65b9\u6253\u5370\u6570\u636e", httpMethod="POST", notes="\u6839\u636e\u5904\u65b9\u53f7\u67e5\u8be2\u5904\u65b9\u6253\u5370\u6570\u636e")
    public ResponseData<QueryPrescriptionPrintingDataVo> queryPrescriptionPrintingData(@RequestBody @Valid OutPrescriptionDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.queryPrescriptionPrintingData(parameter);
    }

    @PostMapping(value={"/v1/select/byno"})
    @Operation(description="\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u5904\u65b9\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    public ResponseData selectByNo(@RequestBody OutPrescriptionDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        Page page = new Page(1L, -1L);
        IPage list = this.outPrescriptionService.queryPrescriptionSelect(page, parameter);
        if (!CollectionUtils.isEmpty((Collection)list.getRecords())) {
            return ResponseData.success(list.getRecords().get(0));
        }
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/v1/select"})
    @Operation(description="\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u5904\u65b9\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    public ResponseData queryPrescriptionSelect(@RequestBody OutPrescriptionDto parameter) {
        Page page = new Page((long)parameter.getCurrent(), (long)parameter.getSize());
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        IPage list = this.outPrescriptionService.queryPrescriptionSelect(page, parameter);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/v1/queryByDoctor"})
    @Operation(description="\u67e5\u8be2\u533b\u751f\u5f00\u5177\u5904\u65b9\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u5f00\u5177\u5904\u65b9\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u533b\u751f\u5f00\u5177\u5904\u65b9\u5217\u8868")
    public ResponseData<MyPrescriptionVo> queryPrescriptionByDoctor(@RequestBody OutPrescriptionDto parameter) {
        Page page = new Page((long)parameter.getCurrent(), (long)parameter.getSize());
        parameter.setTenantId(this.commonRequest.getTenant());
        if (this.commonRequest.getUserId() != 1) {
            parameter.setOperatorId(this.commonRequest.getUserId());
        }
        IPage list = this.outPrescriptionService.queryPrescriptionByDoctor(page, parameter);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/v1/queryPatientDrugByOutpatient"})
    @Operation(description="\u6839\u636e\u95e8\u8bca\u67e5\u8be2\u60a3\u8005\u836f\u54c1\u5217\u8868")
    @ApiOperation(value="\u6839\u636e\u95e8\u8bca\u67e5\u8be2\u60a3\u8005\u836f\u54c1\u5217\u8868", httpMethod="POST", notes="\u67e5\u8be2\u533b\u751f\u5f00\u5177\u5904\u65b9\u5217\u8868")
    public ResponseData<PatientDrugByOutpatientVo> queryPatientDrugByOutpatient(@RequestBody OutPrescriptionDto parameter) {
        Page page = new Page((long)parameter.getCurrent(), (long)parameter.getSize());
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        IPage list = this.outPrescriptionService.queryPatientDrugByOutpatient(page, parameter);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/v1/tisane/select"})
    @Operation(description="\u67e5\u8be2\u5916\u90e8\u5904\u65b9\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u5916\u90e8\u5904\u65b9\u5217\u8868", httpMethod="GET", notes="\u67e5\u8be2\u5916\u90e8\u5904\u65b9\u5217\u8868")
    public ResponseData<OutPrescription> queryPrescriptionTisaneSelect(Page page, OutPrescriptionDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        IPage list = this.outPrescriptionService.queryPrescriptionTisaneSelect(page, parameter);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/v1/tisane/queryFaceSheetSelect"})
    @Operation(description="\u67e5\u8be2\u6253\u5370\u9762\u5355\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u6253\u5370\u9762\u5355\u5217\u8868", httpMethod="GET", notes="\u67e5\u8be2\u6253\u5370\u9762\u5355\u5217\u8868")
    public ResponseData<OutPrescription> queryFaceSheetSelect(Page page, OutPrescriptionDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        IPage list = this.outPrescriptionService.queryFaceSheetSelect(page, parameter);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/v1/tisane/updatePrintTime"})
    @Operation(description="\u66f4\u65b0\u6253\u5370\u65f6\u95f4")
    @ApiOperation(value="\u66f4\u65b0\u6253\u5370\u65f6\u95f4", httpMethod="POST", notes="\u66f4\u65b0\u6253\u5370\u65f6\u95f4")
    public ResponseData updatePrintTime(HttpServletRequest request, @RequestBody OutPrescriptionDto parameter) {
        String ipAddr = IpUtils.getIpAddr((HttpServletRequest)request);
        parameter.setIp(ipAddr);
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        Integer i = this.outPrescriptionService.updatePrintTime(parameter);
        if (i > 0) {
            return ResponseData.success();
        }
        return ResponseData.error((String)"\u5904\u65b9\u7f16\u53f7\u9519\u8bef");
    }

    @GetMapping(value={"/v1/tisane/select/detail"})
    @Operation(description="\u67e5\u8be2\u5916\u90e8\u5904\u65b9\u5217\u8868\u8be6\u60c5")
    @ApiOperation(value="\u67e5\u8be2\u5916\u90e8\u5904\u65b9\u5217\u8868\u8be6\u60c5", httpMethod="GET", notes="\u67e5\u8be2\u5916\u90e8\u5904\u65b9\u5217\u8868\u8be6\u60c5")
    public ResponseData<OutPrescription> queryPrescriptionTisaneSelectDetail(OutPrescriptionDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        OutTisanePrescription entry = this.outPrescriptionService.queryPrescriptionTisaneSelectDetail(parameter);
        return ResponseData.success((Object)entry);
    }

    @GetMapping(value={"/v1/tisane/select/printDetail"})
    @Operation(description="\u67e5\u8be2\u9762\u5355\u6253\u5370\u8be6\u60c5")
    @ApiOperation(value="\u67e5\u8be2\u9762\u5355\u6253\u5370\u8be6\u60c5", httpMethod="GET", notes="\u67e5\u8be2\u9762\u5355\u6253\u5370\u8be6\u60c5")
    public ResponseData<OutPrescription> queryPrescriptionTisaneSelectPrintDetail(OutPrescriptionDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        OutTisanePrescription entry = this.outPrescriptionService.queryPrescriptionTisaneSelectPrintDetail(parameter);
        return ResponseData.success((Object)entry);
    }

    @PostMapping(value={"/v1/tisane/select/printDetailAll"})
    @Operation(description="\u67e5\u8be2\u9762\u5355\u6253\u5370\u8be6\u60c5")
    @ApiOperation(value="\u67e5\u8be2\u9762\u5355\u6253\u5370\u8be6\u60c5", httpMethod="POST", notes="\u67e5\u8be2\u9762\u5355\u6253\u5370\u8be6\u60c5")
    public ResponseData<OutPrescription> queryPrescriptionTisaneSelectPrintDetailAll(@RequestBody OutPrescriptionDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        List list = this.outPrescriptionService.queryPrescriptionTisaneSelectPrintDetailAll(parameter);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/v1/tisane/review"})
    @Operation(description="\u66f4\u65b0\u5916\u90e8\u5904\u65b9\u5217\u8868")
    @ApiOperation(value="\u66f4\u65b0\u5916\u90e8\u5904\u65b9\u5217\u8868", httpMethod="POST", notes="\u66f4\u65b0\u5916\u90e8\u5904\u65b9\u5217\u8868")
    public ResponseData<OutPrescription> queryPrescriptionTisaneReview(@RequestBody @Valid OutTisaneUpdatePrescription parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        this.outPrescriptionService.queryPrescriptionTisaneReview(parameter);
        return ResponseData.success();
    }

    @RequestMapping(value={"/v1/tisane/push"})
    public ResponseData pushPrescription(@RequestBody SysEasyEntity entity) {
        String result = this.outPrescriptionService.pushPrescription(entity.getId(), this.commonRequest.getTenant());
        return ResponseData.success((Object)result);
    }

    @PostMapping(value={"/v1/wisdomQueryHistoricalPrescriptionList"})
    @Operation(description="\u667a\u6167\u5c31\u533b\u67e5\u8be2\u4ee3\u7f34\u5904\u65b9\u5217\u8868")
    @ApiOperation(value="\u5904\u65b9-\u667a\u6167\u5c31\u533b\u67e5\u8be2\u4ee3\u7f34\u5904\u65b9\u5217\u8868", httpMethod="POST", notes="\u5904\u65b9-\u667a\u6167\u5c31\u533b\u67e5\u8be2\u4ee3\u7f34\u5904\u65b9\u5217\u8868")
    public ResponseData<List<WisPrescriptionHistoryVo>> wisdomQueryHistoricalPrescriptionList(@RequestBody @Valid WisQueryHistoricalPrescriptionListDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.wisdomQueryHistoricalPrescriptionList(parameter);
    }

    @PostMapping(value={"/checkObtainDrug"})
    @ApiOperation(value="\u6839\u636e\u60a3\u8005id\u6821\u9a8c\u5f00\u836f\u8bb0\u5f55", httpMethod="POST", notes="\u6839\u636e\u60a3\u8005id\u6821\u9a8c\u5f00\u836f\u8bb0\u5f55")
    public ResponseData checkObtainDrug(@RequestBody CheckObtainDrugDto param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorId(this.commonRequest.getUserId());
        param.setOperatorName(this.commonRequest.getUserName());
        return this.outPrescriptionService.checkObtainDrug(param);
    }

    @PostMapping(value={"/queryPrescriptionsList"})
    @Operation(description="\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    @ApiOperation(value="\u5904\u65b9-\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u5904\u65b9\u5217\u8868", httpMethod="POST", notes="\u5904\u65b9-\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    public ResponseData<List<QueryPrescriptionsListVo>> queryPrescriptionsList(@RequestBody @Valid PatientInfoDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        List list = this.outPrescriptionService.queryPrescriptionsList(parameter);
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/queryPrescriptionsList2"})
    @Operation(description="\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    @ApiOperation(value="\u5904\u65b9-\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u5904\u65b9\u5217\u8868", httpMethod="POST", notes="\u5904\u65b9-\u6839\u636e\u60a3\u8005id\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    public ResponseData<List<QueryPrescriptionsListVo>> queryPrescriptionsList2(@RequestBody @Valid PatientInfoDto parameter, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return ResponseData.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        List list = this.outPrescriptionService.queryPrescriptionsList2(parameter);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/queryPrescriptionCheckList"})
    @Operation(description="\u67e5\u8be2\u7ebf\u4e0a\u5904\u65b9\u5ba1\u6838\u5217\u8868")
    @ApiOperation(value="\u67e5\u8be2\u7ebf\u4e0a\u5904\u65b9\u5ba1\u6838\u5217\u8868", httpMethod="GET", notes="\u67e5\u8be2\u7ebf\u4e0a\u5904\u65b9\u5ba1\u6838\u5217\u8868")
    public ResponseData<List<WesternMedicinePrescriptionsVo>> queryPrescriptionCheckList() {
        List list = this.outPrescriptionService.queryPrescriptionCheckList();
        return ResponseData.success((Object)list);
    }

    @PostMapping(value={"/onlinePrescriptionCheck"})
    @Operation(description="\u7ebf\u4e0a\u5904\u65b9\u5ba1\u6838")
    @ApiOperation(value="\u7ebf\u4e0a\u5904\u65b9\u5ba1\u6838", httpMethod="POST", notes="\u7ebf\u4e0a\u5904\u65b9\u5ba1\u6838")
    public ResponseData onlinePrescriptionCheck(@RequestBody OnlinePrescriptionCheckDto dto) {
        return this.outPrescriptionService.onlinePrescriptionCheck(dto);
    }

    @GetMapping(value={"/queryPrescriptionsInfo"})
    @Operation(description="\u67e5\u8be2\u5904\u65b9\u8be6\u60c5")
    @ApiOperation(value="\u67e5\u8be2\u5904\u65b9\u8be6\u60c5", httpMethod="POST", notes="\u67e5\u8be2\u60a3\u8005\u5904\u65b9\u8be6\u60c5")
    public ResponseData<PrescriptionInfoVo> queryPrescriptionInfo(String prescriptionNo) {
        return this.outPrescriptionService.queryPrescriptionInfo(prescriptionNo);
    }

    @ApiOperation(value="\u836f\u5e08\u5ba1\u6838\u5b8c\u6210\u66f4\u65b0\u5904\u65b9")
    @PostMapping(value={"/updatePrescription"})
    public ResponseData updatePrescription(@RequestBody NetPrescriptionDto dto) {
        return ResponseData.success((Object)this.outPrescriptionService.updatePrescription(dto));
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u67e5\u8be2\u5904\u65b9\u5217\u8868")
    @PostMapping(value={"/queryPrescriptionsByDoctorId"})
    public ResponseData<List<QueryPrescriptionsListVo>> queryPrescriptionsByDoctorId(@RequestBody PrescriptionsDTO dto) {
        return ResponseData.success((Object)this.outPrescriptionService.queryPrescriptionsByDoctorId(dto));
    }
}

