/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.hisFront;

import com.byh.sdk.entity.base.FrontRequest;
import com.byh.sdk.entity.base.FrontResponse;
import com.byh.sdk.entity.drug.CheckObtainDrugDto;
import com.byh.sdk.entity.drug.OutPrescriptionDto;
import com.byh.sdk.entity.drug.SysEasyEntity;
import com.byh.sdk.entity.prescription.CheckPrescriptionDTO;
import com.byh.sdk.entity.prescription.SavePrescriptionDto;
import com.byh.sdk.entity.ve.OutPrescription;
import com.byh.sdk.service.PrescriptionService;
import com.byh.sdk.util.CommonRequest;
import com.byh.sdk.util.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5904\u65b9\u670d\u52a1\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/prescription"})
public class OutPrescriptionController {
    @Autowired
    private PrescriptionService prescriptionService;
    private final CommonRequest commonRequest;

    @PostMapping(value={"/checkPrescription"})
    @ApiOperation(value="\u6821\u9a8c\u5904\u65b9\u4fe1\u606f")
    public FrontResponse checkPrescription(@RequestBody FrontRequest<CheckPrescriptionDTO> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorId(this.commonRequest.getUserId());
        param.setOperatorName(this.commonRequest.getUserName());
        return this.prescriptionService.checkPrescription(param);
    }

    @PostMapping(value={"/savePrescription"})
    @ApiOperation(value="\u4fdd\u5b58\u5904\u65b9")
    public FrontResponse savePrescription(@RequestBody FrontRequest<SavePrescriptionDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorId(this.commonRequest.getUserId());
        param.setOperatorName(this.commonRequest.getUserName());
        return this.prescriptionService.savePrescription(param);
    }

    @PostMapping(value={"/deletePrescriptionsByNo"})
    @ApiOperation(value="\u6839\u636e\u5904\u65b9\u53f7\u5220\u9664\u5904\u65b9")
    public FrontResponse deletePrescriptionsByNo(@RequestBody FrontRequest<OutPrescriptionDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorId(this.commonRequest.getUserId());
        param.setOperatorName(this.commonRequest.getUserName());
        return this.prescriptionService.deletePrescriptionsByNo(param);
    }

    @PostMapping(value={"/deletePrescriptionsByMainId"})
    @ApiOperation(value="\u5904\u65b9-\u6839\u636emainId\u5220\u9664\u5904\u65b9", httpMethod="POST", notes="\u5904\u65b9-\u6839\u636emainId\u5220\u9664\u5904\u65b9")
    public FrontResponse deletePrescriptionsByMainId(@RequestBody FrontRequest<OutPrescriptionDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorId(this.commonRequest.getUserId());
        param.setOperatorName(this.commonRequest.getUserName());
        return this.prescriptionService.deletePrescriptionsByMainId(param);
    }

    @PostMapping(value={"/checkObtainDrug"})
    @ApiOperation(value="\u6839\u636e\u60a3\u8005id\u6821\u9a8c\u5f00\u836f\u8bb0\u5f55", httpMethod="POST", notes="\u6839\u636e\u60a3\u8005id\u6821\u9a8c\u5f00\u836f\u8bb0\u5f55")
    public FrontResponse checkObtainDrug(@RequestBody FrontRequest<CheckObtainDrugDto> param) {
        param.setTenantId(this.commonRequest.getTenant());
        param.setOperatorId(this.commonRequest.getUserId());
        param.setOperatorName(this.commonRequest.getUserName());
        return this.prescriptionService.checkObtainDrug(param);
    }

    @GetMapping(value={"/select/by/no"})
    public ResponseData selectByNo(@Param(value="outpatientNo") String outpatientNo) {
        List outPrescription = this.prescriptionService.selectByNo(outpatientNo);
        return ResponseData.success((Object)outPrescription);
    }

    @RequestMapping(value={"/upload/hs"})
    public ResponseData uploadHs(@RequestBody SysEasyEntity entity) {
        return this.prescriptionService.uploadHs(entity);
    }

    @PostMapping(value={"/updateExamineStatus"})
    public ResponseData updateExamineStatus(@RequestBody OutPrescription entity) {
        return this.prescriptionService.updateExamineStatus(entity);
    }

    public OutPrescriptionController(CommonRequest commonRequest) {
        this.commonRequest = commonRequest;
    }
}

