/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sdk.controller.netHospital;

import com.byh.sdk.entity.order.HsPreparePayDto;
import com.byh.sdk.feign.sys.HsServiceFeign;
import com.byh.sdk.feign.sys.OutpatientServiceFeign;
import com.byh.sdk.hsModel.request.MoveOrderInfoRequest;
import com.byh.sdk.hsModel.request.MoveRefundOrderRequest;
import com.byh.sdk.hsModel.request.MoveUploadInfoRequest;
import com.byh.sdk.hsModel.request.PatientInfoRequest;
import com.byh.sdk.hsModel.request.RegistrationRequest;
import com.byh.sdk.util.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hs"})
public class HisController {
    private static final Logger log = LoggerFactory.getLogger(HisController.class);
    @Autowired
    private HsServiceFeign hsServiceFeign;
    @Autowired
    private OutpatientServiceFeign outpatientServiceFeign;

    @ApiOperation(value="\u30101101\u3011\u533b\u4fdd\u83b7\u53d6\u60a3\u8005\u53c2\u4fdd\u4fe1\u606f")
    @PostMapping(value={"/patientInfo"})
    public ResponseData PatientInfo(@RequestBody PatientInfoRequest patientInfoRequest) {
        ResponseData responseData = this.hsServiceFeign.hsPatientInfo(patientInfoRequest);
        return ResponseData.success((Object)responseData.getData());
    }

    @ApiOperation(value="\u30102201\u3011\u533b\u4fdd\u95e8\u8bca\u767b\u8bb0")
    @PostMapping(value={"/hsRegistration"})
    public ResponseData hsRegistration(@RequestBody RegistrationRequest registrationRequest) {
        ResponseData responseData = this.hsServiceFeign.hsRegistration(registrationRequest);
        return ResponseData.success((Object)responseData.getData());
    }

    @ApiOperation(value="\u30106201\u3011\u8d39\u7528\u660e\u7ec6\u4e0a\u4f20")
    @PostMapping(value={"/hsUploadFeeInfo"})
    public ResponseData hsUploadFeeInfo(@RequestBody MoveUploadInfoRequest moveUploadInfoRequest) {
        ResponseData responseData = this.hsServiceFeign.moveUpLoadInfo(moveUploadInfoRequest);
        return ResponseData.success((Object)responseData.getData());
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef\u533b\u4fdd\u9884\u652f\u4ed8")
    @PostMapping(value={"/moveHsPreparePayment"})
    public ResponseData moveHsPreparePayment(@RequestBody HsPreparePayDto hsPreparePayDto) {
        ResponseData responseData = this.outpatientServiceFeign.moveHsPreparePayment(hsPreparePayDto, Integer.valueOf(1));
        log.info("\u79fb\u52a8\u7aef\u533b\u4fdd\u9884\u652f\u4ed8\u63a5\u53e3\u8fd4\u56de\uff1a{}", (Object)responseData);
        if (!"200".equals(responseData.getCode())) {
            return ResponseData.error((String)responseData.getMsg());
        }
        return ResponseData.success((Object)responseData);
    }

    @ApiOperation(value="\u30106301\u3011\u533b\u4fdd\u8ba2\u5355\u7ed3\u7b97\u7ed3\u679c\u67e5\u8be2")
    @PostMapping(value={"/queryOrderInfo"})
    public ResponseData queryOrderInfo(@RequestBody MoveOrderInfoRequest moveOrderInfoRequest) {
        ResponseData responseData = this.outpatientServiceFeign.moveOrderInfo(moveOrderInfoRequest, Integer.valueOf(1));
        return ResponseData.success((Object)responseData.getData());
    }

    @ApiOperation(value="\u30106203\u3011\u533b\u4fdd\u9000\u8d39")
    @PostMapping(value={"/refundOrder"})
    public ResponseData refundOrder(@RequestBody MoveRefundOrderRequest moveOrderInfoRequest) {
        ResponseData responseData = this.hsServiceFeign.refundOrder(moveOrderInfoRequest);
        if (!"200".equals(responseData.getCode())) {
            if (StringUtils.isNotEmpty((CharSequence)responseData.getMsg())) {
                return ResponseData.error((String)responseData.getMsg());
            }
            return ResponseData.error((String)"\u30106203\u3011\u533b\u4fdd\u9000\u8d39\u5931\u8d25\uff01");
        }
        return ResponseData.success((Object)responseData.getData());
    }

    @ApiOperation(value="\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"/payNotify"})
    public ResponseData payNotify(@RequestBody MoveOrderInfoRequest moveOrderInfoRequest) {
        ResponseData responseData = this.outpatientServiceFeign.payNotify(moveOrderInfoRequest, Integer.valueOf(1));
        if (!"200".equals(responseData.getCode())) {
            if (StringUtils.isNotEmpty((CharSequence)responseData.getMsg())) {
                return ResponseData.error((String)responseData.getMsg());
            }
            return ResponseData.error((String)"\u652f\u4ed8\u56de\u8c03\u5931\u8d25\uff01");
        }
        return ResponseData.success();
    }

    @ApiOperation(value="\u9000\u6b3e\u56de\u8c03")
    @PostMapping(value={"/refundNotify"})
    public ResponseData refundNotify(@RequestBody MoveOrderInfoRequest moveOrderInfoRequest) {
        ResponseData responseData = this.outpatientServiceFeign.refundNotify(moveOrderInfoRequest, Integer.valueOf(1));
        if (!"200".equals(responseData.getCode())) {
            if (StringUtils.isNotEmpty((CharSequence)responseData.getMsg())) {
                return ResponseData.error((String)responseData.getMsg());
            }
            return ResponseData.error((String)"\u9000\u6b3e\u56de\u8c03\u5931\u8d25\uff01");
        }
        return ResponseData.success();
    }
}

