/*
 * Decompiled with CFR 0.152.
 */
package com.byh.chat.core.service.impl;

import com.byh.chat.api.pojo.BusinessMessageInfoEntity;
import com.byh.chat.api.pojo.RongCloudMessageBean;
import com.byh.chat.core.dao.BusinessMessageInfoEntityMapper;
import com.byh.chat.core.manager.InviteMessage;
import com.byh.chat.core.manager.PrediaMessage;
import com.byh.chat.core.service.IApiRongCloudMessageService;
import com.byh.chat.core.utils.EmojiFilterUtil;
import com.byh.chat.core.utils.RongCloudApi;
import io.rong.messages.BaseMessage;
import io.rong.messages.TxtMessage;
import io.rong.models.message.GroupMessage;
import io.rong.models.message.SystemMessage;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiRongCloudMessageServiceImpl
implements IApiRongCloudMessageService {
    private Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private BusinessMessageInfoEntityMapper businessMessageInfoEntityMapper;

    public Boolean saveRongCloudMessage(RongCloudMessageBean bean) {
        Integer i = this.saveBusinessMessageInfoEntity(this.convertRongCloudMessageBean(bean));
        return i > 0;
    }

    public Integer saveBusinessMessageInfoEntity(BusinessMessageInfoEntity info) {
        if (null == info || StringUtils.isBlank((CharSequence)info.getMsgUuid())) {
            this.log.info((Object)"=====\u878d\u4e91\u6d88\u606f\u4e3a\u7a7a=====");
            return 1;
        }
        Integer i = this.businessMessageInfoEntityMapper.countBusinessMessageInfoEntity(info.getMsgUuid());
        if (i < 1) {
            this.log.info((Object)"=====\u878d\u4e91\u6d88\u606f\u4fdd\u5b58 \u6210\u529f=====");
            return this.businessMessageInfoEntityMapper.insert(info);
        }
        this.log.info((Object)"=====\u878d\u4e91\u6d88\u606f\u4fdd\u5b58 \u6570\u636e\u5df2\u5b58\u5728=====");
        return 1;
    }

    private BusinessMessageInfoEntity convertRongCloudMessageBean(RongCloudMessageBean bean) {
        if (null == bean || null == bean.getContent()) {
            this.log.info((Object)"=====\u5c06\u89e3\u6790\u51fa\u6765\u7684\u878d\u4e91\u6d88\u606f\u8f6c\u6362\u6210\u5b58\u50a8\u683c\u5f0f \u5931\u8d25=====");
            return null;
        }
        BusinessMessageInfoEntity info = new BusinessMessageInfoEntity();
        switch (bean.getObjectName()) {
            case "RC:TxtMsg": {
                try {
                    info.setMsgContent(EmojiFilterUtil.emojiRecovery2((String)bean.getContent()));
                }
                catch (UnsupportedEncodingException e) {
                    this.log.error((Object)e.getStackTrace());
                }
                break;
            }
            case "RC:VcMsg": {
                info.setMsgContent(bean.getContent());
                break;
            }
            case "RC:ImgMsg": {
                info.setMsgContent(bean.getContent());
                break;
            }
            case "RC:FileMsg": {
                info.setMsgContent(bean.getContent());
                break;
            }
            default: {
                this.log.info((Object)"=====\u6ca1\u6709\u627e\u5230\u5df2\u77e5\u6d88\u606f\u7c7b\u578b=====");
                return null;
            }
        }
        this.log.info((Object)"=====1.MsgContent\u8f6c\u6362\u5b8c\u6bd5=====");
        info.setChganeelType(bean.getChannelType());
        this.log.info((Object)"=====2.recvId\u8f6c\u6362\u5b8c\u6bd5=====");
        info.setRecvId(bean.getToUserId());
        this.log.info((Object)"=====3.sendId\u8f6c\u6362\u5b8c\u6bd5=====");
        info.setSendId(bean.getFromUserId());
        this.log.info((Object)"=====4.ChannelType\u8f6c\u6362\u5b8c\u6bd5=====");
        info.setMsgType(bean.getObjectName());
        this.log.info((Object)"=====5.MsgType\u8f6c\u6362\u5b8c\u6bd5=====");
        info.setMsgUuid(bean.getMsgUID());
        this.log.info((Object)"=====6.MsgUID\u8f6c\u6362\u5b8c\u6bd5=====");
        info.setSendTime(bean.getMsgTimestamp());
        this.log.info((Object)"=====7.SendTime\u8f6c\u6362\u5b8c\u6bd5=====");
        info.setSensitiveType(Integer.valueOf(bean.getSensitiveType()));
        this.log.info((Object)"=====8.SensitiveType\u8f6c\u6362\u5b8c\u6bd5=====");
        info.setSource(bean.getSource());
        this.log.info((Object)"=====9.Source\u8f6c\u6362\u5b8c\u6bd5=====");
        info.setGroupUserIds(bean.getGroupUserIds());
        this.log.info((Object)"=====10.GroupUserIds\u8f6c\u6362\u5b8c\u6bd5=====");
        this.log.info((Object)"=====\u5c06\u89e3\u6790\u51fa\u6765\u7684\u878d\u4e91\u6d88\u606f\u8f6c\u6362\u6210\u5b58\u50a8\u683c\u5f0f \u5b8c\u6210=====");
        return info;
    }

    public String sendSystemMessage(String fromUserId, String[] toUserIds, String content, String extra) {
        TxtMessage txtMessage = new TxtMessage(content, extra);
        SystemMessage systemMessage = new SystemMessage().setSenderId(fromUserId).setTargetId(toUserIds).setObjectName(txtMessage.getType()).setContent((BaseMessage)txtMessage).setPushContent(content).setPushData("{'pushData':" + content + "}").setIsPersisted(Integer.valueOf(0)).setIsCounted(Integer.valueOf(0)).setContentAvailable(Integer.valueOf(0));
        return RongCloudApi.sendSystem((SystemMessage)systemMessage);
    }

    public String sendGroupMessage(String fromUserId, String[] toUserIds, String objectName, String content, String extra) {
        if (TextUtils.isEmpty((CharSequence)objectName)) {
            return null;
        }
        PrediaMessage baseMessage = null;
        if (objectName.equals("app:predia_message")) {
            baseMessage = new PrediaMessage(content, extra);
        } else if (objectName.equals("app:invite_invalidate")) {
            baseMessage = new InviteMessage(content, extra);
        }
        GroupMessage groupMessage = new GroupMessage().setSenderId(fromUserId).setTargetId(toUserIds).setObjectName(objectName).setContent((BaseMessage)baseMessage).setPushContent(content).setPushData("{'inviteContent':" + content + "}").setIsPersisted(Integer.valueOf(0)).setIsCounted(Integer.valueOf(0)).setIsIncludeSender(Integer.valueOf(1)).setContentAvailable(Integer.valueOf(0));
        return RongCloudApi.sendGroup((GroupMessage)groupMessage);
    }
}

