/*
 * Decompiled with CFR 0.152.
 */
package com.byh.chat.core.api;

import com.alibaba.fastjson.JSONObject;
import com.byh.chat.api.pojo.RongCloudGroupInfoEntity;
import com.byh.chat.api.vo.GroupMemberVo;
import com.byh.chat.api.vo.GroupResVo;
import com.byh.chat.api.vo.RongCloudGroupReqVo;
import com.byh.chat.api.vo.RongCloudOrderGroupVo;
import com.byh.chat.api.vo.RongCloudUserIdVo;
import com.byh.chat.core.service.IApiRongCloudGroupInfoService;
import com.byh.chat.core.service.IApiRongCloudGroupService;
import com.byh.chat.core.service.IApiRongCloudMessageService;
import com.byh.chat.core.utils.StringUtil;
import com.byh.chat.core.utils.UUIDUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/group_operation"})
@Api(tags={"\u7fa4\u7ec4\u64cd\u4f5c\u5de5\u5177\u7c7b"})
public class RongCloudGroupInfoController {
    private static final Logger log = LoggerFactory.getLogger(RongCloudGroupInfoController.class);
    @Autowired
    private IApiRongCloudGroupInfoService RongCloudGroupInfoService;
    @Autowired
    private IApiRongCloudGroupService iApiRongCloudGroupService;
    @Autowired
    private IApiRongCloudMessageService iApiRongCloudMessageService;

    @ApiOperation(value="\u521b\u5efa\u7fa4\u7ec4")
    @PostMapping(value={"/create"})
    public BaseResponse createRongCloudGroup(@RequestBody RongCloudGroupReqVo rongCloudGroupReqVo) {
        log.info("\u521b\u5efa\u7fa4\u7ec4\u5165\u53c2\uff1a\u540d\u79f0\uff1a" + rongCloudGroupReqVo.getName() + "/list:" + rongCloudGroupReqVo.getRongCloudUserIdVoList().toString() + "");
        if (null != rongCloudGroupReqVo.getName() && rongCloudGroupReqVo.getName().length() > 16) {
            return BaseResponse.error((String)"\u7fa4\u7ec4\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc716\u4f4d\uff01");
        }
        String teamUuid = UUIDUtil.getUUID();
        String rongCloudGroup = this.iApiRongCloudGroupService.createRongCloudGroup(teamUuid, rongCloudGroupReqVo.getName(), rongCloudGroupReqVo.getRongCloudUserIdVoList());
        if ("200".equals(rongCloudGroup)) {
            log.info("==========\u878d\u4e91\u521b\u5efa\u6210\u529f===========");
            Boolean insert = this.RongCloudGroupInfoService.saveRongCloudGroupInfo(rongCloudGroupReqVo.getLoginUserId(), rongCloudGroupReqVo.getLoginUserType(), rongCloudGroupReqVo.getGroupType(), rongCloudGroupReqVo.getOrderType(), rongCloudGroupReqVo.getName(), rongCloudGroupReqVo.getRongCloudUserIdVoList(), teamUuid);
            if (insert.booleanValue()) {
                return BaseResponse.success((Object)teamUuid);
            }
            return BaseResponse.error((String)"\u5931\u8d25");
        }
        log.info("==========\u878d\u4e91\u521b\u5efa\u5931\u8d25===========");
        return BaseResponse.error((String)"\u878d\u4e91\u7fa4\u7ec4\u521b\u5efa\u5931\u8d25\uff01");
    }

    @ApiOperation(value="\u52a0\u5165\u7fa4\u7ec4")
    @PostMapping(value={"/join"})
    public BaseResponse joinRongCloudGroup(@RequestBody RongCloudGroupReqVo rongCloudGroupReqVo) {
        log.info("\u52a0\u5165\u7fa4\u7ec4\u5165\u53c2\uff1a\u6210\u5458--\u300b" + rongCloudGroupReqVo.getRongCloudUserIdVoList().toString() + "\u5176\u4ed6--\u300b" + rongCloudGroupReqVo.toString());
        String rongCloudGroup = this.iApiRongCloudGroupService.joinRongCloudGroup(rongCloudGroupReqVo.getGroupId(), rongCloudGroupReqVo.getName(), rongCloudGroupReqVo.getRongCloudUserIdVoList());
        if ("200".equals(rongCloudGroup)) {
            log.info("==========\u878d\u4e91\u7fa4\u7ec4\u52a0\u5165\u6210\u529f===========");
            Boolean insert = this.RongCloudGroupInfoService.joinRongCloudGroupInfo(rongCloudGroupReqVo.getGroupType(), rongCloudGroupReqVo.getRongCloudUserIdVoList(), rongCloudGroupReqVo.getGroupId());
            if (insert.booleanValue()) {
                return BaseResponse.success();
            }
            return BaseResponse.error((String)"\u5931\u8d25");
        }
        log.info("==========\u878d\u4e91\u52a0\u5165\u5931\u8d25===========");
        return BaseResponse.error((String)"\u878d\u4e91\u7fa4\u7ec4\u52a0\u5165\u5931\u8d25\uff01");
    }

    @ApiOperation(value="\u9000\u51fa\u7fa4\u7ec4")
    @PostMapping(value={"/quit"})
    public BaseResponse quitRongCloudGroup(@RequestBody RongCloudGroupReqVo rongCloudGroupReqVo) {
        if (null == rongCloudGroupReqVo.getRongCloudUserIdVoList()) {
            return BaseResponse.error((String)"\u9000\u51fa\u4eba\u5458\u4e3a\u7a7a\uff01");
        }
        for (RongCloudUserIdVo rongCloudUserIdVo : rongCloudGroupReqVo.getRongCloudUserIdVoList()) {
            String rongCloudGroup = this.iApiRongCloudGroupService.quitRongCloudGroup(rongCloudGroupReqVo.getGroupId(), rongCloudUserIdVo.getRongCloudId());
            if ("200".equals(rongCloudGroup)) continue;
            log.info("==========\u878d\u4e91\u9000\u51fa\u5931\u8d25" + rongCloudGroup + "===========");
            return BaseResponse.error((String)"\u878d\u4e91\u7fa4\u7ec4\u9000\u51fa\u5931\u8d25\uff01");
        }
        log.info("==========\u878d\u4e91\u7fa4\u7ec4\u9000\u51fa\u6210\u529f===========");
        Boolean delete = this.RongCloudGroupInfoService.quitRongCloudGroupInfo(rongCloudGroupReqVo.getGroupId(), rongCloudGroupReqVo.getRongCloudUserIdVoList());
        if (delete.booleanValue()) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u5931\u8d25");
    }

    @ApiOperation(value="\u89e3\u6563\u7fa4\u7ec4")
    @PostMapping(value={"/dismiss"})
    public BaseResponse dismissRongCloudGroup(@RequestBody RongCloudGroupReqVo rongCloudGroupReqVo) {
        String rongCloudGroup = this.iApiRongCloudGroupService.dismissRongCloudGroup(rongCloudGroupReqVo.getGroupId(), ((RongCloudUserIdVo)rongCloudGroupReqVo.getRongCloudUserIdVoList().get(0)).getRongCloudId());
        if ("200".equals(rongCloudGroup)) {
            log.info("==========\u878d\u4e91\u7fa4\u7ec4\u89e3\u6563\u6210\u529f===========");
            Boolean delete = this.RongCloudGroupInfoService.dismissRongCloudGroupInfo(rongCloudGroupReqVo.getGroupId());
            if (delete.booleanValue()) {
                return BaseResponse.success();
            }
            return BaseResponse.error((String)"\u5931\u8d25");
        }
        log.info("==========\u878d\u4e91\u89e3\u6563\u5931\u8d25===========");
        return BaseResponse.error((String)"\u878d\u4e91\u7fa4\u7ec4\u89e3\u6563\u5931\u8d25\uff01");
    }

    @ApiOperation(value="\u4fee\u6539\u7fa4\u7ec4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="\u7fa4\u7ec4id", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="name", value="\u7fa4\u7ec4\u540d\u79f0", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="logo", value="\u7fa4\u7ec4\u5934\u50cf", required=false, dataType="String", paramType="query")})
    @PostMapping(value={"/update"})
    public BaseResponse updateGroup(@RequestParam(value="groupId", required=true) String groupId, @RequestParam(value="name", required=false) String name, @RequestParam(value="logo", required=false) String logo) {
        String code;
        log.info("\u4fee\u6539\u7fa4\u7ec4\u5165\u53c2\uff1a" + groupId + "---" + name + "---" + logo);
        if (StringUtil.isNotEmpty((String)name) && name.length() > 16) {
            return BaseResponse.error((String)"\u7fa4\u7ec4\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc716\u4f4d\uff01");
        }
        if (StringUtil.isNotEmpty((String)groupId) && StringUtil.isNotEmpty((String)name) && !"200".equals(code = this.iApiRongCloudGroupService.updateRongCloudGroup(groupId, name))) {
            return BaseResponse.error((String)"\u878d\u4e91\u4fee\u6539\u7fa4\u7ec4\u540d\u79f0\u5931\u8d25");
        }
        log.info("\u878d\u4e91\u4fee\u6539\u540d\u79f0\u6210\u529f\uff01");
        RongCloudGroupInfoEntity rongCloudGroupInfoEntity = new RongCloudGroupInfoEntity();
        rongCloudGroupInfoEntity.setGroupUuid(groupId);
        rongCloudGroupInfoEntity.setGroupName(name);
        rongCloudGroupInfoEntity.setLogoUrl(logo);
        int i = this.RongCloudGroupInfoService.updateByGroupId(rongCloudGroupInfoEntity);
        if (i != 0) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u5931\u8d25");
    }

    @ApiOperation(value="\u83b7\u53d6\u6210\u5458\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupId", value="\u7fa4\u7ec4id", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="doctorId", value="\u4eba\u5458id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="searchName", value="\u641c\u7d22\u4eba\u5458\u540d\u79f0", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="page", value="page", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="size", value="size", required=true, dataType="int", paramType="query")})
    @GetMapping(value={"/getGroupMembers"})
    public BaseResponse<Map<String, Object>> getGroupMember(@RequestParam(value="groupId", required=true) String groupId, @RequestParam(value="doctorId", required=true) Long doctorId, @RequestParam(value="searchName", required=false) String searchName, @RequestParam(value="page", required=true, defaultValue="1") int page, @RequestParam(value="size", required=true, defaultValue="10") int size) {
        return BaseResponse.success((Object)this.RongCloudGroupInfoService.getGroupMember(groupId, doctorId, searchName, page, size));
    }

    @ApiOperation(value="\u83b7\u53d6\u6210\u5458\u5217\u8868")
    @GetMapping(value={"/{groupId}"})
    public BaseResponse<List<GroupMemberVo>> getGroupMember(@PathVariable(value="groupId") String groupId) {
        return BaseResponse.success((Object)this.RongCloudGroupInfoService.getGroupMember(groupId));
    }

    @ApiOperation(value="\u67e5\u8be2\u7fa4\u7ec4\u4fe1\u606f")
    @GetMapping(value={"group/{groupId}"})
    public BaseResponse<RongCloudGroupInfoEntity> getRongCloudGroupInfo(@PathVariable(value="groupId") String groupId) {
        return BaseResponse.success((Object)this.RongCloudGroupInfoService.getRongCloudGroupInfo(groupId));
    }

    @ApiOperation(value="\u67e5\u8be2\u7fa4\u7ec4\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="loginUserId", value="\u767b\u9646\u8005id", required=true, dataType="Long", paramType="query")})
    @PostMapping(value={"/getgrouplist"})
    public BaseResponse<List<GroupResVo>> getGroupList(@RequestParam(value="loginUserId", required=true) Long loginUserId) {
        List RongCloudGroupInfo = this.RongCloudGroupInfoService.getGroupList(loginUserId);
        return BaseResponse.success((Object)RongCloudGroupInfo);
    }

    @ApiOperation(value="\u521b\u5efa\u8ba2\u5355\u7fa4\u7ec4")
    @PostMapping(value={"/createordergroup"})
    public BaseResponse createOrderGroup(@RequestBody RongCloudOrderGroupVo rongCloudOrderGroupVo) {
        String teamUuid;
        String rongCloudGroup;
        log.info("=======\u521b\u5efa\u8ba2\u5355\u7fa4\u7ec4\u5165\u53c2\uff1a" + rongCloudOrderGroupVo.toString() + "======");
        if (null != rongCloudOrderGroupVo.getName() && rongCloudOrderGroupVo.getName().length() > 16) {
            String name = rongCloudOrderGroupVo.getName().substring(0, 16) + "...";
            rongCloudOrderGroupVo.setName(name);
        }
        if ("200".equals(rongCloudGroup = this.iApiRongCloudGroupService.createRongCloudGroup(teamUuid = UUIDUtil.getUUID(), rongCloudOrderGroupVo.getName(), rongCloudOrderGroupVo.getRongCloudUserIdVoList()))) {
            log.info("==========\u878d\u4e91\u521b\u5efa\u6210\u529f===========");
            Boolean insert = this.RongCloudGroupInfoService.saveRongCloudGroupInfo(rongCloudOrderGroupVo.getLoginUserId(), rongCloudOrderGroupVo.getLoginUserType(), Integer.valueOf(1), Integer.valueOf(5), rongCloudOrderGroupVo.getName(), rongCloudOrderGroupVo.getRongCloudUserIdVoList(), teamUuid);
            if (insert.booleanValue()) {
                log.info("==========\u53d1\u9001\u7fa4\u7ec4\u6d88\u606fstart===========");
                if (StringUtil.isEmpty((String)rongCloudOrderGroupVo.getOrderUuid())) {
                    return BaseResponse.error((String)("========\u53d1\u9001\u7fa4\u7ec4\u6d88\u606f\u5931\u8d25:" + teamUuid + "orderUuid\u4e3a\u7a7a\uff01======="));
                }
                if (StringUtil.isEmpty((String)rongCloudOrderGroupVo.getDiagMessage())) {
                    return BaseResponse.error((String)("========\u53d1\u9001\u7fa4\u7ec4\u6d88\u606f\u5931\u8d25:" + teamUuid + "\u8bca\u65ad\u63cf\u8ff0\u4fe1\u606f\u4e3a\u7a7a\uff01======="));
                }
                if (StringUtil.isEmpty((String)rongCloudOrderGroupVo.getInviteMessage())) {
                    return BaseResponse.error((String)("========\u53d1\u9001\u7fa4\u7ec4\u6d88\u606f\u5931\u8d25:" + teamUuid + "\u4e13\u5bb6\u7533\u8bf7\u4fe1\u606f\u4e3a\u7a7a\uff01======="));
                }
                log.info("==========\u53d1\u9001\u7fa4\u7ec4\u6d88\u606f\uff1a\u6570\u636e\u6821\u9a8c\u6210\u529f===========");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", "");
                map.put("chatType", 4);
                map.put("orderUuid", rongCloudOrderGroupVo.getOrderUuid());
                if (null == rongCloudOrderGroupVo.getOrderType()) {
                    map.put("orderType", 3);
                } else {
                    map.put("orderType", rongCloudOrderGroupVo.getOrderType());
                }
                String[] arr = new String[]{teamUuid};
                log.info("==========\u53d1\u9001\u6d88\u606f\u5165\u53c2\uff1a" + rongCloudOrderGroupVo.getRongLoginUserId() + "/" + arr.toString() + "/" + rongCloudOrderGroupVo.getDiagMessage() + "/" + JSONObject.toJSON(map).toString() + "===========");
                String diagResult = this.iApiRongCloudMessageService.sendGroupMessage(rongCloudOrderGroupVo.getRongLoginUserId(), arr, "app:predia_message", rongCloudOrderGroupVo.getDiagMessage(), JSONObject.toJSON(map).toString());
                if (!"200".equals(diagResult)) {
                    log.info("==========\u53d1\u9001\u7fa4\u7ec4\u6d88\u606f\uff1a\u53d1\u9001\u8bca\u65ad\u63cf\u8ff0\u6d88\u606f\u5931\u8d25===========");
                    return BaseResponse.error((String)("========" + teamUuid + ":\u53d1\u9001\u8bca\u65ad\u63cf\u8ff0\u6d88\u606f\u5931\u8d25\uff01======="));
                }
                log.info("==========\u53d1\u9001\u8bca\u65ad\u63cf\u8ff0\u6d88\u606f\u6210\u529f===========");
                String inviteResult = this.iApiRongCloudMessageService.sendGroupMessage(rongCloudOrderGroupVo.getRongLoginUserId(), arr, "app:invite_invalidate", rongCloudOrderGroupVo.getInviteMessage(), JSONObject.toJSON(map).toString());
                if (!"200".equals(inviteResult)) {
                    log.info("==========\u53d1\u9001\u7fa4\u7ec4\u6d88\u606f\uff1a\u53d1\u9001\u4e13\u5bb6\u7533\u8bf7\u6d88\u606f\u5931\u8d25===========");
                    return BaseResponse.error((String)("========" + teamUuid + ":\u53d1\u9001\u4e13\u5bb6\u7533\u8bf7\u6d88\u606f\u5931\u8d25\uff01======="));
                }
                log.info("==========\u53d1\u9001\u4e13\u5bb6\u7533\u8bf7\u6d88\u606f\u6210\u529f===========");
                return BaseResponse.success((Object)teamUuid);
            }
            return BaseResponse.error((String)"\u5931\u8d25");
        }
        log.info("==========\u878d\u4e91\u521b\u5efa\u5931\u8d25===========");
        return BaseResponse.error((String)"\u878d\u4e91\u7fa4\u7ec4\u521b\u5efa\u5931\u8d25\uff01");
    }
}

