/*
 * Decompiled with CFR 0.152.
 */
package com.byh.chat.core.manager;

import com.byh.chat.api.pojo.RongCloudMessageBean;
import com.byh.chat.core.service.IApiRongCloudMessageService;
import com.byh.chat.core.utils.EmojiFilterUtil;
import com.byh.chat.core.utils.StringUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jboss.logging.Logger;
import org.springframework.stereotype.Service;

@Service
public class RongCloudManager {
    private Logger log = Logger.getLogger(this.getClass());
    @Resource
    private IApiRongCloudMessageService apiRongCloudMessageService;

    public boolean receiveMessage(HttpServletRequest request) throws IOException {
        RongCloudMessageBean bean = this.getBodyString((ServletRequest)request);
        Boolean flag = this.apiRongCloudMessageService.saveRongCloudMessage(bean);
        return flag;
    }

    private RongCloudMessageBean getBodyString(ServletRequest request) throws IOException {
        this.log.info((Object)"======\u83b7\u53d6\u804a\u5929\u4fe1\u606f\u8fdb\u884c\u5c01\u88c5Start=======");
        RongCloudMessageBean rongCloudMessageBean = new RongCloudMessageBean();
        String channelType = request.getParameter("channelType");
        String fromUserId = request.getParameter("fromUserId");
        String toUserId = request.getParameter("toUserId");
        String msgTimestamp = request.getParameter("msgTimestamp");
        String timestamp = request.getParameter("timestamp");
        String objectName = request.getParameter("objectName");
        String content = request.getParameter("content");
        String msgUID = request.getParameter("msgUID");
        String sensitiveType = request.getParameter("sensitiveType");
        String source = request.getParameter("source");
        String groupUserIds = request.getParameter("groupUserIds");
        if (StringUtil.isNotEmpty((String)channelType)) {
            rongCloudMessageBean.setChannelType(channelType);
        }
        if (StringUtil.isNotEmpty((String)fromUserId)) {
            rongCloudMessageBean.setFromUserId(fromUserId);
        }
        if (StringUtil.isNotEmpty((String)toUserId)) {
            rongCloudMessageBean.setToUserId(toUserId);
        }
        if (StringUtil.isNotEmpty((String)msgTimestamp)) {
            rongCloudMessageBean.setMsgTimestamp(new Date(Long.parseLong(msgTimestamp)));
        }
        if (StringUtil.isNotEmpty((String)timestamp)) {
            rongCloudMessageBean.setTimestamp(new Date(Long.parseLong(timestamp)));
        }
        if (StringUtil.isNotEmpty((String)objectName)) {
            rongCloudMessageBean.setObjectName(URLDecoder.decode(objectName, "UTF-8"));
        }
        if (StringUtil.isNotEmpty((String)content)) {
            rongCloudMessageBean.setContent(EmojiFilterUtil.emojiConvert1((String)URLDecoder.decode(content, "UTF-8")));
        }
        if (StringUtil.isNotEmpty((String)msgUID)) {
            rongCloudMessageBean.setMsgUID(msgUID);
        }
        if (StringUtil.isNotEmpty((String)sensitiveType)) {
            rongCloudMessageBean.setSensitiveType(Integer.parseInt(sensitiveType));
        }
        if (StringUtil.isNotEmpty((String)source)) {
            rongCloudMessageBean.setSource(source);
        }
        if (StringUtil.isNotEmpty((String)groupUserIds)) {
            rongCloudMessageBean.setGroupUserIds(groupUserIds);
        }
        this.log.info((Object)"======\u83b7\u53d6\u804a\u5929\u4fe1\u606f\u8fdb\u884c\u5c01\u88c5end=======");
        return rongCloudMessageBean;
    }
}

