/*
 * Decompiled with CFR 0.152.
 */
package com.byh.chat.core.service.impl;

import com.byh.chat.api.pojo.RongCloudGroupInfoEntity;
import com.byh.chat.api.pojo.RongCloudGroupMemberInfoEntity;
import com.byh.chat.api.vo.GroupMemberVo;
import com.byh.chat.api.vo.GroupResVo;
import com.byh.chat.api.vo.RongCloudUserIdVo;
import com.byh.chat.core.dao.RongCloudGroupInfoEntityMapper;
import com.byh.chat.core.dao.RongCloudGroupMemberInfoEntityMapper;
import com.byh.chat.core.enums.RongCloudGroupRoleTypeEnum;
import com.byh.chat.core.feign.DoctorFeignClient;
import com.byh.chat.core.service.IApiRongCloudGroupInfoService;
import com.byh.chat.core.utils.DateTimeUtil;
import com.byh.chat.core.utils.ImageUtil;
import com.byh.chat.core.utils.StringUtil;
import com.byh.chat.core.utils.oss.OssManageUtil;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ApiRongCloudGroupInfoServiceImpl
implements IApiRongCloudGroupInfoService {
    private static final Logger log = LoggerFactory.getLogger(ApiRongCloudGroupInfoServiceImpl.class);
    @Autowired
    private RongCloudGroupInfoEntityMapper RongCloudGroupInfoEntityMapper;
    @Autowired
    private RongCloudGroupMemberInfoEntityMapper rongCloudGroupMemberInfoEntityMapper;
    @Autowired
    private DoctorFeignClient doctorApi;

    @Transactional
    public Boolean saveRongCloudGroupInfo(String loginUserId, Integer loginUserType, Integer groupType, Integer orderType, String name, List<RongCloudUserIdVo> rongCloudUserIdVoList, String teamUuid) {
        int updateLogo;
        int groupInsert;
        log.info("======\u7fa4\u7ec4\u8868\u4fe1\u606f\u63d2\u5165start=======");
        RongCloudGroupInfoEntity rongCloudGroup = new RongCloudGroupInfoEntity();
        rongCloudGroup.setGroupUuid(teamUuid);
        rongCloudGroup.setGroupType(groupType);
        rongCloudGroup.setGroupName(name);
        rongCloudGroup.setCreatorId(Integer.valueOf(loginUserId));
        rongCloudGroup.setCreatorType(loginUserType);
        rongCloudGroup.setStatus(Integer.valueOf(1));
        if (null != orderType && groupType == 1) {
            rongCloudGroup.setOrderType(orderType);
        }
        if ((groupInsert = this.RongCloudGroupInfoEntityMapper.insertSelective(rongCloudGroup)) < 1) {
            log.info("======\u7fa4\u7ec4\u8868\u4fe1\u606f\u63d2\u5165\u5931\u8d25=======");
            return false;
        }
        log.info("======\u7fa4\u7ec4\u8868\u4fe1\u606f\u63d2\u5165end=======");
        ArrayList<String> urls = new ArrayList<String>();
        for (RongCloudUserIdVo rongCloudUserIdVo : rongCloudUserIdVoList) {
            urls.add(rongCloudUserIdVo.getHeadImageUrl());
            RongCloudGroupMemberInfoEntity rongCloudGroupMemberInfoEntity = new RongCloudGroupMemberInfoEntity();
            rongCloudGroupMemberInfoEntity.setUserType(rongCloudUserIdVo.getUserType());
            rongCloudGroupMemberInfoEntity.setGroupUuid(teamUuid);
            rongCloudGroupMemberInfoEntity.setGroupType(groupType);
            rongCloudGroupMemberInfoEntity.setUserId(Integer.valueOf(rongCloudUserIdVo.getUserId()));
            rongCloudGroupMemberInfoEntity.setHeadImageUrl(rongCloudUserIdVo.getHeadImageUrl());
            rongCloudGroupMemberInfoEntity.setRongCloudId(rongCloudUserIdVo.getRongCloudId());
            rongCloudGroupMemberInfoEntity.setUserName(rongCloudUserIdVo.getUserName());
            if (loginUserId.equals(rongCloudUserIdVo.getUserId())) {
                rongCloudGroupMemberInfoEntity.setRole(RongCloudGroupRoleTypeEnum.ADMIN.getValue());
            } else {
                rongCloudGroupMemberInfoEntity.setRole(RongCloudGroupRoleTypeEnum.MEMBER.getValue());
            }
            rongCloudGroupMemberInfoEntity.setStatus(Integer.valueOf(1));
            int memberInsert = this.rongCloudGroupMemberInfoEntityMapper.insertSelective(rongCloudGroupMemberInfoEntity);
            if (memberInsert >= 1) continue;
            log.info("======\u7fa4\u7ec4\u6210\u5458\u8868\u4fe1\u606f\u63d2\u5165\u5931\u8d25=======");
            return false;
        }
        log.info("======\u56fe\u7247\u5408\u6210=======");
        String logurl = "http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/25/1548382195565_a8f889794b454136ac0de6341fc1f52d.png";
        try {
            if (null != urls && urls.size() > 0) {
                String picDir;
                MockMultipartFile multipartFile;
                ByteArrayOutputStream byteArrayOutputStream = ImageUtil.getCombinationOfHead(urls);
                String rootDir = DateTimeUtil.getYear((Date)new Date()) + "/" + DateTimeUtil.getMonth((Date)new Date()) + 1 + "/" + DateTimeUtil.getDayOfMonth((Date)new Date());
                Map map = OssManageUtil.uploadFile((String)rootDir, (MultipartFile)(multipartFile = new MockMultipartFile("temp.jpg", "temp.jpg", "", (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()))));
                if (null != map && map.size() > 0 && StringUtil.isNotEmpty((String)(picDir = map.get("urlpath").toString()))) {
                    logurl = picDir;
                }
            }
        }
        catch (Exception e) {
            log.info("======\u56fe\u7247\u5408\u6210\u5931\u8d25=======");
            e.printStackTrace();
        }
        log.info("======\u66f4\u65b0logo\u5230\u7fa4\u7ec4\u8868\u4e2d=======");
        if (StringUtil.isNotEmpty((String)logurl) && (updateLogo = this.RongCloudGroupInfoEntityMapper.updateByUuid(teamUuid, logurl)) < 1) {
            return false;
        }
        return true;
    }

    @Transactional
    public Boolean joinRongCloudGroupInfo(Integer groupType, List<RongCloudUserIdVo> rongCloudUserIdVoList, String teamUuid) {
        for (RongCloudUserIdVo rongCloudUserIdVo : rongCloudUserIdVoList) {
            RongCloudGroupMemberInfoEntity rongCloudGroupMemberInfoEntity = new RongCloudGroupMemberInfoEntity();
            rongCloudGroupMemberInfoEntity.setGroupUuid(teamUuid);
            rongCloudGroupMemberInfoEntity.setGroupType(groupType);
            rongCloudGroupMemberInfoEntity.setUserId(Integer.valueOf(rongCloudUserIdVo.getUserId()));
            rongCloudGroupMemberInfoEntity.setUserType(rongCloudUserIdVo.getUserType());
            rongCloudGroupMemberInfoEntity.setHeadImageUrl(rongCloudUserIdVo.getHeadImageUrl());
            rongCloudGroupMemberInfoEntity.setRongCloudId(rongCloudUserIdVo.getRongCloudId());
            rongCloudGroupMemberInfoEntity.setUserName(rongCloudUserIdVo.getUserName());
            rongCloudGroupMemberInfoEntity.setRole(RongCloudGroupRoleTypeEnum.MEMBER.getValue());
            rongCloudGroupMemberInfoEntity.setStatus(Integer.valueOf(1));
            int memberInsert = this.rongCloudGroupMemberInfoEntityMapper.insertSelective(rongCloudGroupMemberInfoEntity);
            if (memberInsert >= 1) continue;
            log.info("======\u7fa4\u7ec4\u6210\u5458\u8868\u4fe1\u606f\u63d2\u5165\u5931\u8d25=======");
            return false;
        }
        return true;
    }

    public Boolean quitRongCloudGroupInfo(String groupId, List<RongCloudUserIdVo> rongCloudUserIdVoList) {
        for (RongCloudUserIdVo rongCloudUserIdVo : rongCloudUserIdVoList) {
            RongCloudGroupMemberInfoEntity rongCloudGroupMemberInfoEntity = new RongCloudGroupMemberInfoEntity();
            rongCloudGroupMemberInfoEntity.setGroupUuid(groupId);
            rongCloudGroupMemberInfoEntity.setUserId(Integer.valueOf(rongCloudUserIdVo.getUserId()));
            rongCloudGroupMemberInfoEntity.setStatus(Integer.valueOf(-1));
            int i = this.rongCloudGroupMemberInfoEntityMapper.updateByUserIdAndGroupId(rongCloudGroupMemberInfoEntity);
            if (i >= 1) continue;
            log.info("======\u7fa4\u7ec4\u6210\u5458\u8868\u4fe1\u606f\u5220\u9664\u5931\u8d25=======");
            return false;
        }
        return true;
    }

    public Boolean dismissRongCloudGroupInfo(String groupId) {
        RongCloudGroupMemberInfoEntity rongCloudGroupMemberInfoEntity = new RongCloudGroupMemberInfoEntity();
        rongCloudGroupMemberInfoEntity.setGroupUuid(groupId);
        rongCloudGroupMemberInfoEntity.setStatus(Integer.valueOf(-1));
        int i = this.rongCloudGroupMemberInfoEntityMapper.updateByUserIdAndGroupId(rongCloudGroupMemberInfoEntity);
        if (i < 1) {
            log.info("======\u7fa4\u7ec4\u6210\u5458\u8868\u4fe1\u606f\u5220\u9664\u5931\u8d25=======");
            return false;
        }
        RongCloudGroupInfoEntity rongCloudGroupInfoEntity = new RongCloudGroupInfoEntity();
        rongCloudGroupInfoEntity.setGroupUuid(groupId);
        rongCloudGroupInfoEntity.setStatus(Integer.valueOf(-1));
        int p = this.RongCloudGroupInfoEntityMapper.updateByGroupId(rongCloudGroupInfoEntity);
        if (p < 1) {
            log.info("======\u7fa4\u7ec4\u4e3b\u8868\u4fe1\u606f\u5220\u9664\u5931\u8d25=======");
            return false;
        }
        return true;
    }

    public Map<String, Object> getGroupMember(String groupId, Long doctorId, String searchName, int page, int size) {
        log.info("=======\u83b7\u53d6\u6210\u5458\u5217\u8868=======");
        HashMap<String, Object> map = new HashMap<String, Object>();
        PageHelper.startPage((int)page, (int)size);
        Page groupMemberVos = this.rongCloudGroupMemberInfoEntityMapper.selectByGroupId(groupId, searchName, 1);
        for (GroupMemberVo groupMemberVo : groupMemberVos) {
            if (!StringUtil.isNotEmpty((String)groupMemberVo.getDoctorId())) continue;
            BaseDTO dto = new BaseDTO();
            dto.setId(Integer.valueOf(groupMemberVo.getDoctorId()));
            BaseResponse doctorUserInfoVOBaseResponse = null;
            doctorUserInfoVOBaseResponse = this.doctorApi.queryDoctorUserInfo(dto);
            log.info("================\u4e91\u4e0a\u8fd4\u56deuc_docotor_info\u4fe1\u606f\uff1a" + doctorUserInfoVOBaseResponse + "===================");
        }
        map.put("total", groupMemberVos.getTotal());
        map.put("pageData", groupMemberVos.getResult());
        RongCloudGroupMemberInfoEntity rongCloudGroupMemberInfoEntity = this.rongCloudGroupMemberInfoEntityMapper.selectByUserId(doctorId, groupId, 1);
        if (null != rongCloudGroupMemberInfoEntity && rongCloudGroupMemberInfoEntity.getRole() == 1) {
            map.put("role", 1);
        } else if (null != rongCloudGroupMemberInfoEntity && rongCloudGroupMemberInfoEntity.getRole() == 2) {
            map.put("role", 2);
        } else {
            map.put("role", null);
        }
        return map;
    }

    public List<GroupMemberVo> getGroupMember(String groupId) {
        return this.rongCloudGroupMemberInfoEntityMapper.selectByGroupId(groupId, "", 1);
    }

    public RongCloudGroupInfoEntity getRongCloudGroupInfo(String groupId) {
        return this.RongCloudGroupInfoEntityMapper.selectByGroupId(groupId);
    }

    public int updateByGroupId(RongCloudGroupInfoEntity RongCloudGroupInfo) {
        int i = this.RongCloudGroupInfoEntityMapper.updateByGroupId(RongCloudGroupInfo);
        return i;
    }

    public int updateRongCloudGroupInfo(RongCloudGroupInfoEntity RongCloudGroupInfo) {
        int i = this.RongCloudGroupInfoEntityMapper.updateByPrimaryKeySelective(RongCloudGroupInfo);
        return i;
    }

    public int deleteRongCloudGroupInfo(Long id) {
        RongCloudGroupInfoEntity RongCloudGroupInfo = new RongCloudGroupInfoEntity();
        RongCloudGroupInfo.setId(id);
        RongCloudGroupInfo.setStatus(Integer.valueOf(-1));
        int i = this.RongCloudGroupInfoEntityMapper.updateByPrimaryKeySelective(RongCloudGroupInfo);
        return i;
    }

    public List<GroupResVo> getGroupList(Long loginUserId) {
        Integer status = 1;
        return this.RongCloudGroupInfoEntityMapper.getGroupList(status.intValue(), loginUserId);
    }
}

