/*
 * Decompiled with CFR 0.152.
 */
package com.byh.chat.core.utils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CookieUtils {
    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookie.getName().equalsIgnoreCase(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        String value = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return value;
    }

    public static Cookie generateCookie(String key, String value) {
        Cookie cookie = new Cookie(key, value);
        int expireTime = 1471228928;
        cookie.setMaxAge(expireTime);
        cookie.setPath("/");
        return cookie;
    }
}

