/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.api.util;

import com.byh.sys.api.util.UserCenterTokenParseUtil;
import com.byh.sys.api.vo.user.TokenBody;
import com.byh.sys.api.vo.user.TokenJson;
import com.ebaiyihui.framework.utils.JwtUtil;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class Tokenutil {
    private static String SPACE_MARK = "***";
    private static String DEFAULT_SECRYKEY = "cloud-ehospital";

    public static TokenBody parse(String token, String secryKey) throws Exception {
        int i = token.indexOf(SPACE_MARK);
        token = token.substring(0, i);
        return UserCenterTokenParseUtil.parse(token, secryKey);
    }

    public static String gen(TokenJson tokenJson, String secryKey) {
        Objects.requireNonNull(tokenJson, "\u751f\u6210token\u53c2\u6570tokenJson\u4e0d\u80fd\u4e3anull");
        String id = tokenJson.getOrganId() + "_" + tokenJson.getId() + "_" + tokenJson.getTenantId();
        long timeTolive = 30L;
        String genJwt = JwtUtil.genJwt((String)id, (Object)tokenJson, (long)timeTolive, (TimeUnit)TimeUnit.DAYS, (String)secryKey);
        return genJwt + SPACE_MARK + tokenJson.getOrganId();
    }

    public static boolean validateToken(String accesstoken, String secryKey) {
        try {
            TokenBody tokenBody = Tokenutil.parse(accesstoken, secryKey);
            return tokenBody.expire();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String genTokenKey(String userId, String appCode, String deviceType) {
        return userId + "_" + appCode + "_" + deviceType;
    }

    public static String gen(TokenJson tokenJson) {
        return Tokenutil.gen(tokenJson, DEFAULT_SECRYKEY);
    }

    public static String getTokenAppCode(String token) {
        return token.substring(token.indexOf(SPACE_MARK) + 3);
    }
}

