/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.api.excel;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.merge.AbstractMergeStrategy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class CustomMergeStrategy
extends AbstractMergeStrategy {
    private Set<Integer> mergeCellIndex = new HashSet<Integer>();
    private Integer maxRow = 0;
    private Map<Integer, MergeRange> lastRow = new HashMap<Integer, MergeRange>();

    private CustomMergeStrategy() {
    }

    public CustomMergeStrategy(Integer maxRow, int ... mergeCellIndex) {
        Arrays.stream(mergeCellIndex).forEach(item -> this.mergeCellIndex.add(item));
        this.maxRow = maxRow;
    }

    protected void merge(Sheet sheet, Cell cell, Head head, Integer relativeRowIndex) {
        int currentCellIndex = cell.getColumnIndex();
        if (this.mergeCellIndex.contains(currentCellIndex)) {
            String currentCellValue = cell.getStringCellValue();
            int currentRowIndex = cell.getRowIndex();
            if (!this.lastRow.containsKey(currentCellIndex)) {
                this.lastRow.put(currentCellIndex, new MergeRange(currentCellValue, currentRowIndex, currentRowIndex, currentCellIndex, currentCellIndex));
                return;
            }
            MergeRange mergeRange = this.lastRow.get(currentCellIndex);
            if (mergeRange.lastValue == null || !mergeRange.lastValue.equals(currentCellValue)) {
                if (mergeRange.startRow != mergeRange.endRow || mergeRange.startCell != mergeRange.endCell) {
                    sheet.addMergedRegionUnsafe(new CellRangeAddress(mergeRange.startRow, mergeRange.endRow, mergeRange.startCell, mergeRange.endCell));
                }
                this.lastRow.put(currentCellIndex, new MergeRange(currentCellValue, currentRowIndex, currentRowIndex, currentCellIndex, currentCellIndex));
            }
            ++mergeRange.endRow;
            if (relativeRowIndex.equals(this.maxRow - 1)) {
                MergeRange lastMergeRange = this.lastRow.get(currentCellIndex);
                if (lastMergeRange.startRow != lastMergeRange.endRow || lastMergeRange.startCell != lastMergeRange.endCell) {
                    sheet.addMergedRegionUnsafe(new CellRangeAddress(lastMergeRange.startRow, lastMergeRange.endRow, lastMergeRange.startCell, lastMergeRange.endCell));
                }
            }
        }
    }

    class MergeRange {
        public int startRow;
        public int endRow;
        public int startCell;
        public int endCell;
        public String lastValue;

        public MergeRange(String lastValue, int startRow, int endRow, int startCell, int endCell) {
            this.startRow = startRow;
            this.endRow = endRow;
            this.startCell = startCell;
            this.endCell = endCell;
            this.lastValue = lastValue;
        }
    }
}

