/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.api.util;

import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;

public class IpUtils {
    static final String UNKNOWN = "unknown";
    static final String LOCAL_HOST = "127.0.0.1";
    static final String X_REAL_IP = "X-Real-IP";
    static final String PROXY_CLIENT_IP = "Proxy-Client-IP";
    static final String WL_PROXY_CLIENT_IP = "WL-Proxy-Client-IP";

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && !"".equals(ip) && !UNKNOWN.equalsIgnoreCase(ip)) {
            if (ip.indexOf(",") > 0) {
                ip = ip.substring(0, ip.indexOf(","));
            }
            if (LOCAL_HOST.equals(ip)) {
                InetAddress inet = null;
                try {
                    inet = InetAddress.getLocalHost();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ip = inet.getHostAddress();
            }
        }
        if (request.getHeader(X_REAL_IP) != null && !"".equals(request.getHeader(X_REAL_IP)) && !UNKNOWN.equalsIgnoreCase(request.getHeader(X_REAL_IP))) {
            ip = request.getHeader(X_REAL_IP);
        }
        if (request.getHeader(PROXY_CLIENT_IP) != null && !"".equals(request.getHeader(PROXY_CLIENT_IP)) && UNKNOWN.equalsIgnoreCase(request.getHeader(PROXY_CLIENT_IP))) {
            ip = request.getHeader(PROXY_CLIENT_IP);
        }
        if (request.getHeader(WL_PROXY_CLIENT_IP) != null && !"".equals(request.getHeader(WL_PROXY_CLIENT_IP)) && !UNKNOWN.equalsIgnoreCase(request.getHeader(WL_PROXY_CLIENT_IP))) {
            ip = request.getHeader(WL_PROXY_CLIENT_IP);
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

