/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.api.enums;

import com.byh.sys.api.enums.ErrorEnum;
import com.byh.sys.api.exception.BusinessException;
import com.fasterxml.jackson.annotation.JsonValue;

public class UserEnums {

    public static enum PatientOperatorEnum {
        USER((short)0, ""),
        MANAGER((short)1, ""),
        ACCOUNT_CANCEL((short)2, "");

        private Short userType;
        private String userTypeDesc;

        private PatientOperatorEnum(Short userType, String userTypeDesc) {
            this.userType = userType;
            this.userTypeDesc = userTypeDesc;
        }

        public Short getUserType() {
            return this.userType;
        }

        public String getUserTypeDesc() {
            return this.userTypeDesc;
        }
    }

    public static enum QueryResultEnum {
        SUCCESS((short)1, "\u67e5\u8be2\u5230\u5408\u6cd5\u7ed3\u679c"),
        FAIL((short)0, "\u672a\u67e5\u8be2\u5230\u6216\u67e5\u8be2\u7ed3\u679c\u4e0d\u5408\u6cd5");

        private Short result;
        private String resultDesc;

        private QueryResultEnum(Short result, String resultDesc) {
            this.result = result;
            this.resultDesc = resultDesc;
        }

        public Short getResult() {
            return this.result;
        }

        public String getResultDesc() {
            return this.resultDesc;
        }
    }

    public static enum PatientInfoStatusEnum {
        BINDING((short)0, "\u7ed1\u5b9a\uff0c\u53ef\u7528"),
        UNBINGDING((short)1, "\u89e3\u7ed1\uff0c\u4e0d\u53ef\u7528");

        private Short binding;
        private String bindingDesc;

        private PatientInfoStatusEnum(Short binding, String bindingDesc) {
            this.binding = binding;
            this.bindingDesc = bindingDesc;
        }

        @JsonValue
        public Short getBinding() {
            return this.binding;
        }

        public String getBindingDesc() {
            return this.bindingDesc;
        }
    }

    public static enum UserRelationEnum {
        MYSELF((short)0, "\u672c\u4eba"),
        OTHER((short)1, "\u5176\u4ed6\u4eb2\u5c5e"),
        COUPLE((short)2, "\u592b\u59bb"),
        CHILD((short)3, "\u5b50\u5973"),
        BROTHERSANDSISTERS((short)4, "\u5144\u5f1f\u59d0\u59b9"),
        FRIEND((short)5, "\u670b\u53cb"),
        PARENTS((short)6, "\u7236\u6bcd");

        private Short userRelation;
        private String userRelationDesc;

        private UserRelationEnum(Short userRelation, String userRelationDesc) {
            this.userRelation = userRelation;
            this.userRelationDesc = userRelationDesc;
        }

        public static UserRelationEnum getEnumByCode(short code) {
            for (UserRelationEnum userRelationEnum : UserRelationEnum.values()) {
                if (userRelationEnum.getUserRelation() != code) continue;
                return userRelationEnum;
            }
            return null;
        }

        public Short getUserRelation() {
            return this.userRelation;
        }

        public String getUserRelationDesc() {
            return this.userRelationDesc;
        }
    }

    public static enum RealnameStatusEnum {
        UNREALNAME((short)0, "\u672a\u5b9e\u540d"),
        WAITCONFIRM((short)1, "\u5f85\u5ba1\u6838"),
        REALNAMED((short)2, "\u5df2\u5b9e\u540d"),
        IMPERFECT((short)3, "\u5ba1\u6838\u5931\u8d25");

        private Short realnameStatus;
        private String realnameStatusDesc;

        public Short getRealnameStatus() {
            return this.realnameStatus;
        }

        private RealnameStatusEnum(Short realnameStatus, String realnameStatusDesc) {
            this.realnameStatus = realnameStatus;
            this.realnameStatusDesc = realnameStatusDesc;
        }

        public String getRealnameStatusDesc() {
            return this.realnameStatusDesc;
        }
    }

    public static enum UserActionEnum {
        LOGIN,
        LOGOUT,
        CANCEL,
        IMPERFECT;

    }

    public static enum UserStatusEnum {
        NORMAL((short)0, "\u6b63\u5e38"),
        PROHIBIT((short)1, "\u7981\u7528"),
        CANCELLATION((short)2, "\u6ce8\u9500"),
        IMPERFECT((short)3, "\u672a\u5b8c\u5584\u8d26\u6237\u8d44\u6599");

        private Short userStatusValue;
        private String userStatusValueDesc;

        private UserStatusEnum(Short userStatusValue, String userStatusValueDesc) {
            this.userStatusValue = userStatusValue;
            this.userStatusValueDesc = userStatusValueDesc;
        }

        public Short getUserStatusValue() {
            return this.userStatusValue;
        }

        public String getUserStatusValueDesc() {
            return this.userStatusValueDesc;
        }

        public static UserStatusEnum getByStatusValue(Short statusValue) {
            UserStatusEnum[] values;
            for (UserStatusEnum userStatusEnum : values = UserStatusEnum.values()) {
                boolean equal = userStatusEnum.userStatusValue.equals(statusValue);
                if (!equal) continue;
                return userStatusEnum;
            }
            throw new BusinessException(ErrorEnum.SYSTEM_ERROR.getMsg());
        }
    }

    public static enum UserTypeEnum {
        PATIENT((short)0, "\u60a3\u8005"),
        DOCTOR((short)1, "\u533b\u751f"),
        ORGAN((short)2, "\u673a\u6784"),
        MANAGER((short)3, "\u7ba1\u7406\u5458"),
        COMMUNITY((short)4, "\u793e\u533a\u7ba1\u7406\u5458");

        private Short userTypeValue;
        private String userTypeDesc;

        private UserTypeEnum(Short userTypeValue, String userTypeDesc) {
            this.userTypeValue = userTypeValue;
            this.userTypeDesc = userTypeDesc;
        }

        public Short getUserTypeValue() {
            return this.userTypeValue;
        }

        public String getUserTypeDesc() {
            return this.userTypeDesc;
        }

        public static UserTypeEnum getByTypeValue(Short typeValue) {
            UserTypeEnum[] values;
            for (UserTypeEnum userTypeEnum : values = UserTypeEnum.values()) {
                boolean equal = userTypeEnum.userTypeValue.equals(typeValue);
                if (!equal) continue;
                return userTypeEnum;
            }
            throw new BusinessException(ErrorEnum.SYSTEM_ERROR);
        }
    }
}

