/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.api.excel;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.merge.AbstractMergeStrategy;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class CustomMergeStrategy
extends AbstractMergeStrategy {
    private Set<Integer> mergeCellIndex = new HashSet<Integer>();
    private Integer maxRow = 0;
    private Map<Integer, MergeRange> lastRow = new HashMap<Integer, MergeRange>();
    private Map<Integer, Integer> rowIndexMap = new HashMap<Integer, Integer>();

    private CustomMergeStrategy() {
    }

    public CustomMergeStrategy(Integer maxRow, int ... mergeCellIndex) {
        Arrays.stream(mergeCellIndex).forEach(item -> this.mergeCellIndex.add(item));
        this.maxRow = maxRow;
    }

    protected void merge(Sheet sheet, Cell cell, Head head, Integer relativeRowIndex) {
        int currentCellIndex = cell.getColumnIndex();
        if (this.mergeCellIndex.contains(currentCellIndex)) {
            int columnIndex = cell.getColumnIndex();
            int rowIndex = cell.getRowIndex();
            Integer prevRowIndex = this.rowIndexMap.get(columnIndex);
            if (prevRowIndex != null) {
                Row prevRow = sheet.getRow(prevRowIndex.intValue());
                Cell prevCell = prevRow.getCell(columnIndex);
                CellType prevType = prevCell.getCellTypeEnum();
                switch (prevType) {
                    case STRING: {
                        String prevStr = prevCell.getStringCellValue();
                        String curStr = cell.getStringCellValue();
                        if (!prevStr.equals(curStr)) break;
                        CellRangeAddress cellRangeAddress = new CellRangeAddress(prevRowIndex.intValue(), rowIndex, columnIndex, columnIndex);
                        sheet.addMergedRegionUnsafe(cellRangeAddress);
                        break;
                    }
                    case NUMERIC: {
                        BigDecimal prevBigDecimal = BigDecimal.valueOf(prevCell.getNumericCellValue());
                        BigDecimal curBigDecimal = BigDecimal.valueOf(cell.getNumericCellValue());
                        if (prevBigDecimal.compareTo(curBigDecimal) != 0) break;
                        CellRangeAddress cellRangeAddress = new CellRangeAddress(prevRowIndex.intValue(), rowIndex, columnIndex, columnIndex);
                        sheet.addMergedRegionUnsafe(cellRangeAddress);
                    }
                }
            }
            this.rowIndexMap.put(columnIndex, rowIndex);
        }
    }

    class MergeRange {
        public int startRow;
        public int endRow;
        public int startCell;
        public int endCell;
        public String lastValue;

        public MergeRange(String lastValue, int startRow, int endRow, int startCell, int endCell) {
            this.startRow = startRow;
            this.endRow = endRow;
            this.startCell = startCell;
            this.endCell = endCell;
            this.lastValue = lastValue;
        }
    }
}

