/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.api.util;

import cn.hutool.core.util.StrUtil;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.byh.sys.api.exception.BusinessException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class OSSClientUtil {
    private static final Log log = LogFactory.getLog(OSSClientUtil.class);
    private static String endpoint = "https://oss-cn-beijing.aliyuncs.com";
    private static String accessKeyId = "LTAI4FwMYWcJsdYRTJEuSbya";
    private static String accessKeySecret = "GTKrBOaSbIEaaPBEJU94ETltZ08YuX";
    private static String bucketName = "cdn2019";
    private static ObjectMapper om = new ObjectMapper();

    private static String uploadImg2Oss(MultipartFile file) throws BusinessException {
        String originalFilename = file.getOriginalFilename();
        String substring = originalFilename.substring(originalFilename.lastIndexOf(46)).toLowerCase();
        SecureRandom random = new SecureRandom();
        String name = (long)random.nextInt(10000) + System.currentTimeMillis() + substring;
        try {
            InputStream inputStream = file.getInputStream();
            OSSClientUtil.uploadFile2OSS(inputStream, name);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return name;
    }

    public static String uploadStamp(MultipartFile file, String path) throws BusinessException {
        if (file.getSize() > 0x100000L) {
            throw new BusinessException("\u4e0a\u4f20\u56fe\u7247\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc71M\uff01");
        }
        String originalFilename = file.getOriginalFilename();
        String substring = originalFilename.substring(originalFilename.lastIndexOf(46)).toLowerCase();
        SecureRandom random = new SecureRandom();
        String name = path + random.nextInt(10000) + System.currentTimeMillis() + substring;
        try {
            InputStream inputStream = file.getInputStream();
            OSSClientUtil.uploadFile2OSS(inputStream, name);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return name;
    }

    public static String getImgUrl(String fileUrl) {
        if (StrUtil.isNotEmpty((CharSequence)fileUrl)) {
            String[] split = fileUrl.split("/");
            return OSSClientUtil.getUrl(split[split.length - 1]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFile2OSS(InputStream instream, String fileName) {
        String ret = "";
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)instream.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType(OSSClientUtil.getcontentType(fileName));
            objectMetadata.setContentDisposition("inline;filename=" + fileName);
            log.info((Object)instream.available());
            PutObjectResult putResult = ossClient.putObject(bucketName, fileName, instream, objectMetadata);
            ret = putResult.getETag();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (instream != null) {
                    instream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            ossClient.shutdown();
        }
        return ret;
    }

    public static String getcontentType(String filenameExtension) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String type = fileNameMap.getContentTypeFor(filenameExtension);
        if (StrUtil.isBlank((CharSequence)type)) {
            return "text/plain";
        }
        return type;
    }

    public static String getUrl(String key) {
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        Date expiration = new Date(System.currentTimeMillis() + 315360000000L);
        URL url = ossClient.generatePresignedUrl(bucketName, key, expiration);
        if (url != null) {
            return url.getProtocol() + "://" + url.getHost() + url.getPath();
        }
        ossClient.shutdown();
        return null;
    }

    public static String getViewUrl(String hostUrl, String ossFileName) {
        String xurl = "https://" + hostUrl + ossFileName;
        return xurl;
    }

    public static String checkImgScale(int widthCheck, int heightCheck, MultipartFile file) {
        try {
            InputStream inputStream = file.getInputStream();
            BufferedImage sourceImg = ImageIO.read(inputStream);
            float width = sourceImg.getWidth();
            float height = sourceImg.getHeight();
            if (width != (float)widthCheck || height != (float)heightCheck) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("code", -1);
                resultMap.put("msg", "failed");
                resultMap.put("data", null);
                return om.writeValueAsString(resultMap);
            }
            return OSSClientUtil.uploadFile(file, "hxdoctor");
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String uploadFile(MultipartFile file, String bucket) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            OSSClientUtil.setBucketName(bucket);
            log.info((Object)("------------upload file-------name:" + file.getOriginalFilename() + " size:" + file.getSize()));
            String fileName = OSSClientUtil.uploadImg2Oss(file);
            String url = OSSClientUtil.getUrl(fileName);
            resultMap.put("code", 0);
            resultMap.put("msg", "sucess");
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("src", url);
            dataMap.put("title", fileName);
            resultMap.put("data", dataMap);
            String content = om.writeValueAsString(resultMap);
            return content;
        }
        catch (Exception e) {
            log.error((Object)"\u4e0a\u4f20\u56fe\u7247\u5931\u8d25", (Throwable)e);
            resultMap.put("code", -1);
            resultMap.put("msg", "imageUploadFailed" + e.getMessage());
            String content = "";
            try {
                content = om.writeValueAsString(resultMap);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            return content;
        }
    }

    public static Map<String, Object> fileUpload(MultipartFile file, String bucket) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            OSSClientUtil.setBucketName(bucket);
            log.info((Object)("------------upload file-------name:" + file.getOriginalFilename() + " size:" + file.getSize()));
            String fileName = OSSClientUtil.uploadImg2Oss(file);
            String url = OSSClientUtil.getUrl(fileName);
            resultMap.put("name", file.getOriginalFilename());
            resultMap.put("fileSize", file.getSize());
            resultMap.put("fileUrl", url);
            resultMap.put("fileName", fileName);
        }
        catch (Exception e) {
            e.getMessage();
            throw new BusinessException("\u5355\u4e2a\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
        }
        return resultMap;
    }

    public static Map<String, Object> fileUploads(MultipartFile[] file, String bucket) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuilder fileNameBuilder = new StringBuilder();
        StringBuilder nameBuilder = new StringBuilder();
        StringBuilder fileSizeBuilder = new StringBuilder();
        StringBuilder fileUrlBuilder = new StringBuilder();
        try {
            for (MultipartFile files : file) {
                OSSClientUtil.setBucketName(bucket);
                log.info((Object)("------------upload file-------name:" + files.getOriginalFilename() + " size:" + files.getSize()));
                String fileName = OSSClientUtil.uploadImg2Oss(files);
                String url = OSSClientUtil.getUrl(fileName);
                nameBuilder.append(files.getOriginalFilename()).append(",");
                fileSizeBuilder.append(files.getSize()).append(",");
                fileUrlBuilder.append(url).append(",");
                fileNameBuilder.append(fileName).append(",");
            }
            resultMap.put("name", nameBuilder);
            resultMap.put("fileSize", fileSizeBuilder);
            resultMap.put("fileUrl", fileUrlBuilder);
            resultMap.put("fileName", fileNameBuilder);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return resultMap;
    }

    public static byte[] downloadLocal(String fileName) {
        OSSClient ossClient = new OSSClient(endpoint, accessKeyId, accessKeySecret);
        try {
            OSSObject ossObject = ossClient.getObject(new GetObjectRequest(bucketName, fileName));
            InputStream is = ossObject.getObjectContent();
            byte[] bs = FileCopyUtils.copyToByteArray((InputStream)is);
            ossClient.shutdown();
            return bs;
        }
        catch (Exception e) {
            log.error((Object)"\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static void setBucketName(String bucketName) {
        OSSClientUtil.bucketName = bucketName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFolder(String objectName) {
        OSSClient client = OSSClientUtil.getNewClient();
        ObjectMetadata objectMeta = new ObjectMetadata();
        byte[] buffer = new byte[]{};
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        objectMeta.setContentLength(0L);
        try {
            client.putObject(bucketName, objectName, (InputStream)in, objectMeta);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error((Object)"ERROR", (Throwable)e);
            }
        }
    }

    public static void deleteFolder(String objectName) {
        OSSClient client = OSSClientUtil.getNewClient();
        boolean isObjectExist = client.doesObjectExist(bucketName, objectName);
        log.info((Object)("rs:" + isObjectExist));
        if (isObjectExist) {
            log.info((Object)"\u5b58\u5728,\u53ef\u4ee5\u5220\u9664");
            client.deleteObject(bucketName, objectName);
        } else {
            log.info((Object)"\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
    }

    public static OSSClient getNewClient() {
        return new OSSClient(endpoint, accessKeyId, accessKeySecret);
    }
}

