/*
 * Decompiled with CFR 0.152.
 */
package com.byh.sys.api.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;

public class VerifyCodeUtil {
    private int width = 100;
    private int height = 40;
    private String[] fontNames = new String[]{"\u5b8b\u4f53", "\u6977\u4f53", "\u96b6\u4e66", "\u5fae\u8f6f\u96c5\u9ed1"};
    private Color bgColor = new Color(255, 255, 255);
    private Random random = new Random();
    private String codes = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private String text;

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    private Color randomColor() {
        int red = this.random.nextInt(150);
        int green = this.random.nextInt(150);
        int blue = this.random.nextInt(150);
        return new Color(red, green, blue);
    }

    private Font randomFont() {
        String name = this.fontNames[this.random.nextInt(this.fontNames.length)];
        int style = this.random.nextInt(4);
        int size = this.random.nextInt(5) + 24;
        return new Font(name, style, size);
    }

    private char randomChar() {
        return this.codes.charAt(this.random.nextInt(this.codes.length()));
    }

    private BufferedImage createImage() {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, this.width, this.height);
        return image;
    }

    private void drawLine(BufferedImage image) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        int num = 5;
        for (int i = 0; i < num; ++i) {
            int x1 = this.random.nextInt(this.width);
            int y1 = this.random.nextInt(this.height);
            int x2 = this.random.nextInt(this.width);
            int y2 = this.random.nextInt(this.height);
            g2.setColor(this.randomColor());
            g2.setStroke(new BasicStroke(1.5f));
            g2.drawLine(x1, y1, x2, y2);
        }
    }

    public BufferedImage getImage() {
        BufferedImage image = this.createImage();
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            String s = this.randomChar() + "";
            sb.append(s);
            g2.setColor(this.randomColor());
            g2.setFont(this.randomFont());
            float x = (float)(i * this.width) * 1.0f / 4.0f;
            g2.drawString(s, x, (float)this.height - 15.0f);
        }
        this.text = sb.toString();
        this.drawLine(image);
        return image;
    }

    public String getText() {
        return this.text;
    }

    public static void output(BufferedImage image, OutputStream out) throws IOException {
        ImageIO.write((RenderedImage)image, "JPEG", out);
    }
}

