/*
 * Decompiled with CFR 0.152.
 */
package com.chdu.ai.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DifyResponseProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DifyResponseProcessor.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final int MAX_SAFE_RESPONSE_SIZE = 4096;

    public static String processDifyResponse(String rawData, int messageIndex) {
        try {
            int dataSize = rawData.getBytes(StandardCharsets.UTF_8).length;
            if (dataSize <= 4096) {
                return rawData;
            }
            logger.warn("Dify\u54cd\u5e94 #{} \u8fc7\u5927({}bytes)\uff0c\u5f00\u59cb\u4f18\u5316\u5904\u7406", (Object)messageIndex, (Object)dataSize);
            try {
                JsonNode jsonNode = objectMapper.readTree(rawData);
                return DifyResponseProcessor.optimizeJsonResponse((JsonNode)jsonNode, (int)messageIndex);
            }
            catch (Exception e) {
                return DifyResponseProcessor.optimizeTextResponse((String)rawData, (int)messageIndex);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406Dify\u54cd\u5e94 #{} \u65f6\u53d1\u751f\u9519\u8bef", (Object)messageIndex, (Object)e);
            return DifyResponseProcessor.createErrorResponse((String)"\u54cd\u5e94\u5904\u7406\u5931\u8d25");
        }
    }

    private static String optimizeJsonResponse(JsonNode jsonNode, int messageIndex) {
        try {
            HashMap<String, Object> optimized = new HashMap<String, Object>();
            if (jsonNode.has("event")) {
                optimized.put("event", jsonNode.get("event").asText());
            }
            if (jsonNode.has("message_id")) {
                optimized.put("message_id", jsonNode.get("message_id").asText());
            }
            if (jsonNode.has("conversation_id")) {
                optimized.put("conversation_id", jsonNode.get("conversation_id").asText());
            }
            if (jsonNode.has("answer")) {
                String answer = jsonNode.get("answer").asText();
                if (answer.length() > 1000) {
                    optimized.put("answer", answer.substring(0, 1000));
                    optimized.put("truncated", true);
                    optimized.put("original_length", answer.length());
                    logger.info("\u622a\u65adDify\u54cd\u5e94 #{} \u7684answer\u5b57\u6bb5: {}\u5b57\u7b26 -> 1000\u5b57\u7b26", (Object)messageIndex, (Object)answer.length());
                } else {
                    optimized.put("answer", answer);
                }
            }
            if (jsonNode.has("metadata")) {
                optimized.put("metadata", "{}");
            }
            if (jsonNode.has("created_at")) {
                optimized.put("created_at", jsonNode.get("created_at").asLong());
            }
            String result = objectMapper.writeValueAsString(optimized);
            logger.info("JSON\u54cd\u5e94\u4f18\u5316\u5b8c\u6210 #{}: {}bytes -> {}bytes", new Object[]{messageIndex, jsonNode.toString().getBytes(StandardCharsets.UTF_8).length, result.getBytes(StandardCharsets.UTF_8).length});
            return result;
        }
        catch (Exception e) {
            logger.error("\u4f18\u5316JSON\u54cd\u5e94\u5931\u8d25", (Throwable)e);
            return DifyResponseProcessor.createErrorResponse((String)"JSON\u4f18\u5316\u5931\u8d25");
        }
    }

    private static String optimizeTextResponse(String text, int messageIndex) {
        try {
            if (text.length() <= 1000) {
                return text;
            }
            String truncated = text.substring(0, 1000);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("type", "text_response");
            response.put("content", truncated);
            response.put("truncated", true);
            response.put("original_length", text.length());
            response.put("message_index", messageIndex);
            String result = objectMapper.writeValueAsString(response);
            logger.info("\u6587\u672c\u54cd\u5e94\u4f18\u5316\u5b8c\u6210 #{}: {}\u5b57\u7b26 -> {}\u5b57\u7b26", new Object[]{messageIndex, text.length(), truncated.length()});
            return result;
        }
        catch (Exception e) {
            logger.error("\u4f18\u5316\u6587\u672c\u54cd\u5e94\u5931\u8d25", (Throwable)e);
            return DifyResponseProcessor.createErrorResponse((String)"\u6587\u672c\u4f18\u5316\u5931\u8d25");
        }
    }

    private static String createErrorResponse(String errorMessage) {
        try {
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("type", "error");
            error.put("message", errorMessage);
            error.put("timestamp", System.currentTimeMillis());
            return objectMapper.writeValueAsString(error);
        }
        catch (Exception e) {
            return "{\"type\":\"error\",\"message\":\"\u5904\u7406\u5931\u8d25\"}";
        }
    }

    public static boolean needsProcessing(String data) {
        return data.getBytes(StandardCharsets.UTF_8).length > 4096;
    }
}

