/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.ribbon.loadbalancer;

import com.codingapi.tx.aop.bean.TxTransactionLocal;
import com.lorne.core.framework.utils.encode.MD5Util;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LcnLoadBalancerRule {
    private Logger logger = LoggerFactory.getLogger(LcnLoadBalancerRule.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server proxy(List<Server> servers, Server server) {
        TxTransactionLocal txTransactionLocal = TxTransactionLocal.current();
        if (txTransactionLocal == null) {
            return server;
        }
        try {
            this.logger.debug("LCNBalanceProxy - > start");
            String groupId = txTransactionLocal.getGroupId();
            String appName = server.getMetaInfo().getAppName();
            String key = MD5Util.md5((byte[])(groupId + "_" + appName).getBytes());
            if (servers.size() == 1) {
                this.putServer(key, txTransactionLocal, server);
                this.logger.debug("LCNBalanceProxy -> only one server available");
                Server server2 = server;
                return server2;
            }
            Server oldServer = this.getServer(txTransactionLocal, servers, key);
            if (oldServer != null) {
                this.logger.debug("LCNBalanceProxy - > load old server ");
                Server server3 = server;
                return server3;
            }
            this.putServer(key, txTransactionLocal, server);
            this.logger.debug("LCNBalanceProxy - > load new server ");
            Server server4 = server;
            return server4;
        }
        finally {
            this.logger.debug("LCNBalanceProxy - > end");
        }
    }

    private void putServer(String key, TxTransactionLocal txTransactionLocal, Server server) {
        String serviceName = server.getMetaInfo().getAppName();
        String address = server.getHostPort();
        String md5 = MD5Util.md5((byte[])(address + serviceName).getBytes());
        this.logger.debug("putServer->address->" + address + ",md5-->" + md5);
        txTransactionLocal.putLoadBalance(key, md5);
    }

    private Server getServer(TxTransactionLocal txTransactionLocal, List<Server> servers, String key) {
        String val = txTransactionLocal.getLoadBalance(key);
        if (StringUtils.isEmpty((String)val)) {
            return null;
        }
        for (Server server : servers) {
            String serviceName = server.getMetaInfo().getAppName();
            String address = server.getHostPort();
            String md5 = MD5Util.md5((byte[])(address + serviceName).getBytes());
            this.logger.debug("getServer->address->" + address + ",md5-->" + md5);
            if (!val.equals(md5)) continue;
            return server;
        }
        return null;
    }
}

