/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.springcloud.http;

import com.codingapi.tx.aop.bean.TxTransactionLocal;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class TransactionHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private Logger logger = LoggerFactory.getLogger(TransactionHttpRequestInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        TxTransactionLocal txTransactionLocal = TxTransactionLocal.current();
        String groupId = txTransactionLocal == null ? null : txTransactionLocal.getGroupId();
        this.logger.info("LCN-SpringCloud TxGroup info -> groupId:" + groupId);
        if (txTransactionLocal != null) {
            request.getHeaders().add("tx-group", groupId);
        }
        return execution.execute(request, body);
    }
}

