/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.springcloud.interceptor;

import com.codingapi.tx.springcloud.interceptor.TxManagerInterceptor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TransactionAspect
implements Ordered {
    private Logger logger = LoggerFactory.getLogger(TransactionAspect.class);
    @Autowired
    private TxManagerInterceptor txManagerInterceptor;

    @Around(value="@annotation(com.codingapi.tx.annotation.TxTransaction)")
    public Object transactionRunning(ProceedingJoinPoint point) throws Throwable {
        this.logger.debug("annotation-TransactionRunning-start---->");
        Object obj = this.txManagerInterceptor.around(point);
        this.logger.debug("annotation-TransactionRunning-end---->");
        return obj;
    }

    @Around(value="this(com.codingapi.tx.annotation.ITxTransaction) && execution( * *(..))")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        this.logger.debug("interface-ITransactionRunning-start---->");
        Object obj = this.txManagerInterceptor.around(point);
        this.logger.debug("interface-ITransactionRunning-end---->");
        return obj;
    }

    public int getOrder() {
        return 1000;
    }
}

