/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.springcloud.service.impl;

import com.codingapi.tx.listener.service.ModelNameService;
import com.codingapi.tx.springcloud.listener.ServerListener;
import com.lorne.core.framework.utils.encode.MD5Util;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

@Service
@Configuration
public class ModelNameServiceImpl
implements ModelNameService {
    @Value(value="${spring.application.name}")
    private String modelName;
    @Autowired
    private ServerListener serverListener;
    private String host = null;

    public String getModelName() {
        return this.modelName;
    }

    private String getIp() {
        if (this.host == null) {
            try {
                this.host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return this.host;
    }

    private int getPort() {
        int port = this.serverListener.getPort();
        int count = 0;
        while (port == 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            port = this.serverListener.getPort();
            if (++count != 2000) continue;
            throw new RuntimeException("get server port error.");
        }
        return port;
    }

    public String getUniqueKey() {
        String address = this.getIp() + this.getPort();
        return MD5Util.md5((byte[])address.getBytes());
    }

    public String getIpAddress() {
        String address = this.getIp() + ":" + this.getPort();
        return address;
    }
}

