/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ebaiyihui.aggregation.payment.common.vo.RequestGetAppIdVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.RequestAddMchParamVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.RequestGetMchChatVO;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.RequestMchParamVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.RequestSaveMchParamVo;
import com.ebaiyihui.aggregation.payment.common.vo.mchparamvo.ResponseMchParamPageVo;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.CrtUploadResp;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u5546\u6237\u6e20\u9053\u53c2\u6570"})
@RequestMapping(value={"/mchchan"})
public class MchChanController {
    private static final Logger log = LoggerFactory.getLogger(MchChanController.class);
    @Autowired
    private MchChanService mchChanService;

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\u5546\u6237\u6e20\u9053\u53c2\u6570")
    public BaseResponse save(@RequestBody RequestSaveMchParamVo requestSaveMchParamVo) {
        this.mchChanService.save(requestSaveMchParamVo);
        return BaseResponse.success();
    }

    @PostMapping(value={"/add_mch_chan"})
    @ApiOperation(value="\u6dfb\u52a0\u5e94\u7528\u6e20\u9053\u53c2\u6570")
    public BaseResponse addMchChan(@RequestBody RequestAddMchParamVo requestAddMchParamVo) {
        this.mchChanService.addMchChan(requestAddMchParamVo);
        return BaseResponse.success();
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u5546\u6237\u6e20\u9053\u53c2\u6570\u4fe1\u606f")
    public BaseResponse update(@RequestBody ResponseMchParamPageVo mchChan) {
        this.mchChanService.update(mchChan);
        return BaseResponse.success();
    }

    @PostMapping(value={"/getById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2")
    public BaseResponse getById(@RequestParam(value="id") Long id) {
        ResponseMchParamPageVo mchChan = this.mchChanService.getById(id);
        return BaseResponse.success((Object)mchChan);
    }

    @PostMapping(value={"/deleteById"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public BaseResponse deleteById(@RequestParam(value="id") Long id) {
        int count = this.mchChanService.delete(id);
        return BaseResponse.success((Object)count);
    }

    @PostMapping(value={"/getPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public BaseResponse<IPage<ResponseMchParamPageVo>> getPage(@RequestBody RequestMchParamVo requestMchParamVo) {
        IPage mchIPage = this.mchChanService.getPage(requestMchParamVo);
        return BaseResponse.success((Object)mchIPage);
    }

    @PostMapping(value={"/getappid"})
    public BaseResponse<List<String>> getAppIdByMchAndPayType(@RequestBody RequestGetAppIdVo requestGetAppIdVo) {
        return this.mchChanService.getAppIdList(requestGetAppIdVo);
    }

    @PostMapping(value={"/get_mchChan_list"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2")
    public BaseResponse getMchChanByMchIdAndMchCode(@RequestBody RequestGetMchChatVO requestGetMchChatVO) {
        List mchIdAndMchCode = this.mchChanService.getMchChanByMchIdAndMchCode(requestGetMchChatVO);
        return BaseResponse.success((Object)mchIdAndMchCode);
    }

    @GetMapping(value={"/getMchChans"})
    @ApiOperation(value="\u6839\u636eapplyCode \u67e5\u8be2")
    public BaseResponse getMchChanByApply(@RequestParam(value="applyCode") String applyCode) {
        List mchChanByApply = this.mchChanService.getMchChanByApply(applyCode);
        return BaseResponse.success((Object)mchChanByApply);
    }

    @ApiOperation(value="\u652f\u4ed8\u5b9d\u5e94\u7528crt\u8bc1\u4e66\u4e0a\u4f20\u4e13\u7528\u63a5\u53e3", tags={"\u652f\u4ed8\u5b9d\u5e94\u7528crt\u8bc1\u4e66\u4e0a\u4f20\u4e13\u7528\u63a5\u53e3"})
    @PostMapping(value={"/crt_upload"})
    public BaseResponse<?> upload(@RequestParam(value="file") MultipartFile file) {
        try {
            if (file.isEmpty()) {
                return BaseResponse.error((String)"\u8bf7\u9009\u62e9\u6587\u4ef6");
            }
            String originalFilename = file.getOriginalFilename();
            BufferedReader br = new BufferedReader(new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder b = new StringBuilder();
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = br.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                b.append(readData);
            }
            CrtUploadResp c = new CrtUploadResp(originalFilename, b.toString());
            return BaseResponse.success((Object)c);
        }
        catch (IOException | IllegalStateException e) {
            log.info("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,err={}", (Object)Arrays.toString(e.getStackTrace()));
            return BaseResponse.error((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
        }
    }
}

