/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.addition;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.AdditionRecord;
import com.ebaiyihui.aggregation.payment.common.model.BatchAdditionBill;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.server.addition.Addition;
import com.ebaiyihui.aggregation.payment.server.addition.AdditionStatusEnum;
import com.ebaiyihui.aggregation.payment.server.addition.IAddition;
import com.ebaiyihui.aggregation.payment.server.addition.MybankAddition;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.AdditionRecordMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.BatchAdditionBillMapper;
import com.ebaiyihui.aggregation.payment.server.mybank.DefaultMybankClient;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankApiException;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankRequest;
import com.ebaiyihui.aggregation.payment.server.mybank.bo.MyBankConfigBO;
import com.ebaiyihui.aggregation.payment.server.mybank.bo.SharingSftpBO;
import com.ebaiyihui.aggregation.payment.server.mybank.config.MybankConfig;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.RequestBody;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.RespInfo;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.model.bill.BkcloudfundsBillPayRequestModel;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.model.bill.BkcloudfundsBillPayResponseModel;
import com.ebaiyihui.aggregation.payment.server.mybank.domain.model.bill.BkcloudfundsBillRecordsModel;
import com.ebaiyihui.aggregation.payment.server.mybank.internal.util.SFTPUtil;
import com.ebaiyihui.aggregation.payment.server.mybank.request.bill.BkcloudfundsBillPayRequest;
import com.ebaiyihui.aggregation.payment.server.mybank.response.bill.BkcloudfundsBillPayResponse;
import com.ebaiyihui.aggregation.payment.server.service.ChannelBillService;
import com.ebaiyihui.framework.response.BaseResponse;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MybankAddition
implements IAddition,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MybankAddition.class);
    @Resource
    private AdditionRecordMapper additionRecordMapper;
    @Resource
    private ChannelBillService channelBillService;
    @Resource
    private BatchAdditionBillMapper batchAdditionBillMapper;
    @Value(value="${pay.bill.environment}")
    private String payEnvironment;
    @Value(value="${mybank.sftp.url}")
    private String sftpUrl;
    @Value(value="${mybank.sftp.port}")
    private int sftpPort;
    private final BigDecimal YUAN_TO_CENT = new BigDecimal("100");

    public BaseResponse addOrder(PayBill payBill, MchChan mchChan) {
        log.info("\u4e91\u8d44\u91d1\u8865\u5355\u63a5\u53e3 \u5f00\u59cb\u6267\u884c payBill={},mchChan={}", (Object)payBill, (Object)mchChan);
        MyBankConfigBO myBankConfigBO = (MyBankConfigBO)JSONObject.parseObject((String)mchChan.getParam(), MyBankConfigBO.class);
        DefaultMybankClient mybankClient = new DefaultMybankClient(MybankConfig.serverUrl, myBankConfigBO.getPrivateKey(), myBankConfigBO.getPublicKey());
        BkcloudfundsBillPayRequest billPayRequest = new BkcloudfundsBillPayRequest(myBankConfigBO.getAppId());
        String outTradeNo = payBill.getOutTradeNo();
        AdditionRecord additionRecord = new AdditionRecord();
        this.saveAdditionRecord(outTradeNo, additionRecord);
        this.initModel(payBill, mchChan, myBankConfigBO, billPayRequest);
        try {
            BkcloudfundsBillPayResponse billPayResponse = (BkcloudfundsBillPayResponse)mybankClient.execute((MybankRequest)billPayRequest);
            BkcloudfundsBillPayResponseModel billPayResponseModel = billPayResponse.getBkcloudfundsBillPay().getBkcloudfundsBillPayResponseModel();
            String requestContent = billPayResponse.getRequestContent();
            log.info("mybank addition request:{}", (Object)requestContent);
            String xmlContent = billPayResponse.getXmlContent();
            log.info("mybank addition response:{}", (Object)xmlContent);
            RespInfo respInfo = billPayResponseModel.getRespInfo();
            if ("S".equals(respInfo.getResultStatus())) {
                additionRecord.setOrderStatus(Integer.valueOf(AdditionStatusEnum.SUCCESS.getValue()));
                additionRecord.setTradeNo(billPayResponseModel.getOrderNo());
                this.additionRecordMapper.updateStatus(additionRecord);
                return BaseResponse.success();
            }
            additionRecord.setOrderStatus(Integer.valueOf(AdditionStatusEnum.ERROR.getValue()));
            this.additionRecordMapper.updateStatus(additionRecord);
            log.error("addition error,outTradeNo:{}", (Object)outTradeNo);
            return BaseResponse.error((String)respInfo.getResultMsg());
        }
        catch (MybankApiException e) {
            log.error("mybank addition error,e=", (Throwable)e);
            return BaseResponse.error((String)e.getErrMsg());
        }
    }

    private void saveAdditionRecord(String outTradeNo, AdditionRecord additionRecord) {
        additionRecord.setOutTradeNo(outTradeNo);
        additionRecord.setType(PayChanEnum.MYBANK.getDisplay());
        additionRecord.setOrderStatus(Integer.valueOf(AdditionStatusEnum.PROCESSING.getValue()));
        this.additionRecordMapper.insert((Object)additionRecord);
    }

    private void initModel(PayBill payBill, MchChan mchChan, MyBankConfigBO myBankConfigBO, BkcloudfundsBillPayRequest billPayRequest) {
        BkcloudfundsBillPayRequestModel billPayRequestModel = new BkcloudfundsBillPayRequestModel();
        billPayRequestModel.setIsvOrgId(myBankConfigBO.getIsvOrgId());
        billPayRequestModel.setPayeeMerchantId(mchChan.getMerchantsMark());
        billPayRequestModel.setOutTradeNo(payBill.getOutTradeNo());
        billPayRequestModel.setTotalAmount(payBill.getOrderAmount().multiply(this.YUAN_TO_CENT).intValue() + "");
        billPayRequestModel.setCurrency("CNY");
        billPayRequestModel.setTradeType("SINGLE_PAY");
        billPayRequestModel.setBody("\u4e91\u8d44\u91d1-\u6d4b\u8bd5\u6570\u636e");
        billPayRequest.setRequestBody((RequestBody)billPayRequestModel);
    }

    public void afterPropertiesSet() throws Exception {
        Addition.register((String)PayChanEnum.MYBANK.getDisplay(), (IAddition)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadBkcloudBill(String billdate, String isvOrgId, List<SharingSftpBO> sharingSftpBOList) {
        SharingSftpBO sharingSftpBO = sharingSftpBOList.get(0);
        String userName = sharingSftpBO.getUserName();
        String password = sharingSftpBO.getPassword();
        List applyCodeList = sharingSftpBOList.stream().map(SharingSftpBO::getApplyCode).collect(Collectors.toList());
        ArrayList bkcloudfundsBillRecordsModels = new ArrayList();
        if ("test".equals(this.payEnvironment)) {
            bkcloudfundsBillRecordsModels.addAll(this.additionRecordMapper.selectListByTestSftp(billdate, applyCodeList));
        } else {
            bkcloudfundsBillRecordsModels.addAll(this.channelBillService.getByBilllDate(billdate, applyCodeList));
        }
        log.info("mybank need upload sharing record:{}", (Object)JSONObject.toJSONString(bkcloudfundsBillRecordsModels));
        String directory = "/upload/" + isvOrgId + "/" + billdate;
        String fileNameDetail = "merchant_trade_detail_" + billdate + ".txt";
        String fileNameFinished = "finish_" + billdate + ".txt";
        SFTPUtil sftp = new SFTPUtil(userName, password, this.sftpUrl, this.sftpPort);
        try {
            sftp.login();
            InputStream inputStream = BkcloudfundsBillRecordsModel.billInputStream(bkcloudfundsBillRecordsModels);
            sftp.upload(directory, fileNameDetail, inputStream);
            1 finishStream = new /* Unavailable Anonymous Inner Class!! */;
            sftp.upload(directory, fileNameFinished, (InputStream)finishStream);
            this.saveBatchBill(billdate, isvOrgId, bkcloudfundsBillRecordsModels);
            boolean bl = true;
            return bl;
        }
        catch (SftpException | IOException e) {
            log.error("SFTP \u4e0a\u4f20\u5bf9\u8d26\u6587\u4ef6\u5f02\u5e38 e={},directory={},fileName={}", (Object)e.getMessage(), (Object)directory);
        }
        finally {
            sftp.logout();
        }
        return false;
    }

    private void saveBatchBill(String billdate, String isvOrgId, List<BkcloudfundsBillRecordsModel> bkcloudfundsBillRecordsModels) {
        if (!bkcloudfundsBillRecordsModels.isEmpty()) {
            ArrayList<BatchAdditionBill> list = new ArrayList<BatchAdditionBill>();
            for (BkcloudfundsBillRecordsModel bkcloudfundsBillRecordsModel : bkcloudfundsBillRecordsModels) {
                BatchAdditionBill batchAdditionBill = new BatchAdditionBill();
                batchAdditionBill.setOutTradeNo(bkcloudfundsBillRecordsModel.getOutTradeNo());
                batchAdditionBill.setBatchNo(billdate);
                batchAdditionBill.setIsvOrgId(isvOrgId);
                list.add(batchAdditionBill);
            }
            this.batchAdditionBillMapper.insertList(list);
        }
    }
}

