/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.business;

import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.server.business.IPay;
import com.ebaiyihui.aggregation.payment.server.business.PayFactory;
import com.ebaiyihui.aggregation.payment.server.enums.AliPayTradeTypeEnum;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.impl.AlipayServiceImpl;
import com.ebaiyihui.framework.response.BaseResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliPay
implements IPay,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AliPay.class);
    @Autowired
    private AlipayServiceImpl alipayService;
    @Autowired
    private PayBillService payBillService;
    @Autowired
    private MchChanService mchChanService;

    public BaseResponse<String> pay(HttpServletRequest request, RequestCreateOrderVo requestCreateOrderVo) {
        PayBill payBill = this.payBillService.getByOutTradeNo(requestCreateOrderVo.getOutTradeNo());
        payBill.setTradeChannel(PayChanEnum.ALIPAY.getDisplay());
        payBill.setTradeType(AliPayTradeTypeEnum.WAP.getDisplay());
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(payBill.getMchCode(), payBill.getTradeChannel(), payBill.getTradeType());
        if (null == mchChan) {
            return BaseResponse.error((String)"\u5546\u6237\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u652f\u4ed8\u7cfb\u7edf\u7ba1\u7406\u4eba\u5458\u68c0\u67e5\u914d\u7f6e");
        }
        if (null != payBill) {
            this.payBillService.update(payBill);
            log.info("\u8d26\u5355\u5185\u5bb9\uff1a{}", (Object)payBill.toString());
            requestCreateOrderVo.setPayChannel(PayChanEnum.ALIPAY.getDisplay());
            requestCreateOrderVo.setPayType(AliPayTradeTypeEnum.WAP.getDisplay());
            return this.alipayService.createPolymericOrder(request, payBill, requestCreateOrderVo);
        }
        return BaseResponse.error((String)"\u8d26\u5355\u4e0d\u5b58\u5728!");
    }

    public void afterPropertiesSet() {
        PayFactory.register((String)PayChanEnum.ALIPAY.getDisplay(), (IPay)this);
    }
}

