/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.hypay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.MchChan;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.ProfitSharingOperatingData;
import com.ebaiyihui.aggregation.payment.common.model.ProfitSharingRecord;
import com.ebaiyihui.aggregation.payment.common.model.ProfitSharingRules;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.common.vo.RequestRefundOrderVo;
import com.ebaiyihui.aggregation.payment.server.enums.ProfitSharingEnums;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyDividableBalanceAllotData;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyProfitSharingRecordVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyProfitSharingReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyProfitSharingRespVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyPublicParameReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyQueryRemainReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyQueryRemainRespVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyRefundBySplitAccountReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyRefundBySplitAccountRespVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HyRefundPayOrderRespVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.HySubAccountRespVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.ProfitSharingDTO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPay.ProfitSharingReqVO;
import com.ebaiyihui.aggregation.payment.server.hypay.HyPayChannelTypeEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.ProfitSharingOperatingDataMapper;
import com.ebaiyihui.aggregation.payment.server.profitSharing.IProfitSharing;
import com.ebaiyihui.aggregation.payment.server.service.BaseService;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.utils.HttpsClientUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HyProfitSharing
extends BaseService
implements IProfitSharing {
    private static final Logger log = LoggerFactory.getLogger(HyProfitSharing.class);
    @Autowired
    private MchChanService mchChanService;
    @Resource
    private ProfitSharingOperatingDataMapper profitSharingOperatingDataMapper;

    public BaseResponse multiProfitSharing(PayBill payBill, String applyCode, ProfitSharingReqVO profitSharingReqVO) {
        String mchCode = applyCode;
        MchChan mchChan = this.mchChanService.getMchChanByApplyAndChanCodeAndType(applyCode, payBill.getTradeChannel(), payBill.getTradeType());
        String param = mchChan.getParam();
        WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
        HyPublicParameReqVO hyPublicParameReqVO = this.publicParamCompose(hyParam.getHyApplyId(), hyParam.getUHyId());
        HyQueryRemainRespVO remainRespVO = this.queryProfitSharing(payBill, hyPublicParameReqVO, mchChan);
        if (!ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_SUCCESS.getProfitSharingJudgment().equals(remainRespVO.getReturn_code()) || !ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_SUCCESS.getProfitSharingJudgment().equals(remainRespVO.getResult_code())) {
            log.error("[\u6c47\u4ed8\u5b9d] \u53ef\u5206\u6da6\u4f59\u989d\u67e5\u8be2\u5931\u8d25!");
            return BaseResponse.error((String)"[\u6c47\u4ed8\u5b9d] \u53ef\u5206\u6da6\u4f59\u989d\u67e5\u8be2\u5931\u8d25! \u5206\u6da6\u5931\u8d25!");
        }
        String amtFen = remainRespVO.getHyDividableBalanceAllotData().getRemain_amt_fen();
        log.info("\u6539\u8d26\u6237\u53ef\u5206\u4f59\u989d:" + amtFen);
        List startRulesByMainMch = this.rulesMapper.getStartRulesByMainMch(hyParam.getUHyId());
        HyProfitSharingRespVO sharingRespVO = this.HyProfitSharing(payBill, startRulesByMainMch, hyPublicParameReqVO, mchChan, amtFen);
        return BaseResponse.success((Object)sharingRespVO);
    }

    public BaseResponse profitSharing(ProfitSharingReqVO profitSharingReqVO, String applyCode) {
        return null;
    }

    public BaseResponse refundShare(RequestRefundOrderVo requestRefundOrderV, String applyCode) {
        return null;
    }

    public HyProfitSharingRespVO HyProfitSharing(PayBill payBill, List<ProfitSharingRules> startProfitSharing, HyPublicParameReqVO hyPublicParameReqVO, MchChan mchChan, String amtFen) {
        HyProfitSharingRespVO sharingRespVO = new HyProfitSharingRespVO();
        ProfitSharingRecord profitSharingRecord = new ProfitSharingRecord();
        HyProfitSharingRecordVO hyProfitSharingRecordVO = new HyProfitSharingRecordVO();
        String param = mchChan.getParam();
        WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
        if (startProfitSharing.size() > 0) {
            hyProfitSharingRecordVO.setRuleId(startProfitSharing.get(0).getRuleId());
        }
        hyProfitSharingRecordVO.setAmtFen(amtFen);
        try {
            boolean resultCodeValidate;
            ArrayList<ProfitSharingDTO> dtoList = new ArrayList<ProfitSharingDTO>();
            for (ProfitSharingRules sharingRule : startProfitSharing) {
                ProfitSharingOperatingData profitSharingOperatingData = new ProfitSharingOperatingData();
                ProfitSharingDTO profitSharingDTO = new ProfitSharingDTO();
                profitSharingDTO.setLogin_account(sharingRule.getAccountId());
                profitSharingOperatingData.setHyBillNo(payBill.getTradeNo());
                profitSharingOperatingData.setOutTradeNo(payBill.getDealTradeNo());
                profitSharingOperatingData.setAccountId(sharingRule.getAccountId());
                BigDecimal amtFee = new BigDecimal(amtFen);
                BigDecimal allotAmtFens = sharingRule.getAllotAmtFen();
                BigDecimal allotFee = amtFee.subtract(allotAmtFens);
                log.info("allotFee:" + allotFee + "/amtFee" + amtFee + "shareProfit");
                System.out.println("allotFee:" + allotFee + "/amtFee" + amtFee + "shareProfit");
                profitSharingDTO.setAllot_amt_fen(allotAmtFens.toString());
                profitSharingOperatingData.setAllotAmtFen(sharingRule.getAllotAmtFen());
                profitSharingOperatingData.setAmtFen(amtFee);
                profitSharingOperatingData.setApplyId(hyParam.getHyApplyId());
                log.info("\u5206\u8d26\u65e5\u5fd7\u53c2\u6570{}:" + profitSharingOperatingData.toString());
                this.profitSharingOperatingDataMapper.insert(profitSharingOperatingData);
                dtoList.add(profitSharingDTO);
            }
            HyProfitSharingReqVO biz_content = new HyProfitSharingReqVO();
            biz_content.setAllot_data(JSONObject.toJSONString(dtoList));
            biz_content.setHy_bill_no(payBill.getTradeNo());
            biz_content.setOut_trade_no(payBill.getDealTradeNo());
            hyProfitSharingRecordVO.setAllotData(JSONObject.toJSONString((Object)biz_content));
            profitSharingRecord.setOutTradeNo(payBill.getDealTradeNo());
            hyPublicParameReqVO.setBiz_content(JSONObject.toJSONString((Object)biz_content));
            hyPublicParameReqVO.setMethod("heemoney.guaranteeallot.submit");
            boolean reqVOSign = hyPublicParameReqVO.createSign(hyParam.getHyApplyKey());
            if (!reqVOSign) {
                BaseResponse.error((String)" [\u6c47\u4ed8\u5b9d] \u5206\u6da6\u8ba2\u5355\u5931\u8d25,\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            String url = "https://pay.heemoney.com/v1/GuaranteeAllot";
            JSONObject jsonObject = HttpsClientUtil.doPostForJson((String)url, (String)JSONObject.toJSONString((Object)hyPublicParameReqVO));
            log.info("\u6c47\u5143\u5206\u6da6\u8fd4\u56de:{}", (Object)jsonObject);
            sharingRespVO = (HyProfitSharingRespVO)JSONObject.toJavaObject((JSON)jsonObject, HyProfitSharingRespVO.class);
            hyProfitSharingRecordVO.setApplyId(hyParam.getHyApplyId());
            profitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_PROCESSING.getProfitSharingStatusCode());
            boolean bl = resultCodeValidate = StringUtils.isNotBlank((CharSequence)sharingRespVO.getResult_code()) && sharingRespVO.getResult_code().equals(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_FAILURE.getProfitSharingJudgment()) || sharingRespVO.getReturn_code().equals("FAIL");
            if (resultCodeValidate) {
                profitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_FAILURE.getProfitSharingStatusCode());
                profitSharingRecord.setProfitSharingResultMsg(StringUtils.isBlank((CharSequence)sharingRespVO.getError_msg()) ? sharingRespVO.getReturn_msg() : sharingRespVO.getError_msg());
                profitSharingRecord.setProfitSharingErrorCode(StringUtils.isBlank((CharSequence)sharingRespVO.getError_code()) ? "" : sharingRespVO.getError_code());
            }
            profitSharingRecord.setProfitSharingOperatingData(JSONObject.toJSONString((Object)hyProfitSharingRecordVO));
            String sharData = JSONObject.toJSONString((Object)hyProfitSharingRecordVO);
            ProfitSharingOperatingData data = (ProfitSharingOperatingData)JSON.parseObject((String)sharData, ProfitSharingOperatingData.class);
            profitSharingRecord.setProfitSharingType(ProfitSharingEnums.ProfitSharingTypeEnum.HY_PROFIT_SHARING.getProfitSharingTypeId());
            profitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_SUCCESS.getProfitSharingStatusCode());
            this.profitSharingRecordMapper.insert((Object)profitSharingRecord);
        }
        catch (Exception e) {
            log.info(" [\u6c47\u4ed8\u5b9d] \u5206\u6da6\u8ba2\u5355\u5931\u8d25,\u9519\u8bef\u539f\u56e0:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
        }
        return sharingRespVO;
    }

    public HyQueryRemainRespVO queryProfitSharing(PayBill payBill, HyPublicParameReqVO hyPublicParameReqVO, MchChan mchChan) {
        HyQueryRemainReqVO biz_content = new HyQueryRemainReqVO(payBill);
        String jsonString = JSONObject.toJSONString((Object)biz_content);
        hyPublicParameReqVO.setMethod("heemoney.guaranteeallot.query");
        hyPublicParameReqVO.setBiz_content(jsonString);
        String param = mchChan.getParam();
        WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
        boolean reqVOSign = hyPublicParameReqVO.createSign(hyParam.getHyApplyKey());
        if (!reqVOSign) {
            return new HyQueryRemainRespVO(" [\u6c47\u4ed8\u5b9d] \u67e5\u8be2\u8ba2\u5355\u5931\u8d25,\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!", "CREATE_SIGN_FAIL");
        }
        String url = "https://pay.heemoney.com/v1/GuaranteeAllot";
        log.info("[\u6c47\u4ed8\u5b9d] \u53ef\u5206\u6da6\u4f59\u989d\u67e5\u8be2,\u8bf7\u6c42URL:{},\u8bf7\u6c42\u5165\u53c2:{}", (Object)url, (Object)JSONObject.toJSONString((Object)hyPublicParameReqVO));
        JSONObject jsonObject = HttpsClientUtil.doPostForJson((String)url, (String)JSONObject.toJSONString((Object)hyPublicParameReqVO));
        log.info("[\u6c47\u4ed8\u5b9d] \u53ef\u5206\u6da6\u4f59\u989d\u67e5\u8be2\u8fd4\u56de:{}", (Object)jsonObject);
        if (Objects.isNull(jsonObject)) {
            log.info("\u8fd4\u56de\u503cjsonObject:" + jsonObject);
            return new HyQueryRemainRespVO(" [\u6c47\u4ed8\u5b9d] \u8bf7\u6c42\u6c47\u4ed8\u5b9d\u8fd4\u56de\u7a7a\u503c");
        }
        HyQueryRemainRespVO orderRespVO = (HyQueryRemainRespVO)JSONObject.toJavaObject((JSON)jsonObject, HyQueryRemainRespVO.class);
        HyDividableBalanceAllotData allot_data = (HyDividableBalanceAllotData)JSONObject.parseObject((String)jsonObject.getString("allot_data").toString(), HyDividableBalanceAllotData.class);
        orderRespVO.setHyDividableBalanceAllotData(allot_data);
        return orderRespVO;
    }

    public HyPublicParameReqVO publicParamCompose(String appid, String mchuid) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String format = df.format(new Date());
        HyPublicParameReqVO build = HyPublicParameReqVO.newBuilder().version("1.0").app_id(appid).mch_uid(mchuid).charset("UTF-8").timestamp(format).sign_type("MD5").build();
        return build;
    }

    @Transactional(rollbackFor={Exception.class})
    public HyRefundBySplitAccountRespVO refundBySplitAccount(HyRefundBySplitAccountReqVO hyRefundBySplitAccountReqVO) {
        Boolean validateParamResult = hyRefundBySplitAccountReqVO.validateParam();
        if (Boolean.FALSE.equals(validateParamResult)) {
            return new HyRefundBySplitAccountRespVO("\u53c2\u6570\u6821\u9a8c\u5931\u8d25,\u8bf7\u68c0\u67e5\u4f60\u7684\u5165\u53c2");
        }
        ProfitSharingRecord queryProfitSharingRecord = new ProfitSharingRecord();
        queryProfitSharingRecord.setOutTradeNo(hyRefundBySplitAccountReqVO.getOut_trade_no());
        queryProfitSharingRecord.setProfitSharingType(ProfitSharingEnums.ProfitSharingTypeEnum.HY_PROFIT_SHARING.getProfitSharingTypeId());
        queryProfitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_SUCCESS.getProfitSharingStatusCode());
        QueryWrapper queryWrapper = new QueryWrapper((Object)queryProfitSharingRecord);
        ProfitSharingRecord profitSharingRecord = (ProfitSharingRecord)this.profitSharingRecordMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.isNull(profitSharingRecord)) {
            return new HyRefundBySplitAccountRespVO("\u5206\u8d26\u8bb0\u5f55\u67e5\u8be2\u5f02\u5e38");
        }
        if (StringUtils.isBlank((CharSequence)profitSharingRecord.getProfitSharingOperatingData())) {
            return new HyRefundBySplitAccountRespVO("\u5206\u8d26\u64cd\u4f5c\u6570\u636e\u6709\u8bef,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String profitSharingOperatingData = profitSharingRecord.getProfitSharingOperatingData();
        HyProfitSharingRecordVO hyProfitSharingRecordVO = (HyProfitSharingRecordVO)JSONObject.parseObject((String)profitSharingOperatingData, HyProfitSharingRecordVO.class);
        QueryWrapper mchChanQueryWrapper = new QueryWrapper();
        mchChanQueryWrapper.eq((Object)"app_id", (Object)hyProfitSharingRecordVO.getApplyId());
        mchChanQueryWrapper.last("LIMIT 1");
        MchChan mchChan = (MchChan)this.mchChanMapper.selectOne((Wrapper)mchChanQueryWrapper);
        if (Objects.isNull(mchChan)) {
            return new HyRefundBySplitAccountRespVO("\u8bf7\u68c0\u67e5\u5f53\u524d\u8ba2\u5355\u662f\u5426\u4e3a\u6c47\u4ed8\u5b9d\u8ba2\u5355");
        }
        hyRefundBySplitAccountReqVO.setAllot_data(hyProfitSharingRecordVO.getAllotData());
        String param = mchChan.getParam();
        WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
        HyPublicParameReqVO hyPublicParameReqVO = this.publicParamCompose(hyParam.getHyApplyId(), hyParam.getUHyId());
        hyPublicParameReqVO.setBiz_content(JSONObject.toJSONString((Object)hyRefundBySplitAccountReqVO));
        hyPublicParameReqVO.setMethod("heemoney.guaranteeallot.refund.submit");
        boolean signResult = hyPublicParameReqVO.createSign(hyParam.getHyApplyKey());
        if (!signResult) {
            return new HyRefundBySplitAccountRespVO(" [\u6c47\u4ed8\u5b9d] \u67e5\u8be2\u8ba2\u5355\u5931\u8d25,\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        log.info("[\u6c47\u4ed8\u5b9d] \u5206\u6da6\u9000\u6b3e,\u8bf7\u6c42URL:{},\u8bf7\u6c42\u5165\u53c2:{}", (Object)"https://pay.heemoney.com/v1/GuaranteeAllot", (Object)JSONObject.toJSONString((Object)hyPublicParameReqVO));
        JSONObject jsonObject = HttpsClientUtil.doPostForJson((String)"https://pay.heemoney.com/v1/GuaranteeAllot", (String)JSONObject.toJSONString((Object)hyPublicParameReqVO));
        log.info("[\u6c47\u4ed8\u5b9d] \u5206\u6da6\u9000\u6b3e,\u8bf7\u6c42URL:{},\u8fd4\u56de\u53c2\u6570:{}", (Object)"https://pay.heemoney.com/v1/GuaranteeAllot", (Object)JSONObject.toJSONString((Object)jsonObject));
        HySubAccountRespVO hySubAccountRespVO = (HySubAccountRespVO)JSONObject.toJavaObject((JSON)jsonObject, HySubAccountRespVO.class);
        if (StringUtils.isNotBlank((CharSequence)hySubAccountRespVO.getReturn_code()) && hySubAccountRespVO.getReturn_code().equals(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_FAILURE.getProfitSharingJudgment())) {
            return new HyRefundBySplitAccountRespVO("\u5206\u8d26\u5f02\u5e38," + hySubAccountRespVO.getReturn_msg());
        }
        PayBill payBill = new PayBill();
        payBill.setDealTradeNo(hyRefundBySplitAccountReqVO.getOut_trade_no());
        QueryWrapper payBillQueryWrapper = new QueryWrapper((Object)payBill);
        PayBill queryPayBill = (PayBill)this.payBillMapper.selectOne((Wrapper)payBillQueryWrapper);
        RequestRefundOrderVo requestRefundOrderVo = this.getRequestRefundOrderVo(hyRefundBySplitAccountReqVO, hyProfitSharingRecordVO, mchChan, queryPayBill);
        BaseResponse baseResponse = this.hyPayTrade.refundOrder(requestRefundOrderVo);
        HyRefundPayOrderRespVO hyRefundPayOrderRespVO = (HyRefundPayOrderRespVO)baseResponse.getData();
        HyRefundBySplitAccountRespVO hyRefundBySplitAccountRespVO = new HyRefundBySplitAccountRespVO();
        BeanUtils.copyProperties((Object)hyRefundPayOrderRespVO, (Object)hyRefundBySplitAccountRespVO);
        return hyRefundBySplitAccountRespVO;
    }

    @NotNull
    private RequestRefundOrderVo getRequestRefundOrderVo(HyRefundBySplitAccountReqVO hyRefundBySplitAccountReqVO, HyProfitSharingRecordVO hyProfitSharingRecordVO, MchChan mchChan, PayBill queryPayBill) {
        RequestRefundOrderVo requestRefundOrderVo = new RequestRefundOrderVo();
        requestRefundOrderVo.setDealTradeNo(hyRefundBySplitAccountReqVO.getOut_trade_no());
        requestRefundOrderVo.setTotalAmount(new BigDecimal(hyProfitSharingRecordVO.getAmtFen()));
        requestRefundOrderVo.setRefundAmount(new BigDecimal(hyProfitSharingRecordVO.getAmtFen()));
        requestRefundOrderVo.setMchCode(queryPayBill.getMchCode());
        requestRefundOrderVo.setPayChannel(HyPayChannelTypeEnum.getChannelType((String)queryPayBill.getTradeChannel(), (String)queryPayBill.getTradeType()));
        String param = mchChan.getParam();
        WxPayParam hyParam = (WxPayParam)JSON.parseObject((String)param, WxPayParam.class);
        requestRefundOrderVo.setApplyCode(hyParam.getApplyCode());
        return requestRefundOrderVo;
    }

    public List<ProfitSharingOperatingData> selectProfitSharingOperatingDate(String outTradeNo) {
        List list = this.profitSharingOperatingDataMapper.selectProfitSharingOperatingDate(outTradeNo);
        return list;
    }
}

