/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ebaiyihui.aggregation.payment.common.model.Dictionary;
import com.ebaiyihui.aggregation.payment.common.vo.DictionaryAndChildrenRes;
import com.ebaiyihui.aggregation.payment.server.mapper.DictionaryMapper;
import com.ebaiyihui.aggregation.payment.server.service.DictionaryService;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class DictionaryServiceImpl
implements DictionaryService {
    private static final Logger log = LoggerFactory.getLogger(DictionaryServiceImpl.class);
    @Resource
    private DictionaryMapper dictionaryMapper;

    public BaseResponse<List<DictionaryAndChildrenRes>> findDictionaryAndChildrenByType(String type) {
        List list = this.dictionaryMapper.findByTypeCode(type);
        ArrayList<DictionaryAndChildrenRes> listRes = new ArrayList<DictionaryAndChildrenRes>();
        if (list.isEmpty()) {
            return BaseResponse.success(listRes);
        }
        for (Dictionary dic : list) {
            DictionaryAndChildrenRes resVo = new DictionaryAndChildrenRes();
            BeanUtils.copyProperties((Object)dic, (Object)resVo);
            List listChildren = this.dictionaryMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(Dictionary::getParentCode, (Object)dic.getDicCode()));
            ArrayList<DictionaryAndChildrenRes> listRes1 = new ArrayList<DictionaryAndChildrenRes>();
            for (Dictionary dic1 : listChildren) {
                DictionaryAndChildrenRes resVo1 = new DictionaryAndChildrenRes();
                BeanUtils.copyProperties((Object)dic1, (Object)resVo1);
                listRes1.add(resVo1);
            }
            listRes.add(resVo);
        }
        return BaseResponse.success(listRes);
    }

    public BaseResponse<List<DictionaryAndChildrenRes>> getDictionaryList() {
        List<DictionaryAndChildrenRes> levelList;
        String dicCode;
        String gb_one_level = "4";
        String gb_two_level = "5";
        String gb_three_level = "6";
        String dicTypeArr = "4,5,6";
        List dictionaryList = this.dictionaryMapper.getDictionaryList(dicTypeArr);
        Map<String, List<DictionaryAndChildrenRes>> listMap = dictionaryList.stream().collect(Collectors.groupingBy(DictionaryAndChildrenRes::getDicType));
        List<DictionaryAndChildrenRes> oneLevelList = listMap.get(gb_one_level);
        List<DictionaryAndChildrenRes> twoLevelList = listMap.get(gb_two_level);
        List<DictionaryAndChildrenRes> threeLevelList = listMap.get(gb_three_level);
        Map<String, List<DictionaryAndChildrenRes>> twoLevelMap = twoLevelList.stream().collect(Collectors.groupingBy(DictionaryAndChildrenRes::getParentCode));
        Map<String, List<DictionaryAndChildrenRes>> threeLevelMap = threeLevelList.stream().collect(Collectors.groupingBy(DictionaryAndChildrenRes::getParentCode));
        for (DictionaryAndChildrenRes dictionaryAndChildrenRes : twoLevelList) {
            dicCode = dictionaryAndChildrenRes.getDicCode();
            levelList = threeLevelMap.get(dicCode);
            dictionaryAndChildrenRes.setChildrenRes(levelList);
        }
        for (DictionaryAndChildrenRes dictionaryAndChildrenRes : oneLevelList) {
            dicCode = dictionaryAndChildrenRes.getDicCode();
            levelList = twoLevelMap.get(dicCode);
            dictionaryAndChildrenRes.setChildrenRes(levelList);
        }
        return BaseResponse.success(oneLevelList);
    }

    public BaseResponse<List<Dictionary>> getDictionaryByParentCode(String parentCode) {
        List list = this.dictionaryMapper.getDictionaryByParentCode(parentCode);
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<List<DictionaryAndChildrenRes>> getIndustryDictionaryList() {
        String gb_one_level = "51";
        String gb_two_level = "52";
        String dicTypeArr = "51,52";
        List dictionaryList = this.dictionaryMapper.getDictionaryList(dicTypeArr);
        Map<String, List<DictionaryAndChildrenRes>> listMap = dictionaryList.stream().collect(Collectors.groupingBy(DictionaryAndChildrenRes::getDicType));
        List<DictionaryAndChildrenRes> oneLevelList = listMap.get(gb_one_level);
        List<DictionaryAndChildrenRes> twoLevelList = listMap.get(gb_two_level);
        Map<String, List<DictionaryAndChildrenRes>> twoLevelMap = twoLevelList.stream().collect(Collectors.groupingBy(DictionaryAndChildrenRes::getParentCode));
        for (DictionaryAndChildrenRes dictionaryAndChildrenRes : oneLevelList) {
            String dicCode = dictionaryAndChildrenRes.getDicCode();
            List<DictionaryAndChildrenRes> levelList = twoLevelMap.get(dicCode);
            dictionaryAndChildrenRes.setChildrenRes(levelList);
        }
        return BaseResponse.success(oneLevelList);
    }
}

