/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.ebaiyihui.aggregation.payment.common.model.ProfitSharingRules;
import com.ebaiyihui.aggregation.payment.common.vo.ProfitSharingRulesReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.ReqRulesStatusVO;
import com.ebaiyihui.aggregation.payment.server.mapper.ProfitSharingRulesMapper;
import com.ebaiyihui.aggregation.payment.server.service.ProfitSharingRulesService;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProfitSharingRulesServiceImpl
implements ProfitSharingRulesService {
    private static final Logger log = LoggerFactory.getLogger(ProfitSharingRulesServiceImpl.class);
    public static final Integer status_close = -1;
    public static final Integer status_normal = 1;
    public static final Integer startType_close = 2;
    public static final Integer startType_start = 1;
    @Autowired
    private ProfitSharingRulesMapper rulesMapper;

    public BaseResponse saveRules(ProfitSharingRulesReqVO rulesReqVO) {
        List profitSharingRules = this.rulesMapper.RulesByRulesName(rulesReqVO.getRuleName(), rulesReqVO.getMainMerchant());
        if (profitSharingRules.size() > 0) {
            return BaseResponse.error((String)"\u89c4\u5219\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u65b0\u6307\u5b9a\u540d\u79f0!");
        }
        String ruleId = UUID.randomUUID().toString().replace("-", "").toUpperCase().substring(20);
        List sharingRules = rulesReqVO.packageRules(ruleId);
        int interStr = this.rulesMapper.insertList(sharingRules);
        return BaseResponse.success();
    }

    public BaseResponse updateRules(ProfitSharingRulesReqVO rulesReqVO) {
        String ruleId = rulesReqVO.getRuleId();
        List profitSharingRules = this.rulesMapper.RulesByRulesName(rulesReqVO.getRuleName(), rulesReqVO.getMainMerchant());
        if (profitSharingRules.size() > 0) {
            return BaseResponse.error((String)"\u89c4\u5219\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u65b0\u6307\u5b9a\u540d\u79f0!");
        }
        ReqRulesStatusVO rulesStatusVO = new ReqRulesStatusVO();
        rulesStatusVO.setRuleId(ruleId);
        rulesStatusVO.setStatus(status_close);
        int statesKey = this.rulesMapper.upateByStatesKey(rulesStatusVO);
        List sharingRules = rulesReqVO.packageRules(ruleId);
        int insertList = this.rulesMapper.insertList(sharingRules);
        return BaseResponse.success();
    }

    public BaseResponse deleteRules(ReqRulesStatusVO rulesStatusVO) {
        rulesStatusVO.setStatus(status_close);
        int statesKey = this.rulesMapper.upateByStatesKey(rulesStatusVO);
        return BaseResponse.success();
    }

    public BaseResponse startRules(ReqRulesStatusVO rulesStatusVO) {
        ReqRulesStatusVO closeRules = new ReqRulesStatusVO();
        closeRules.setStartType(startType_close);
        closeRules.setMainMerchant(rulesStatusVO.getMainMerchant());
        this.rulesMapper.upateByStatesKey(closeRules);
        rulesStatusVO.setStartType(rulesStatusVO.getStartType());
        this.rulesMapper.upateByStatesKey(rulesStatusVO);
        return BaseResponse.success();
    }

    public BaseResponse getStartRulesList(String mainMerchant) {
        ArrayList<ProfitSharingRulesReqVO> list = new ArrayList<ProfitSharingRulesReqVO>();
        List startRulesByMainMch = this.rulesMapper.getStartRulesByMainMch(mainMerchant);
        if (startRulesByMainMch.isEmpty()) {
            return BaseResponse.success();
        }
        List collect = startRulesByMainMch.stream().map(ProfitSharingRules::getRuleId).distinct().collect(Collectors.toList());
        for (String ruleId : collect) {
            List sharingRules = startRulesByMainMch.stream().filter(rules -> rules.getRuleId().equals(ruleId)).collect(Collectors.toList());
            ProfitSharingRulesReqVO reqVO = new ProfitSharingRulesReqVO().rulesRecombination(sharingRules);
            list.add(reqVO);
        }
        List rulesReqVOS = list.stream().sorted(Comparator.comparing(ProfitSharingRulesReqVO::getStartType)).collect(Collectors.toList());
        return BaseResponse.success(rulesReqVOS);
    }

    public BaseResponse queryStartRules(String ruleId) {
        List rulesByRuleId = this.rulesMapper.getRulesByRuleId(ruleId);
        ProfitSharingRulesReqVO reqVO = new ProfitSharingRulesReqVO().rulesRecombination(rulesByRuleId);
        return BaseResponse.success((Object)reqVO);
    }
}

