/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.transfer;

import com.alipay.api.AlipayApiException;
import com.alipay.api.domain.AlipayFundTransCommonQueryModel;
import com.alipay.api.response.AlipayFundTransCommonQueryResponse;
import com.alipay.api.response.AlipayFundTransUniTransferResponse;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.AlipayFundTransUniTransferReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayOrderQueryResp;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayOrerQueryReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayReq;
import com.ebaiyihui.aggregation.payment.common.vo.transfer.B2CPayResp;
import com.ebaiyihui.aggregation.payment.server.service.transfer.AlipayTransferApi;
import com.ebaiyihui.aggregation.payment.server.service.transfer.ITransferService;
import com.ebaiyihui.aggregation.payment.server.utils.AmountUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlipayTransferServiceImpl
implements ITransferService {
    private static final Logger log = LoggerFactory.getLogger(AlipayTransferServiceImpl.class);
    private final AlipayTransferApi alipayTransferApiImpl;

    public BaseResponse<B2CPayResp> B2Ctransfer(B2CPayReq requestVo) {
        log.info("alipay B2CTransfer method param={}", (Object)requestVo);
        AlipayFundTransUniTransferReq model = new AlipayFundTransUniTransferReq();
        model.setOut_biz_no(requestVo.getOutBizNo());
        model.setTrans_amount(AmountUtil.changeF2Y((String)String.valueOf(requestVo.getAmount())));
        model.setProduct_code("TRANS_ACCOUNT_NO_PWD");
        model.setBiz_scene("DIRECT_TRANSFER");
        AlipayFundTransUniTransferReq.Participant payee_info = new AlipayFundTransUniTransferReq.Participant();
        payee_info.setIdentity(requestVo.getToUserId());
        payee_info.setIdentity_type("ALIPAY_LOGON_ID");
        payee_info.setName(requestVo.getName());
        model.setPayee_info(payee_info);
        model.setRemark(requestVo.getRemark());
        try {
            AlipayFundTransUniTransferResponse response = this.alipayTransferApiImpl.alipayFundTransUniTransfer(model);
            if (!response.isSuccess()) {
                return BaseResponse.error((String)(response.getMsg() + " " + response.getSubMsg()));
            }
            B2CPayResp res = new B2CPayResp();
            res.setOutBizNo(response.getOutBizNo());
            res.setPaymentNo(response.getOrderId());
            res.setPaymentStatus(response.getStatus());
            res.setPaymentTime(response.getTransDate());
            return BaseResponse.success((Object)res);
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public BaseResponse<B2CPayOrderQueryResp> transferBillQuery(B2CPayOrerQueryReq vo) {
        log.info("alipay transferBillQuery method param={}", (Object)vo);
        AlipayFundTransCommonQueryModel model = new AlipayFundTransCommonQueryModel();
        model.setProductCode("TRANS_ACCOUNT_NO_PWD");
        model.setBizScene("DIRECT_TRANSFER");
        model.setOrderId(vo.getPaymentNo());
        model.setOutBizNo(vo.getOutBizNo());
        try {
            AlipayFundTransCommonQueryResponse response = this.alipayTransferApiImpl.alipayFundTransCommonQuery(model);
            if (!response.isSuccess()) {
                return BaseResponse.error((String)(response.getMsg() + " " + response.getSubMsg()));
            }
            B2CPayOrderQueryResp res = new B2CPayOrderQueryResp();
            res.setPaymentNo(response.getOrderId());
            res.setOutBizNo(response.getOutBizNo());
            res.setToUserId("");
            res.setToUserName("");
            res.setPaymentAmount(AmountUtil.changeY2F((String)response.getTransAmount()));
            res.setStatus(response.getStatus());
            res.setPaymentTime(response.getPayDate());
            res.setOrderFee(response.getOrderFee());
            res.setFailReason(response.getFailReason());
            res.setError_code(response.getErrorCode());
            res.setRemark("");
            return BaseResponse.success((Object)res);
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getErrMsg());
        }
    }

    public AlipayTransferServiceImpl(AlipayTransferApi alipayTransferApiImpl) {
        this.alipayTransferApiImpl = alipayTransferApiImpl;
    }
}

