/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.ebaiyihui.aggregation.payment.common.vo.ProfitSharingRulesReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.ReqRulesStatusVO;
import com.ebaiyihui.aggregation.payment.server.service.ProfitSharingRulesService;
import com.ebaiyihui.framework.response.BaseResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/rules"})
@RestController
public class ProfitSharingRulesController {
    private static final Logger log = LoggerFactory.getLogger(ProfitSharingRulesController.class);
    @Autowired
    private ProfitSharingRulesService rulesService;

    @PostMapping(value={"/save"})
    public BaseResponse saveRules(@RequestBody ProfitSharingRulesReqVO rulesReqVO) {
        BaseResponse baseResponse = this.rulesService.saveRules(rulesReqVO);
        return baseResponse;
    }

    @PostMapping(value={"/update"})
    public BaseResponse updateRules(@RequestBody ProfitSharingRulesReqVO rulesReqVO) {
        BaseResponse baseResponse = this.rulesService.updateRules(rulesReqVO);
        return baseResponse;
    }

    @PostMapping(value={"/delete"})
    public BaseResponse deleteRules(@RequestBody ReqRulesStatusVO rulesStatusVO) {
        BaseResponse baseResponse = this.rulesService.deleteRules(rulesStatusVO);
        return baseResponse;
    }

    @PostMapping(value={"/start"})
    public BaseResponse startRules(@RequestBody ReqRulesStatusVO rulesStatusVO) {
        BaseResponse baseResponse = this.rulesService.startRules(rulesStatusVO);
        return baseResponse;
    }

    @GetMapping(value={"/query_rules_all"})
    public BaseResponse getStartRulesList(@RequestParam(value="mainMerchant") String mainMerchant) {
        BaseResponse baseResponse = this.rulesService.getStartRulesList(mainMerchant);
        return baseResponse;
    }

    @GetMapping(value={"/query_rules"})
    public BaseResponse queryStartRules(@RequestParam(value="ruleId") String ruleId) {
        BaseResponse baseResponse = this.rulesService.queryStartRules(ruleId);
        return baseResponse;
    }
}

