/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo;

import com.ebaiyihui.aggregation.payment.common.model.ErrorBill;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.PlatformBill;
import com.ebaiyihui.aggregation.payment.server.enums.ContrastEnum;
import com.ebaiyihui.aggregation.payment.server.enums.ErrorTypeEnum;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.enums.ShowTypeEnum;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.ReconciliationRule;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.ErrorBillBO;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.bo.PlatformBillBO;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.BeanUtils;

public class PlatformBillBO {
    protected Integer status;
    private Long id;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;
    private Long billId;
    private String dealTradeNo;
    private String tradeNo;
    private BigDecimal orderAmount;
    private BigDecimal dealAmount;
    private String tradeChannel;
    private String tradeType;
    private BigDecimal refundAmount;
    private Date payTime;
    private Date refundTime;
    private String goodsInfo;
    private String mchCode;
    private String serviceCode;
    private String outRefundNo;
    private String refundNo;
    private String tradeState;
    private String contrastDate;
    private String contrastState;
    private String startTime;
    private String endTime;
    private PlatformBill platformBill = new PlatformBill();
    private ErrorBillBO errorBillBO;
    private ErrorBill errorBill;
    private ReconciliationRule reconciliationRule = new ReconciliationRule();

    public PlatformBillBO(PlatformBill platformBill) {
        BeanUtils.copyProperties((Object)platformBill, (Object)this);
    }

    public void reconciliationMissingBill(String batchNumber) {
        this.errorBillBO = ErrorBillBO.builder().batchNumber(batchNumber).errorNumber(UniqueKeyGenerator.generateViewId()).billId(this.billId).platformMchOrderNo(this.dealTradeNo).platformOrderAmount(this.orderAmount).platformPayAmount(this.dealAmount).platformPayTime(this.payTime).platformTradeNo(this.tradeNo).platformTradeState(this.tradeState).platformShouldAmount(this.dealAmount).platformTradeTime(this.refundNo == null ? this.payTime : this.refundTime).build();
        if (this.tradeState.equals("REFUND")) {
            this.errorBillBO.setErrorState(ErrorTypeEnum.INCONSISTENT_STATE.getValue());
            this.errorBillBO.setErrorType(ErrorTypeEnum.INCONSISTENT_STATE.getDisplay());
            this.errorBillBO.setShowType(ShowTypeEnum.REFUND.getValue());
        } else {
            this.errorBillBO.setErrorState(ErrorTypeEnum.INCONSISTENT_STATE.getValue());
            this.errorBillBO.setErrorType(ErrorTypeEnum.INCONSISTENT_STATE.getDisplay());
            this.errorBillBO.setShowType(ShowTypeEnum.UPDATE_STATE.getValue());
        }
        BeanUtils.copyProperties((Object)this.errorBillBO, (Object)this.errorBill);
    }

    public void init(PayBill payBill, String billDate) {
        BeanUtils.copyProperties((Object)payBill, (Object)this.platformBill);
        this.platformBill.setId(null);
        this.platformBill.setBillId(payBill.getId());
        this.platformBill.setContrastDate(billDate);
        this.platformBill.setContrastState(ContrastEnum.UN_CONTRAST.getValue());
        if (payBill.getStatus().equals(OrderStatusEnum.PAID.getValue())) {
            this.platformBill.setTradeState("SUCCESS");
        } else if (payBill.getStatus().equals(OrderStatusEnum.HAVE_A_REFUND.getValue())) {
            this.platformBill.setTradeState("REFUND");
        }
    }

    private void setReconciliationRule() {
        this.reconciliationRule.setTransactionId(this.tradeNo);
        this.reconciliationRule.setApplyCode(this.mchCode);
        this.reconciliationRule.setPayAmount(this.orderAmount);
        this.reconciliationRule.setPayType(this.tradeType);
        this.reconciliationRule.setRefundFee(this.refundAmount);
        this.reconciliationRule.setRefundId(this.refundNo);
        this.reconciliationRule.setShouldAmount(this.orderAmount);
        this.reconciliationRule.setTotalFee(this.orderAmount);
        this.reconciliationRule.setTradeState(this.tradeState);
    }

    public ReconciliationRule getReconciliationRule() {
        this.setReconciliationRule();
        return this.reconciliationRule;
    }

    public static PlatformBillBOBuilder builder() {
        return new PlatformBillBOBuilder();
    }

    public Integer getStatus() {
        return this.status;
    }

    public Long getId() {
        return this.id;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public Long getBillId() {
        return this.billId;
    }

    public String getDealTradeNo() {
        return this.dealTradeNo;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public BigDecimal getOrderAmount() {
        return this.orderAmount;
    }

    public BigDecimal getDealAmount() {
        return this.dealAmount;
    }

    public String getTradeChannel() {
        return this.tradeChannel;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public BigDecimal getRefundAmount() {
        return this.refundAmount;
    }

    public Date getPayTime() {
        return this.payTime;
    }

    public Date getRefundTime() {
        return this.refundTime;
    }

    public String getGoodsInfo() {
        return this.goodsInfo;
    }

    public String getMchCode() {
        return this.mchCode;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    public String getRefundNo() {
        return this.refundNo;
    }

    public String getTradeState() {
        return this.tradeState;
    }

    public String getContrastDate() {
        return this.contrastDate;
    }

    public String getContrastState() {
        return this.contrastState;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public PlatformBill getPlatformBill() {
        return this.platformBill;
    }

    public ErrorBillBO getErrorBillBO() {
        return this.errorBillBO;
    }

    public ErrorBill getErrorBill() {
        return this.errorBill;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public void setDealTradeNo(String dealTradeNo) {
        this.dealTradeNo = dealTradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    public void setDealAmount(BigDecimal dealAmount) {
        this.dealAmount = dealAmount;
    }

    public void setTradeChannel(String tradeChannel) {
        this.tradeChannel = tradeChannel;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public void setRefundTime(Date refundTime) {
        this.refundTime = refundTime;
    }

    public void setGoodsInfo(String goodsInfo) {
        this.goodsInfo = goodsInfo;
    }

    public void setMchCode(String mchCode) {
        this.mchCode = mchCode;
    }

    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public void setTradeState(String tradeState) {
        this.tradeState = tradeState;
    }

    public void setContrastDate(String contrastDate) {
        this.contrastDate = contrastDate;
    }

    public void setContrastState(String contrastState) {
        this.contrastState = contrastState;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setPlatformBill(PlatformBill platformBill) {
        this.platformBill = platformBill;
    }

    public void setErrorBillBO(ErrorBillBO errorBillBO) {
        this.errorBillBO = errorBillBO;
    }

    public void setErrorBill(ErrorBill errorBill) {
        this.errorBill = errorBill;
    }

    public void setReconciliationRule(ReconciliationRule reconciliationRule) {
        this.reconciliationRule = reconciliationRule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlatformBillBO)) {
            return false;
        }
        PlatformBillBO other = (PlatformBillBO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Long this$billId = this.getBillId();
        Long other$billId = other.getBillId();
        if (this$billId == null ? other$billId != null : !((Object)this$billId).equals(other$billId)) {
            return false;
        }
        String this$dealTradeNo = this.getDealTradeNo();
        String other$dealTradeNo = other.getDealTradeNo();
        if (this$dealTradeNo == null ? other$dealTradeNo != null : !this$dealTradeNo.equals(other$dealTradeNo)) {
            return false;
        }
        String this$tradeNo = this.getTradeNo();
        String other$tradeNo = other.getTradeNo();
        if (this$tradeNo == null ? other$tradeNo != null : !this$tradeNo.equals(other$tradeNo)) {
            return false;
        }
        BigDecimal this$orderAmount = this.getOrderAmount();
        BigDecimal other$orderAmount = other.getOrderAmount();
        if (this$orderAmount == null ? other$orderAmount != null : !((Object)this$orderAmount).equals(other$orderAmount)) {
            return false;
        }
        BigDecimal this$dealAmount = this.getDealAmount();
        BigDecimal other$dealAmount = other.getDealAmount();
        if (this$dealAmount == null ? other$dealAmount != null : !((Object)this$dealAmount).equals(other$dealAmount)) {
            return false;
        }
        String this$tradeChannel = this.getTradeChannel();
        String other$tradeChannel = other.getTradeChannel();
        if (this$tradeChannel == null ? other$tradeChannel != null : !this$tradeChannel.equals(other$tradeChannel)) {
            return false;
        }
        String this$tradeType = this.getTradeType();
        String other$tradeType = other.getTradeType();
        if (this$tradeType == null ? other$tradeType != null : !this$tradeType.equals(other$tradeType)) {
            return false;
        }
        BigDecimal this$refundAmount = this.getRefundAmount();
        BigDecimal other$refundAmount = other.getRefundAmount();
        if (this$refundAmount == null ? other$refundAmount != null : !((Object)this$refundAmount).equals(other$refundAmount)) {
            return false;
        }
        Date this$payTime = this.getPayTime();
        Date other$payTime = other.getPayTime();
        if (this$payTime == null ? other$payTime != null : !((Object)this$payTime).equals(other$payTime)) {
            return false;
        }
        Date this$refundTime = this.getRefundTime();
        Date other$refundTime = other.getRefundTime();
        if (this$refundTime == null ? other$refundTime != null : !((Object)this$refundTime).equals(other$refundTime)) {
            return false;
        }
        String this$goodsInfo = this.getGoodsInfo();
        String other$goodsInfo = other.getGoodsInfo();
        if (this$goodsInfo == null ? other$goodsInfo != null : !this$goodsInfo.equals(other$goodsInfo)) {
            return false;
        }
        String this$mchCode = this.getMchCode();
        String other$mchCode = other.getMchCode();
        if (this$mchCode == null ? other$mchCode != null : !this$mchCode.equals(other$mchCode)) {
            return false;
        }
        String this$serviceCode = this.getServiceCode();
        String other$serviceCode = other.getServiceCode();
        if (this$serviceCode == null ? other$serviceCode != null : !this$serviceCode.equals(other$serviceCode)) {
            return false;
        }
        String this$outRefundNo = this.getOutRefundNo();
        String other$outRefundNo = other.getOutRefundNo();
        if (this$outRefundNo == null ? other$outRefundNo != null : !this$outRefundNo.equals(other$outRefundNo)) {
            return false;
        }
        String this$refundNo = this.getRefundNo();
        String other$refundNo = other.getRefundNo();
        if (this$refundNo == null ? other$refundNo != null : !this$refundNo.equals(other$refundNo)) {
            return false;
        }
        String this$tradeState = this.getTradeState();
        String other$tradeState = other.getTradeState();
        if (this$tradeState == null ? other$tradeState != null : !this$tradeState.equals(other$tradeState)) {
            return false;
        }
        String this$contrastDate = this.getContrastDate();
        String other$contrastDate = other.getContrastDate();
        if (this$contrastDate == null ? other$contrastDate != null : !this$contrastDate.equals(other$contrastDate)) {
            return false;
        }
        String this$contrastState = this.getContrastState();
        String other$contrastState = other.getContrastState();
        if (this$contrastState == null ? other$contrastState != null : !this$contrastState.equals(other$contrastState)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        PlatformBill this$platformBill = this.getPlatformBill();
        PlatformBill other$platformBill = other.getPlatformBill();
        if (this$platformBill == null ? other$platformBill != null : !this$platformBill.equals(other$platformBill)) {
            return false;
        }
        ErrorBillBO this$errorBillBO = this.getErrorBillBO();
        ErrorBillBO other$errorBillBO = other.getErrorBillBO();
        if (this$errorBillBO == null ? other$errorBillBO != null : !this$errorBillBO.equals(other$errorBillBO)) {
            return false;
        }
        ErrorBill this$errorBill = this.getErrorBill();
        ErrorBill other$errorBill = other.getErrorBill();
        if (this$errorBill == null ? other$errorBill != null : !this$errorBill.equals(other$errorBill)) {
            return false;
        }
        ReconciliationRule this$reconciliationRule = this.getReconciliationRule();
        ReconciliationRule other$reconciliationRule = other.getReconciliationRule();
        return !(this$reconciliationRule == null ? other$reconciliationRule != null : !this$reconciliationRule.equals(other$reconciliationRule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlatformBillBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Long $billId = this.getBillId();
        result = result * 59 + ($billId == null ? 43 : ((Object)$billId).hashCode());
        String $dealTradeNo = this.getDealTradeNo();
        result = result * 59 + ($dealTradeNo == null ? 43 : $dealTradeNo.hashCode());
        String $tradeNo = this.getTradeNo();
        result = result * 59 + ($tradeNo == null ? 43 : $tradeNo.hashCode());
        BigDecimal $orderAmount = this.getOrderAmount();
        result = result * 59 + ($orderAmount == null ? 43 : ((Object)$orderAmount).hashCode());
        BigDecimal $dealAmount = this.getDealAmount();
        result = result * 59 + ($dealAmount == null ? 43 : ((Object)$dealAmount).hashCode());
        String $tradeChannel = this.getTradeChannel();
        result = result * 59 + ($tradeChannel == null ? 43 : $tradeChannel.hashCode());
        String $tradeType = this.getTradeType();
        result = result * 59 + ($tradeType == null ? 43 : $tradeType.hashCode());
        BigDecimal $refundAmount = this.getRefundAmount();
        result = result * 59 + ($refundAmount == null ? 43 : ((Object)$refundAmount).hashCode());
        Date $payTime = this.getPayTime();
        result = result * 59 + ($payTime == null ? 43 : ((Object)$payTime).hashCode());
        Date $refundTime = this.getRefundTime();
        result = result * 59 + ($refundTime == null ? 43 : ((Object)$refundTime).hashCode());
        String $goodsInfo = this.getGoodsInfo();
        result = result * 59 + ($goodsInfo == null ? 43 : $goodsInfo.hashCode());
        String $mchCode = this.getMchCode();
        result = result * 59 + ($mchCode == null ? 43 : $mchCode.hashCode());
        String $serviceCode = this.getServiceCode();
        result = result * 59 + ($serviceCode == null ? 43 : $serviceCode.hashCode());
        String $outRefundNo = this.getOutRefundNo();
        result = result * 59 + ($outRefundNo == null ? 43 : $outRefundNo.hashCode());
        String $refundNo = this.getRefundNo();
        result = result * 59 + ($refundNo == null ? 43 : $refundNo.hashCode());
        String $tradeState = this.getTradeState();
        result = result * 59 + ($tradeState == null ? 43 : $tradeState.hashCode());
        String $contrastDate = this.getContrastDate();
        result = result * 59 + ($contrastDate == null ? 43 : $contrastDate.hashCode());
        String $contrastState = this.getContrastState();
        result = result * 59 + ($contrastState == null ? 43 : $contrastState.hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        PlatformBill $platformBill = this.getPlatformBill();
        result = result * 59 + ($platformBill == null ? 43 : $platformBill.hashCode());
        ErrorBillBO $errorBillBO = this.getErrorBillBO();
        result = result * 59 + ($errorBillBO == null ? 43 : $errorBillBO.hashCode());
        ErrorBill $errorBill = this.getErrorBill();
        result = result * 59 + ($errorBill == null ? 43 : $errorBill.hashCode());
        ReconciliationRule $reconciliationRule = this.getReconciliationRule();
        result = result * 59 + ($reconciliationRule == null ? 43 : $reconciliationRule.hashCode());
        return result;
    }

    public String toString() {
        return "PlatformBillBO(status=" + this.getStatus() + ", id=" + this.getId() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", billId=" + this.getBillId() + ", dealTradeNo=" + this.getDealTradeNo() + ", tradeNo=" + this.getTradeNo() + ", orderAmount=" + this.getOrderAmount() + ", dealAmount=" + this.getDealAmount() + ", tradeChannel=" + this.getTradeChannel() + ", tradeType=" + this.getTradeType() + ", refundAmount=" + this.getRefundAmount() + ", payTime=" + this.getPayTime() + ", refundTime=" + this.getRefundTime() + ", goodsInfo=" + this.getGoodsInfo() + ", mchCode=" + this.getMchCode() + ", serviceCode=" + this.getServiceCode() + ", outRefundNo=" + this.getOutRefundNo() + ", refundNo=" + this.getRefundNo() + ", tradeState=" + this.getTradeState() + ", contrastDate=" + this.getContrastDate() + ", contrastState=" + this.getContrastState() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", platformBill=" + this.getPlatformBill() + ", errorBillBO=" + this.getErrorBillBO() + ", errorBill=" + this.getErrorBill() + ", reconciliationRule=" + this.getReconciliationRule() + ")";
    }

    public PlatformBillBO() {
    }

    public PlatformBillBO(Integer status, Long id, Date createTime, Date updateTime, Long billId, String dealTradeNo, String tradeNo, BigDecimal orderAmount, BigDecimal dealAmount, String tradeChannel, String tradeType, BigDecimal refundAmount, Date payTime, Date refundTime, String goodsInfo, String mchCode, String serviceCode, String outRefundNo, String refundNo, String tradeState, String contrastDate, String contrastState, String startTime, String endTime, PlatformBill platformBill, ErrorBillBO errorBillBO, ErrorBill errorBill, ReconciliationRule reconciliationRule) {
        this.status = status;
        this.id = id;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.billId = billId;
        this.dealTradeNo = dealTradeNo;
        this.tradeNo = tradeNo;
        this.orderAmount = orderAmount;
        this.dealAmount = dealAmount;
        this.tradeChannel = tradeChannel;
        this.tradeType = tradeType;
        this.refundAmount = refundAmount;
        this.payTime = payTime;
        this.refundTime = refundTime;
        this.goodsInfo = goodsInfo;
        this.mchCode = mchCode;
        this.serviceCode = serviceCode;
        this.outRefundNo = outRefundNo;
        this.refundNo = refundNo;
        this.tradeState = tradeState;
        this.contrastDate = contrastDate;
        this.contrastState = contrastState;
        this.startTime = startTime;
        this.endTime = endTime;
        this.platformBill = platformBill;
        this.errorBillBO = errorBillBO;
        this.errorBill = errorBill;
        this.reconciliationRule = reconciliationRule;
    }
}

