/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.vo.ResponseNotifyRestVo;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.service.PayApplyService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.service.mybank.AddOrderService;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import com.ebaiyihui.aggregation.payment.server.utils.HttpsClientUtil;
import com.ebaiyihui.aggregation.payment.server.utils.SignUtil;
import com.ebaiyihui.aggregation.payment.server.utils.UUIDUtil;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import com.ebaiyihui.framework.response.BaseResponse;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/test"})
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Resource
    private PayBillService payBillService;
    @Resource
    private PayApplyService payApplyService;
    @Resource
    private AddOrderService addOrderService;

    @GetMapping(value={"/call_back"})
    public BaseResponse<String> callBack(@RequestParam(name="outTradeNo") String outTradeNo) {
        PayBill payBill = this.payBillService.getByOutTradeNo(outTradeNo);
        ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
        responseNotifyRestVo.setTradeNo(UUIDUtil.getUUID());
        responseNotifyRestVo.setReturnCode("SUCCESS");
        responseNotifyRestVo.setReturnMsg("SUCCESS");
        responseNotifyRestVo.setResultCode("SUCCESS");
        responseNotifyRestVo.setErrCode("SUCCESS");
        responseNotifyRestVo.setErrCodeDes("SUCCESS");
        responseNotifyRestVo.setPayChannel(payBill.getTradeChannel());
        responseNotifyRestVo.setServiceCode(payBill.getServiceCode());
        responseNotifyRestVo.setOutTradeNo(payBill.getOutTradeNo());
        responseNotifyRestVo.setDealTradeNo(payBill.getDealTradeNo());
        responseNotifyRestVo.setTotalAmount(payBill.getDealAmount());
        if (null != payBill.getAttach() && !"".equals(payBill.getAttach().trim())) {
            responseNotifyRestVo.setAttach(payBill.getAttach());
        }
        if (null != payBill.getRemake() && !"".equals(payBill.getRemake().trim())) {
            responseNotifyRestVo.setRemake(payBill.getRemake());
        }
        responseNotifyRestVo.setMchCode(payBill.getMchCode());
        responseNotifyRestVo.setMchId("aaaa");
        responseNotifyRestVo.setMchName("aaaa");
        String payTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        Date date = DateUtils.stringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)payTime);
        responseNotifyRestVo.setPayTime(date);
        responseNotifyRestVo.setNotifyResultStr("bbb");
        PayApply payApply = this.payApplyService.getByApplyCode(payBill.getMchCode());
        responseNotifyRestVo.setApplyId(payApply.getApplyId());
        Map signMap = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
        String sign = SignUtil.createSign((Map)signMap, (String)payApply.getApplyKey(), (String[])new String[0]);
        responseNotifyRestVo.setSign(sign);
        String param = JSONObject.toJSONString((Object)responseNotifyRestVo);
        log.info("\u4e34\u65f6\u6d4b\u8bd5\u652f\u4ed8\u56de\u8c03\u4e1a\u52a1\u670d\u52a1\uff1a{}", (Object)param);
        JSONObject result = HttpsClientUtil.doPostForJson((String)payBill.getPayNotifyUrl(), (String)param);
        log.info("\u4e34\u65f6\u6d4b\u8bd5\u4e1a\u52a1\u670d\u52a1\u56de\u8c03\u8fd4\u56de\u7ed3\u679c\uff1aJSONObject{}", (Object)result);
        payBill.setTradeNo(UniqueKeyGenerator.generateViewId());
        payBill.setStatus(OrderStatusEnum.PAID.getValue());
        payBill.setPayTime(date);
        payBill.setTradeChannel("WECHAT");
        this.payBillService.update(payBill);
        this.addOrderService.saveAddOrder(responseNotifyRestVo.getOutTradeNo());
        return BaseResponse.success();
    }
}

