/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.controller.notify;

import com.ebaiyihui.aggregation.payment.server.service.NotifyService;
import com.ebaiyihui.aggregation.payment.server.service.notify.INotify;
import com.ebaiyihui.aggregation.payment.server.service.notify.NotifyFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notify"})
@Api(tags={"\u5f02\u6b65\u901a\u77e5\u63a5\u53e3"})
public class NotifyController {
    private static final Logger log = LoggerFactory.getLogger(NotifyController.class);
    @Autowired
    private NotifyService notifyService;

    @ApiOperation(value="\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03")
    @RequestMapping(value={"/wechat"}, method={RequestMethod.GET, RequestMethod.POST})
    public String weChatNotify(HttpServletRequest request) {
        return this.notifyService.weChatPayNotify(request);
    }

    @ApiOperation(value="\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03")
    @RequestMapping(value={"/wechatRefund"}, method={RequestMethod.GET, RequestMethod.POST})
    public String weChatRefundNotify(HttpServletRequest request) {
        return this.notifyService.weChatRefundNotify(request);
    }

    @ApiOperation(value="\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03")
    @RequestMapping(value={"/alipay"})
    public String alipayNotify(HttpServletRequest request) {
        return this.notifyService.aliPayNotify(request);
    }

    @ApiOperation(value="\u652f\u4ed8\u5b9d\u9000\u6b3e\u56de\u8c03")
    @RequestMapping(value={"/alipayRefund"}, method={RequestMethod.GET, RequestMethod.POST})
    public String alipayRefundNotify(HttpServletRequest request) {
        return this.notifyService.aliRefundNotify(request);
    }

    @ApiOperation(value="\u94f6\u8054\u652f\u4ed8/\u9000\u6b3e\u56de\u8c03")
    @RequestMapping(value={"/unionPayBackNotify"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseEntity<Object> unionPayBackNotify(HttpServletRequest req) {
        return this.notifyService.unionPayBackNotify(req);
    }

    @RequestMapping(value={"/{path}"}, method={RequestMethod.GET, RequestMethod.POST})
    public String notify(HttpServletRequest req, @PathVariable String path) {
        INotify iNotify = NotifyFactory.getNotifyType((String)path);
        return iNotify.notify(req);
    }
}

