/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.mybank.event;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.aggregation.payment.common.model.PayIsvThird;
import com.ebaiyihui.aggregation.payment.common.model.SharingRecord;
import com.ebaiyihui.aggregation.payment.server.mapper.SharingRecordMapper;
import com.ebaiyihui.aggregation.payment.server.mybank.DefaultMybankClient;
import com.ebaiyihui.aggregation.payment.server.mybank.MybankClient;
import com.ebaiyihui.aggregation.payment.server.mybank.bo.SharingProcessBO;
import com.ebaiyihui.aggregation.payment.server.mybank.business.MybankProfitSharing;
import com.ebaiyihui.aggregation.payment.server.mybank.config.MybankConfig;
import com.ebaiyihui.aggregation.payment.server.mybank.event.SharingNotifyEvent;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class SharingNotifyListener {
    private static final Logger log = LoggerFactory.getLogger(SharingNotifyListener.class);
    @Resource
    private SharingRecordMapper sharingRecordMapper;
    @Resource
    private MybankProfitSharing mybankProfitSharing;
    @Resource
    private RedisTemplate redisTemplate;

    @EventListener(condition="#sharingNotifyEvent.sharing.status == 1")
    public void processSharingNotifyEvent(SharingNotifyEvent sharingNotifyEvent) {
        log.info("\u5206\u8d26\u56de\u8c03\u6536\u5230\u6d88\u606f,\u5206\u8d26\u5355\u53f7:{}", (Object)sharingNotifyEvent.getSharing().getOutTradeNo());
        String outTradeNo = sharingNotifyEvent.getSharing().getOutTradeNo();
        SharingRecord sharingRecord = this.sharingRecordMapper.selectOneByOutTradeNo(outTradeNo);
        if (sharingRecord == null) {
            log.info("this outTradeNo don't have record!");
            return;
        }
        String value = this.redisTemplate.opsForHash().get((Object)outTradeNo, (Object)sharingRecord.getShareTradeNo()).toString();
        log.info("wait sharing record:{}", (Object)value);
        try {
            SharingProcessBO sharingProcessBO = (SharingProcessBO)JSONObject.parseObject((String)value, SharingProcessBO.class);
            PayIsvThird payIsvThird = sharingProcessBO.getMyBankSharingBO().getPayIsvThird();
            DefaultMybankClient mybankClient = new DefaultMybankClient(MybankConfig.serverUrl, payIsvThird.getPrivateKey(), payIsvThird.getPublicKey());
            sharingProcessBO.getMyBankSharingBO().setMybankClient((MybankClient)mybankClient);
            this.mybankProfitSharing.sendRequestForSharing(sharingProcessBO.getPayNum(), sharingProcessBO.getMyBankSharingBO());
        }
        catch (Exception e) {
            log.error("auto sharing error,e=", (Throwable)e);
        }
    }

    @EventListener(condition="#sharingNotifyEvent.sharing.status == 2")
    public void processRefundNotifyEvent(SharingNotifyEvent sharingNotifyEvent) {
        String outTradeNo = sharingNotifyEvent.getSharing().getOutTradeNo();
        log.info("\u5206\u8d26\u9000\u56de\u56de\u8c03\u6536\u5230\u6d88\u606f,\u5206\u8d26\u5355\u53f7:{}", (Object)outTradeNo);
    }
}

