/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.CertAlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayFundTransUniTransferModel;
import com.alipay.api.domain.AlipayTradeOrderSettleModel;
import com.alipay.api.domain.AlipayTradeRoyaltyRelationBatchqueryModel;
import com.alipay.api.domain.AlipayTradeRoyaltyRelationBindModel;
import com.alipay.api.domain.AlipayTradeRoyaltyRelationUnbindModel;
import com.alipay.api.domain.RoyaltyEntity;
import com.alipay.api.request.AlipayFundTransUniTransferRequest;
import com.alipay.api.request.AlipayTradeOrderSettleRequest;
import com.alipay.api.request.AlipayTradeRoyaltyRelationBatchqueryRequest;
import com.alipay.api.request.AlipayTradeRoyaltyRelationBindRequest;
import com.alipay.api.request.AlipayTradeRoyaltyRelationUnbindRequest;
import com.alipay.api.response.AlipayFundTransUniTransferResponse;
import com.alipay.api.response.AlipayTradeOrderSettleResponse;
import com.alipay.api.response.AlipayTradeRoyaltyRelationBatchqueryResponse;
import com.alipay.api.response.AlipayTradeRoyaltyRelationBindResponse;
import com.alipay.api.response.AlipayTradeRoyaltyRelationUnbindResponse;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.ProfitSharingRecord;
import com.ebaiyihui.aggregation.payment.server.enums.ProfitSharingEnums;
import com.ebaiyihui.aggregation.payment.server.service.AliPayProfitSharingService;
import com.ebaiyihui.aggregation.payment.server.service.BaseService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliPayProfitSharingServiceImpl
extends BaseService
implements AliPayProfitSharingService {
    private static final Logger log = LoggerFactory.getLogger(AliPayProfitSharingServiceImpl.class);

    public BaseResponse<String> createProfitSharingBill(AlipayTradeOrderSettleModel reqVo) throws AlipayApiException {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", this.appid, this.privateKey, "json", "UTF-8", this.publicKey, "RSA2");
        ProfitSharingRecord profitSharingRecord = new ProfitSharingRecord();
        AlipayTradeOrderSettleRequest alipayRequest = new AlipayTradeOrderSettleRequest();
        alipayRequest.setBizModel((AlipayObject)reqVo);
        alipayRequest.putOtherTextParam("app_auth_token", this.appAuthToken);
        profitSharingRecord.setProfitSharingType(ProfitSharingEnums.ProfitSharingTypeEnum.ALIPAY_PROFIT_SHARING.getProfitSharingTypeId());
        profitSharingRecord.setOutTradeNo(reqVo.getOutRequestNo());
        profitSharingRecord.setProfitSharingOperatingData(JSONObject.toJSONString((Object)alipayRequest));
        profitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_DEFAULT.getProfitSharingStatusCode());
        this.profitSharingRecordMapper.insert((Object)profitSharingRecord);
        AlipayTradeOrderSettleResponse response = (AlipayTradeOrderSettleResponse)alipayClient.execute((AlipayRequest)alipayRequest);
        if (response.isSuccess()) {
            String tradeNo = response.getTradeNo();
            log.info("\u8c03\u7528\u6210\u529f,\u5206\u8d26\u8ba2\u5355\u53f7\u4e3a:{}", (Object)tradeNo);
            this.profitSharingRecordAssembly(profitSharingRecord, response);
            return BaseResponse.success((Object)tradeNo);
        }
        log.info("\u8c03\u7528\u5931\u8d25\u5206\u8d26\u5931\u8d25");
        this.profitSharingRecordAssembly(profitSharingRecord, response);
        return BaseResponse.error((String)response.getSubMsg());
    }

    public void profitSharingRecordAssembly(ProfitSharingRecord profitSharingRecord, AlipayTradeOrderSettleResponse response) {
        if (response.isSuccess()) {
            profitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_PROCESSING.getProfitSharingStatusCode());
            profitSharingRecord.setProfitSharingResultMsg(StringUtils.isBlank((CharSequence)response.getMsg()) ? response.getSubMsg() : response.getMsg());
        } else {
            profitSharingRecord.setProfitSharingResultStatus(ProfitSharingEnums.ProfitSharingResultStatusCodeEnum.PROFIT_SHARING_FAILURE.getProfitSharingStatusCode());
            profitSharingRecord.setProfitSharingResultMsg(response.getSubMsg());
            profitSharingRecord.setProfitSharingErrorCode(response.getSubCode());
        }
        log.info(JSONObject.toJSONString((Object)profitSharingRecord));
        ProfitSharingRecord updateProfitSharingRecord = new ProfitSharingRecord();
        updateProfitSharingRecord.setId(profitSharingRecord.getId());
        QueryWrapper queryWrapper = new QueryWrapper((Object)updateProfitSharingRecord);
        this.profitSharingRecordMapper.update((Object)profitSharingRecord, (Wrapper)queryWrapper);
    }

    public BaseResponse<String> addIncomeSide(AlipayTradeRoyaltyRelationBindModel model) {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", this.appid, this.privateKey, "json", "UTF-8", this.publicKey, "RSA2");
        AlipayTradeRoyaltyRelationBindRequest alipayRequest = new AlipayTradeRoyaltyRelationBindRequest();
        alipayRequest.setBizModel((AlipayObject)model);
        alipayRequest.putOtherTextParam("app_auth_token", this.appAuthToken);
        try {
            AlipayTradeRoyaltyRelationBindResponse response = (AlipayTradeRoyaltyRelationBindResponse)alipayClient.execute((AlipayRequest)alipayRequest);
            if (response.isSuccess()) {
                String resultCode = response.getResultCode();
                log.info("-----\u6dfb\u52a0-----\u5206\u8d26\u65b9\u6210\u529f,\u8fd4\u56de\u72b6\u6001code:{}", (Object)response);
                return BaseResponse.success((Object)resultCode);
            }
            log.info("-----\u6dfb\u52a0-----\u5206\u8d26\u65b9\u5931\u8d25");
        }
        catch (AlipayApiException e) {
            log.error("-----\u6dfb\u52a0-----\u5206\u8d26\u65b9\u5931\u8d25!\u539f\u56e0:{},\u5f02\u5e38:{}", (Object)e.getErrMsg(), (Object)e);
            return BaseResponse.error((String)("-----\u6dfb\u52a0-----\u5206\u8d26\u65b9\u5931\u8d25" + e.getErrMsg()));
        }
        return null;
    }

    public BaseResponse<String> removeIncomeSide(AlipayTradeRoyaltyRelationUnbindModel reqVo) {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", this.appid, this.privateKey, "json", "UTF-8", this.publicKey, "RSA2");
        AlipayTradeRoyaltyRelationUnbindRequest alipayRequest = new AlipayTradeRoyaltyRelationUnbindRequest();
        alipayRequest.setBizModel((AlipayObject)reqVo);
        alipayRequest.putOtherTextParam("app_auth_token", this.appAuthToken);
        try {
            AlipayTradeRoyaltyRelationUnbindResponse response = (AlipayTradeRoyaltyRelationUnbindResponse)alipayClient.execute((AlipayRequest)alipayRequest);
            if (response.isSuccess()) {
                String resultCode = response.getResultCode();
                log.info("-----\u89e3\u9664-----\u5206\u8d26\u65b9\u6210\u529f,\u8fd4\u56de\u53c2\u6570:{}", (Object)response.toString());
                return BaseResponse.success((Object)resultCode);
            }
            log.info("-----\u89e3\u9664-----\u5206\u8d26\u65b9\u6210\u529f");
        }
        catch (AlipayApiException e) {
            log.error("-----\u89e3\u9664-----\u5206\u8d26\u65b9\u6210\u529f!\u539f\u56e0:{},\u5f02\u5e38:{}", (Object)e.getErrMsg(), (Object)e);
            return BaseResponse.error((String)("=-----\u89e3\u9664-----\u5206\u8d26\u65b9\u5931\u8d25" + e.getErrMsg()));
        }
        return null;
    }

    public BaseResponse<PageResult<List<RoyaltyEntity>>> queryIncomeSide(AlipayTradeRoyaltyRelationBatchqueryModel reqVo) {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient("https://openapi.alipay.com/gateway.do", this.appid, this.privateKey, "json", "UTF-8", this.publicKey, "RSA2");
        AlipayTradeRoyaltyRelationBatchqueryRequest alipayRequest = new AlipayTradeRoyaltyRelationBatchqueryRequest();
        alipayRequest.setBizModel((AlipayObject)reqVo);
        alipayRequest.putOtherTextParam("app_auth_token", this.appAuthToken);
        try {
            AlipayTradeRoyaltyRelationBatchqueryResponse response = (AlipayTradeRoyaltyRelationBatchqueryResponse)alipayClient.execute((AlipayRequest)alipayRequest);
            if (response.isSuccess()) {
                log.info("-----\u67e5\u8be2-----\u5206\u8d26\u65b9\u6210\u529f,\u8fd4\u56de\u53c2\u6570:{}", (Object)response.toString());
                List receiverList = response.getReceiverList();
                PageResult result = new PageResult();
                result.setContent(receiverList);
                result.setPageNum(Math.toIntExact(response.getCurrentPageNum()));
                result.setPageSize(Math.toIntExact(response.getCurrentPageSize()));
                result.setTotal(Math.toIntExact(response.getTotalRecordNum()));
                result.setTotalPages(Math.toIntExact(response.getTotalPageNum()));
                return BaseResponse.success((Object)result);
            }
            log.info("-----\u67e5\u8be2-----\u5206\u8d26\u65b9\u5931\u8d25");
        }
        catch (AlipayApiException e) {
            log.error("-----\u67e5\u8be2-----\u5206\u8d26\u65b9\u5931\u8d25!\u539f\u56e0:{},\u5f02\u5e38:{}", (Object)e.getErrMsg(), (Object)e);
            return BaseResponse.error((String)("-----\u67e5\u8be2-----\u5206\u8d26\u65b9\u5931\u8d25" + e.getErrMsg()));
        }
        return null;
    }

    public BaseResponse alipayFundTransUniTransfer(AlipayFundTransUniTransferModel model) throws AlipayApiException {
        CertAlipayRequest certAlipayRequest = new CertAlipayRequest();
        certAlipayRequest.setServerUrl("https://openapi.alipay.com/gateway.do");
        certAlipayRequest.setAppId(this.appid);
        certAlipayRequest.setPrivateKey(this.privateKey);
        certAlipayRequest.setFormat("json");
        certAlipayRequest.setCharset("UTF-8");
        certAlipayRequest.setSignType("RSA2");
        certAlipayRequest.setCertPath("/Users/mac/Desktop/alipay/appCertPublicKey_2021001165694444.crt");
        certAlipayRequest.setAlipayPublicCertPath("/Users/mac/Desktop/alipay/alipayCertPublicKey_RSA2.crt");
        certAlipayRequest.setRootCertPath("/Users/mac/Desktop/alipay/alipayRootCert.crt");
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(certAlipayRequest);
        AlipayFundTransUniTransferRequest request = new AlipayFundTransUniTransferRequest();
        String outTradeNo = System.currentTimeMillis() + "";
        request.setBizContent("{\"out_biz_no\":\"" + outTradeNo + "\",\"trans_amount\":0.1,\"product_code\":\"TRANS_ACCOUNT_NO_PWD\",\"biz_scene\":\"DIRECT_TRANSFER\",\"order_title\":\"\u8f6c\u8d26\u6807\u9898\",\"payee_info\":{\"identity\":\"15510002724\",\"identity_type\":\"ALIPAY_LOGON_ID\",\"name\":\"\u97e9\u6653\u4f1f\"    },\"remark\":\"\u5355\u7b14\u8f6c\u8d26\",  }");
        AlipayFundTransUniTransferResponse response = (AlipayFundTransUniTransferResponse)alipayClient.certificateExecute((AlipayRequest)request);
        log.info(response.toString());
        if (response.isSuccess()) {
            System.out.println("\u8c03\u7528\u6210\u529f");
            return BaseResponse.success((Object)response);
        }
        System.out.println("\u8c03\u7528\u5931\u8d25");
        return BaseResponse.success((Object)"\u8c03\u7528\u5931\u8d25");
    }
}

