/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.aggregation.payment.common.model.OfflinePayConfig;
import com.ebaiyihui.aggregation.payment.common.model.PayChan;
import com.ebaiyihui.aggregation.payment.common.payparam.WxPayParam;
import com.ebaiyihui.aggregation.payment.server.mapper.OfflinePayConfigMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayChanMapper;
import com.ebaiyihui.aggregation.payment.server.service.OfflinePayConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfflinePayConfigServiceImpl
implements OfflinePayConfigService {
    private static final Logger log = LoggerFactory.getLogger(OfflinePayConfigServiceImpl.class);
    @Autowired
    private OfflinePayConfigMapper offlinePayConfigMapper;
    @Autowired
    private PayChanMapper payChanMapper;

    public WxPayParam getOfflinePayConfigByCodeAndChanId(String mchCode, String chanCode, String serviceCode) {
        PayChan tempPayChan = this.getPayChanCode(chanCode);
        OfflinePayConfig payConfig = new OfflinePayConfig();
        payConfig.setCode(mchCode);
        payConfig.setChanId(tempPayChan.getId());
        payConfig.setServiceCode(serviceCode);
        QueryWrapper Wrapper2 = new QueryWrapper((Object)payConfig);
        Wrapper2.last("limit 1");
        OfflinePayConfig offlinePayConfig = (OfflinePayConfig)this.offlinePayConfigMapper.selectOne((Wrapper)Wrapper2);
        if (null == offlinePayConfig) {
            return null;
        }
        WxPayParam wxPayParam = (WxPayParam)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)offlinePayConfig.getParam()), WxPayParam.class);
        return wxPayParam;
    }

    private PayChan getPayChanCode(String chanCode) {
        PayChan wrapperpayChan = new PayChan();
        wrapperpayChan.setCode(chanCode);
        wrapperpayChan.setStatus(Integer.valueOf(1));
        QueryWrapper payChanWrapper = new QueryWrapper((Object)wrapperpayChan);
        payChanWrapper.last("limit 1");
        PayChan payChan = (PayChan)this.payChanMapper.selectOne((Wrapper)payChanWrapper);
        return payChan;
    }
}

