/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.ebaiyihui.aggregation.payment.common.model.PayApply;
import com.ebaiyihui.aggregation.payment.common.model.PayMch;
import com.ebaiyihui.aggregation.payment.common.vo.PayApplyReqVO;
import com.ebaiyihui.aggregation.payment.common.vo.PayApplysReqVO;
import com.ebaiyihui.aggregation.payment.server.enums.ApplyChannelEnum;
import com.ebaiyihui.aggregation.payment.server.enums.ApplyStatusEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.PayApplyMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchAppLinkMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchMapper;
import com.ebaiyihui.aggregation.payment.server.service.MchChanService;
import com.ebaiyihui.aggregation.payment.server.service.PayApplyService;
import com.ebaiyihui.aggregation.payment.server.utils.Md5Utils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayApplyServiceImpl
implements PayApplyService {
    private static final Logger log = LoggerFactory.getLogger(PayApplyServiceImpl.class);
    @Autowired
    private PayApplyMapper payAppplyMapper;
    @Autowired
    private PayMchMapper payMchMapper;
    @Resource
    private PayMchAppLinkMapper payMchAppLinkMapper;
    @Autowired
    private MchChanService mchChanService;
    private static final String defaultCode = "defaultMch";
    private static final String defaultApplyType = "ZWBY";
    private static final Integer mchChan = 1;
    private static final String remark = "\u7ed9\u6ce8\u518c\u7528\u6237\u9ed8\u8ba4\u521b\u5efa\u5546\u6237";
    private static final String rname = "\u652f\u4ed8\u4e2d\u53f0";

    public BaseResponse<List<PayApplysReqVO>> getAppliListCompanyId(Long companyId) {
        List payApplies = this.payAppplyMapper.selectPayApplyByCompanyId(companyId);
        ArrayList<PayApplysReqVO> reqVOList = new ArrayList<PayApplysReqVO>();
        for (PayApply payApply : payApplies) {
            PayApplysReqVO payApplysReqVO = new PayApplysReqVO();
            BeanUtils.copyProperties((Object)payApply, (Object)payApplysReqVO);
            List mchChanByApply = this.mchChanService.getMchChanByApply(payApply.getApplyCode());
            if (mchChanByApply != null) {
                payApplysReqVO.setMchChanNumber(mchChanByApply.size());
            } else {
                payApplysReqVO.setMchChanNumber(mchChan.intValue());
            }
            reqVOList.add(payApplysReqVO);
        }
        return BaseResponse.success(reqVOList);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<PayApply> addPayApply(PayApplyReqVO payApplyReqVO) {
        PayApply payApply = new PayApply();
        BeanUtils.copyProperties((Object)payApplyReqVO, (Object)payApply);
        payApply.setStatus(ApplyStatusEnum.STATUS_VALID.getValue());
        String encodeByMd5 = Md5Utils.encodeByMD5((String)(payApplyReqVO.getApplyCode() + System.currentTimeMillis()));
        payApply.setApplyId(encodeByMd5);
        payApply.setApplyKey(Md5Utils.encodeByMD5((String)encodeByMd5));
        this.payAppplyMapper.insertSelectiveCourse(payApply);
        if (!ApplyChannelEnum.ZWBY.getApplyChannel().equals(payApplyReqVO.getApplyType())) {
            return BaseResponse.success((Object)payApply);
        }
        PayMch payMch = new PayMch();
        payMch.setName(payApplyReqVO.getApplyName());
        payMch.setCode(payApplyReqVO.getApplyCode());
        payMch.setApplyCode(payApplyReqVO.getApplyCode());
        payMch.setRemark(remark);
        payMch.setStatus(ApplyStatusEnum.STATUS_VALID.getValue());
        this.payMchMapper.insert((Object)payMch);
        return BaseResponse.success((Object)payApply);
    }

    public BaseResponse<Object> updatePayApply(PayApply payApply) {
        this.payAppplyMapper.updateByPrimaryKeySelective(payApply);
        return BaseResponse.success();
    }

    public BaseResponse<Object> createMd5(Long id) {
        PayApply payApply = this.payAppplyMapper.queryObject(id);
        if (payApply == null) {
            return BaseResponse.error((String)"\u5e94\u7528\u4fe1\u606f\u9519\u8bef!");
        }
        long millis = System.currentTimeMillis();
        String originString = payApply.getApplyId() + rname + millis;
        String encodeByMD5 = Md5Utils.encodeByMD5((String)originString);
        payApply.setApplyKey(encodeByMD5);
        this.payAppplyMapper.updateByPrimaryKeySelective(payApply);
        return BaseResponse.success((Object)encodeByMD5);
    }

    public BaseResponse<Object> getPayApply(Long id) {
        PayApply payApply = this.payAppplyMapper.queryObject(id);
        if (payApply == null) {
            return BaseResponse.error((String)"\u5e94\u7528\u4fe1\u606f\u9519\u8bef!");
        }
        return BaseResponse.success((Object)payApply);
    }

    public PayApply getByApplyCode(String applyCode) {
        PayApply byApplyCode = this.payAppplyMapper.getByApplyCode(applyCode);
        byApplyCode.setApplyType(ApplyChannelEnum.getByApplyChannel((String)byApplyCode.getApplyType()).getDisplay());
        return byApplyCode;
    }

    public List<PayApply> queryPayApply(Long payMchId, String applyCode) {
        return this.payAppplyMapper.queryPayApplyByPayMchId(payMchId, applyCode);
    }

    public List<PayApply> queryPayApplyBetch(List<Long> payMchIds) {
        return this.payAppplyMapper.queryPayApplyBetch(payMchIds);
    }

    public BaseResponse getPayType(String merchantId, String merchantNum) {
        Long mchId = Long.parseLong(merchantId);
        List merchantPayInfoVOList = this.payMchMapper.selectPayTypeByMerchantId(mchId, merchantNum);
        return BaseResponse.success((Object)merchantPayInfoVOList);
    }
}

