/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ebaiyihui.aggregation.payment.common.model.PayBill;
import com.ebaiyihui.aggregation.payment.common.model.PayCallback;
import com.ebaiyihui.aggregation.payment.common.model.PayChan;
import com.ebaiyihui.aggregation.payment.common.model.PayMch;
import com.ebaiyihui.aggregation.payment.common.vo.PayChanResponse;
import com.ebaiyihui.aggregation.payment.common.vo.PayWayResponse;
import com.ebaiyihui.aggregation.payment.common.vo.RequestCreateOrderVo;
import com.ebaiyihui.aggregation.payment.common.vo.paybillvo.PayBillQueryVO;
import com.ebaiyihui.aggregation.payment.common.vo.paybillvo.RequesstPayBillPageVo;
import com.ebaiyihui.aggregation.payment.common.vo.paybillvo.ResponsePayBillDetailVo;
import com.ebaiyihui.aggregation.payment.server.dto.GetPayBillReqDTO;
import com.ebaiyihui.aggregation.payment.server.enums.AliPayTradeTypeEnum;
import com.ebaiyihui.aggregation.payment.server.enums.PayChanEnum;
import com.ebaiyihui.aggregation.payment.server.enums.WechatTradeTypeEnum;
import com.ebaiyihui.aggregation.payment.server.pojo.PayBillPage;
import com.ebaiyihui.aggregation.payment.server.service.BaseService;
import com.ebaiyihui.aggregation.payment.server.service.PayBillService;
import com.ebaiyihui.aggregation.payment.server.utils.StringUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PayBillServiceImpl
extends BaseService
implements PayBillService {
    private static final Logger log = LoggerFactory.getLogger(PayBillServiceImpl.class);

    public void save(PayBill payBill) {
        this.payBillMapper.insert((Object)payBill);
    }

    public void update(PayBill payBill) {
        this.payBillMapper.updateById((Object)payBill);
    }

    public ResponsePayBillDetailVo getById(Long id) {
        PayBill payBill = (PayBill)this.payBillMapper.selectById((Serializable)id);
        ResponsePayBillDetailVo responsePayBillDetailVo = new ResponsePayBillDetailVo();
        if (null == payBill) {
            return responsePayBillDetailVo;
        }
        BeanUtils.copyProperties((Object)payBill, (Object)responsePayBillDetailVo);
        PayMch payMch = this.payMchService.getByCode(payBill.getMchCode());
        PayCallback payCallback = this.payCallbackService.getByServiceCodeAndMchCode(payBill.getMchCode(), payBill.getServiceCode());
        if (null != payMch) {
            responsePayBillDetailVo.setMchName(payMch.getName());
        }
        if (null != payCallback) {
            responsePayBillDetailVo.setServiceName(payCallback.getServiceName());
        }
        return responsePayBillDetailVo;
    }

    public int delete(Long id) {
        PayBill payBill = new PayBill();
        payBill.setStatus(Integer.valueOf(-1));
        payBill.setId(id);
        return this.payBillMapper.updateById((Object)payBill);
    }

    public IPage<PayBill> getPage(RequesstPayBillPageVo requesstPayBillPageVo) {
        PayBill payBill = new PayBill();
        QueryWrapper wrapper = new QueryWrapper();
        if (null != requesstPayBillPageVo.getStatus()) {
            payBill.setStatus(requesstPayBillPageVo.getStatus());
        }
        if (StringUtil.isNotEmpty((String)requesstPayBillPageVo.getMchCode())) {
            payBill.setMchCode(requesstPayBillPageVo.getMchCode());
        }
        if (StringUtil.isNotEmpty((String)requesstPayBillPageVo.getPaychannel())) {
            payBill.setTradeChannel(requesstPayBillPageVo.getPaychannel());
        }
        wrapper.setEntity((Object)payBill);
        if (StringUtil.isNotEmpty((String)requesstPayBillPageVo.getOrderNo())) {
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.like((Object)"out_trade_no", (Object)requesstPayBillPageVo.getOrderNo())).or()).like((Object)"deal_trade_no", (Object)requesstPayBillPageVo.getOrderNo())).or()).like((Object)"trade_no", (Object)requesstPayBillPageVo.getOrderNo())).or()).like((Object)"service_code", (Object)requesstPayBillPageVo.getOrderNo());
        }
        return this.payBillMapper.selectPage((IPage)new Page((long)requesstPayBillPageVo.getPageNum(), (long)requesstPayBillPageVo.getPageSize()), (Wrapper)wrapper);
    }

    public PayBill getByDealTradeNo(String dealTradeNo) {
        PayBill wrapperPayBill = new PayBill();
        wrapperPayBill.setDealTradeNo(dealTradeNo);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)wrapperPayBill);
        wrapper.last("limit 1");
        return (PayBill)this.payBillMapper.selectOne((Wrapper)wrapper);
    }

    public PayBill getByTradeNo(String tradeNo) {
        PayBill wrapperPayBill = new PayBill();
        wrapperPayBill.setTradeNo(tradeNo);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)wrapperPayBill);
        wrapper.last("limit 1");
        return (PayBill)this.payBillMapper.selectOne((Wrapper)wrapper);
    }

    public PayBill getByOutTradeNo(String outTradeNo) {
        PayBill wrapperPayBill = new PayBill();
        wrapperPayBill.setOutTradeNo(outTradeNo);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)wrapperPayBill);
        wrapper.last("limit 1");
        return (PayBill)this.payBillMapper.selectOne((Wrapper)wrapper);
    }

    public PayBill getByCreateOrder(RequestCreateOrderVo createOrderVo) {
        PayBill payBill = new PayBill();
        payBill.setOutTradeNo(createOrderVo.getOutTradeNo());
        payBill.setDealAmount(createOrderVo.getActuallyAmount());
        payBill.setOrderAmount(createOrderVo.getTotalAmount());
        payBill.setMchCode(createOrderVo.getMchCode());
        payBill.setTradeChannel(createOrderVo.getPayChannel());
        payBill.setGoodsInfo(createOrderVo.getProductInfo());
        payBill.setTradeType(createOrderVo.getPayType());
        payBill.setStatus(Integer.valueOf(1));
        payBill.setPayNotifyUrl(createOrderVo.getPayNotifyUrl());
        payBill.setServiceCode(createOrderVo.getServiceCode());
        return payBill;
    }

    public PayBill getByOutTradeNoAndStatus(String outTradeNo, Integer status) {
        PayBill wrapperPayBill = new PayBill();
        wrapperPayBill.setOutTradeNo(outTradeNo);
        wrapperPayBill.setStatus(status);
        QueryWrapper wrapper = new QueryWrapper((Object)wrapperPayBill);
        wrapper.last("limit 1");
        return (PayBill)this.payBillMapper.selectOne((Wrapper)wrapper);
    }

    public PayBill getPayBillByTradeNoOrDealTradeNoOrOutTradeNo(GetPayBillReqDTO getPayBillReqDTO) {
        if (StringUtil.isNotEmpty((String)getPayBillReqDTO.getDealTradeNo())) {
            return this.getByDealTradeNo(getPayBillReqDTO.getDealTradeNo());
        }
        if (StringUtil.isNotEmpty((String)getPayBillReqDTO.getOutTradeNo())) {
            return this.getByOutTradeNo(getPayBillReqDTO.getOutTradeNo());
        }
        if (StringUtil.isNotEmpty((String)getPayBillReqDTO.getTradeNo())) {
            return this.getByTradeNo(getPayBillReqDTO.getTradeNo());
        }
        return null;
    }

    public PayBill getByOutRefundNo(String outRefundNo) {
        PayBill wrapperPayBill = new PayBill();
        wrapperPayBill.setOutRefundNo(outRefundNo);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntity((Object)wrapperPayBill);
        wrapper.last("limit 1");
        return (PayBill)this.payBillMapper.selectOne((Wrapper)wrapper);
    }

    public IPage<PayBill> queryPayBill(PayBillQueryVO payBillQueryVO) {
        PayBill payBill = this.queryPayBillParamCheckAndSet(payBillQueryVO);
        String timeType = this.queryPayBillTimeTypeToDealWith(payBillQueryVO);
        QueryWrapper queryWrapper = new QueryWrapper((Object)payBill);
        this.queryPayBillSqlAppend(queryWrapper, payBillQueryVO, timeType);
        IPage payBillPageParent = this.payBillMapper.selectPage((IPage)new Page((long)payBillQueryVO.getPageNum().intValue(), (long)payBillQueryVO.getPageSize().intValue()), (Wrapper)queryWrapper);
        this.tradeChannelAssembly(payBillPageParent.getRecords());
        return this.queryPayBillResultAssembly(payBillPageParent);
    }

    public void tradeChannelAssembly(List<PayBill> records) {
        records.forEach(bill -> {
            String tradeChannel = bill.getTradeChannel();
            String tradeType = bill.getTradeType();
            if (StringUtils.isNotBlank((CharSequence)tradeChannel) && StringUtils.isNotBlank((CharSequence)tradeType)) {
                if (tradeChannel.equals(PayChanEnum.WECHAT.getDisplay())) {
                    bill.setTradeType(WechatTradeTypeEnum.getPayWayNameByDisplay((String)tradeType));
                } else if (tradeChannel.equals(PayChanEnum.ALIPAY.getDisplay())) {
                    bill.setTradeType(AliPayTradeTypeEnum.getPayWayNameByDisplay((String)tradeType));
                } else if (tradeChannel.equals(PayChanEnum.HEEPAY.getDisplay())) {
                    bill.setTradeType("\u6c47\u5143\u652f\u4ed8");
                } else if (tradeChannel.equals(PayChanEnum.UNIONPAY.getDisplay())) {
                    bill.setTradeType("\u94f6\u8054\u652f\u4ed8");
                } else if (tradeChannel.equals(PayChanEnum.UNKNOWN.getDisplay()) && tradeType.equals(WechatTradeTypeEnum.JSGZHAPI.getDisplay())) {
                    bill.setTradeType(WechatTradeTypeEnum.JSGZHAPI.getPayWayName());
                }
            } else {
                log.info("\u8ba2\u5355\u53f7:[" + bill.getOutTradeNo() + "],\u8ba2\u5355\u6e20\u9053\u6216\u8005\u8ba2\u5355\u652f\u4ed8\u65b9\u5f0f\u4e3a\u7a7a");
                bill.setTradeType("\u672a\u77e5\u652f\u4ed8");
            }
        });
    }

    private PayBillPage<PayBill> queryPayBillResultAssembly(IPage<PayBill> payBillPageParent) {
        PayBillPage payBillPage = new PayBillPage();
        BeanUtils.copyProperties(payBillPageParent, (Object)payBillPage);
        payBillPage.setOrdersPrice(new BigDecimal(payBillPage.getRecords().stream().map(PayBill::getOrderAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).toString()));
        return payBillPage;
    }

    private void queryPayBillSqlAppend(QueryWrapper<PayBill> queryWrapper, PayBillQueryVO payBillQueryVO, String timeType) {
        Integer paySuccessStatus = 8;
        Integer payRefundStatus = 9;
        ArrayList<Integer> successQueryPayStatus = new ArrayList<Integer>(Arrays.asList(3, 5, 6, 7));
        ArrayList<Integer> refundQueryPayStatus = new ArrayList<Integer>(Arrays.asList(5, 6, 7));
        queryWrapper.between(StringUtils.isNotBlank((CharSequence)timeType), (Object)timeType, (Object)payBillQueryVO.getStartTime(), (Object)payBillQueryVO.getEndTime());
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.like(StringUtils.isNotBlank((CharSequence)payBillQueryVO.getOutTradeNo()), (Object)"out_trade_no", (Object)payBillQueryVO.getOutTradeNo())).or()).like(StringUtils.isNotBlank((CharSequence)payBillQueryVO.getOutTradeNo()), (Object)"deal_trade_no", (Object)payBillQueryVO.getOutTradeNo())).or()).like(StringUtils.isNotBlank((CharSequence)payBillQueryVO.getOutTradeNo()), (Object)"trade_no", (Object)payBillQueryVO.getOutTradeNo())).or()).like(StringUtils.isNotBlank((CharSequence)payBillQueryVO.getOutTradeNo()), (Object)"out_refund_no", (Object)payBillQueryVO.getOutTradeNo());
        if (Objects.nonNull(payBillQueryVO.getPayStatus()) && payBillQueryVO.getPayStatus().equals(paySuccessStatus)) {
            queryWrapper.in((Object)"status", successQueryPayStatus);
        }
        if (Objects.nonNull(payBillQueryVO.getPayStatus()) && payBillQueryVO.getPayStatus().equals(payRefundStatus)) {
            queryWrapper.in((Object)"status", refundQueryPayStatus);
        }
        queryWrapper.orderByDesc((Object)"create_time");
    }

    private String queryPayBillTimeTypeToDealWith(PayBillQueryVO payBillQueryVO) {
        String timeType = "";
        Integer payTimeMark = 1;
        if (Objects.nonNull(payBillQueryVO.getTimeType())) {
            if (payBillQueryVO.getTimeType().equals(payTimeMark)) {
                timeType = "pay_time";
            }
            Integer createTimeMark = 2;
            if (payBillQueryVO.getTimeType().equals(createTimeMark)) {
                timeType = "create_time";
            }
            Integer updateTimeMark = 3;
            if (payBillQueryVO.getTimeType().equals(updateTimeMark)) {
                timeType = "update_time";
            }
            Integer refundTimeMark = 4;
            if (payBillQueryVO.getTimeType().equals(refundTimeMark)) {
                timeType = "refund_time";
            }
        }
        return timeType;
    }

    private PayBill queryPayBillParamCheckAndSet(PayBillQueryVO payBillQueryVO) {
        ArrayList<Integer> payStatusConditions = new ArrayList<Integer>(Arrays.asList(8, 9));
        String allStatus = "ALL";
        PayBill payBill = new PayBill();
        if (StringUtils.isNotBlank((CharSequence)payBillQueryVO.getMchCode())) {
            payBill.setMchCode(payBillQueryVO.getMchCode());
        }
        if (StringUtils.isNotBlank((CharSequence)payBillQueryVO.getPayChannel()) && !payBillQueryVO.getPayChannel().equals(allStatus)) {
            payBill.setTradeChannel(payBillQueryVO.getPayChannel());
        }
        if (StringUtils.isNotBlank((CharSequence)payBillQueryVO.getPayType()) && !payBillQueryVO.getPayChannel().equals(allStatus)) {
            payBill.setTradeType(payBillQueryVO.getPayType());
        }
        if (Objects.nonNull(payBillQueryVO.getPayStatus()) && payBillQueryVO.getPayStatus() != 0 && !payStatusConditions.contains(payBillQueryVO.getPayStatus())) {
            payBill.setStatus(payBillQueryVO.getPayStatus());
        }
        return payBill;
    }

    public List<PayChanResponse> queryPayChan(String mchCode) {
        List results = this.payChanResultInit();
        List mchPayChan = this.mchChanMapper.getMchPayChan(mchCode);
        mchPayChan.forEach(chanCode -> {
            PayChanResponse payChanResponse = new PayChanResponse();
            payChanResponse.setChanCode(chanCode);
            payChanResponse.setChanName(this.queryPayChanByCode(chanCode).getName());
            results.add(payChanResponse);
        });
        return results;
    }

    public List<PayChanResponse> payChanResultInit() {
        ArrayList<PayChanResponse> results = new ArrayList<PayChanResponse>();
        PayChanResponse payChanResponse = new PayChanResponse();
        payChanResponse.setChanCode("ALL");
        payChanResponse.setChanName("\u5168\u90e8\u6e20\u9053");
        results.add(payChanResponse);
        return results;
    }

    private PayChan queryPayChanByCode(String chanCode) {
        PayChan queryPayChan = new PayChan();
        queryPayChan.setCode(chanCode);
        QueryWrapper payChanQueryWrapper = new QueryWrapper((Object)queryPayChan);
        PayChan payChan = (PayChan)this.payChanMapper.selectOne((Wrapper)payChanQueryWrapper);
        log.info(JSONObject.toJSONString((Object)payChan));
        return payChan;
    }

    public List<PayWayResponse> queryPayWay(String mchCode, String chanCode) {
        List results = this.payWayResultInit();
        List mchPayWay = this.mchChanMapper.getMchPayWay(mchCode, chanCode);
        mchPayWay.forEach(payType -> results.add(this.payWayObjectAssignment(chanCode, payType)));
        return results;
    }

    public List<PayWayResponse> payWayResultInit() {
        ArrayList<PayWayResponse> results = new ArrayList<PayWayResponse>();
        PayWayResponse payWayResponse = new PayWayResponse();
        payWayResponse.setWayCode("ALL");
        payWayResponse.setWayName("\u5168\u90e8\u6e20\u9053");
        results.add(payWayResponse);
        return results;
    }

    public PayWayResponse payWayObjectAssignment(String chanCode, String payType) {
        PayWayResponse payWayResponse = new PayWayResponse();
        payWayResponse.setWayCode(payType);
        if (chanCode.equals(PayChanEnum.WECHAT.getDisplay())) {
            payWayResponse.setWayName(WechatTradeTypeEnum.getPayWayNameByDisplay((String)payType));
        } else if (chanCode.equals(PayChanEnum.ALIPAY.getDisplay())) {
            payWayResponse.setWayName(AliPayTradeTypeEnum.getPayWayNameByDisplay((String)payType));
        } else if (chanCode.equals(PayChanEnum.HEEPAY.getDisplay())) {
            payWayResponse.setWayName("\u6c47\u5143\u652f\u4ed8");
        } else if (chanCode.equals(PayChanEnum.UNIONPAY.getDisplay())) {
            payWayResponse.setWayName("\u94f6\u8054\u652f\u4ed8");
        } else {
            payWayResponse.setWayName("\u672a\u77e5\u652f\u4ed8");
        }
        return payWayResponse;
    }
}

