/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.impl;

import com.ebaiyihui.aggregation.payment.common.model.PlatformBill;
import com.ebaiyihui.aggregation.payment.common.vo.RequestBillVo;
import com.ebaiyihui.aggregation.payment.server.enums.ContrastEnum;
import com.ebaiyihui.aggregation.payment.server.enums.OrderStatusEnum;
import com.ebaiyihui.aggregation.payment.server.mapper.PayBillMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PayMchMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.PlatformBillMapper;
import com.ebaiyihui.aggregation.payment.server.service.PlatformBillService;
import com.ebaiyihui.aggregation.payment.server.utils.DateUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlatformBillServiceImpl
implements PlatformBillService {
    private static final Logger log = LoggerFactory.getLogger(PlatformBillServiceImpl.class);
    @Autowired
    PayBillMapper payBillMapper;
    @Autowired
    PlatformBillMapper platformBillMapper;
    @Autowired
    PayMchMapper payMchMapper;

    public void savePlatformBill(RequestBillVo requestBillVo) {
        String applyCode = requestBillVo.getApplyCode();
        String mchCode = this.payMchMapper.getMchCodeByApplyCode(applyCode);
        if (mchCode == null) {
            mchCode = applyCode;
        }
        this.platformBillMapper.deleteByDateAndMchCodeAndChannel(requestBillVo.getBillDate(), mchCode, requestBillVo.getPayChannel());
        String date = DateUtils.dateToString((Date)DateUtils.stringToDate((String)"yyyyMMdd", (String)requestBillVo.getBillDate()), (String)"yyyy-MM-dd");
        String startTime = date + " 00:00:00";
        String endTime = date + " 23:59:59";
        List list = this.payBillMapper.getPayBillByMchCodeAndTradeDateAndChannel(mchCode, startTime, endTime, requestBillVo.getPayChannel());
        list.forEach(e -> {
            log.info(e.toString());
            PlatformBill platformBill = new PlatformBill();
            BeanUtils.copyProperties((Object)e, (Object)platformBill);
            platformBill.setId(null);
            platformBill.setBillId(e.getId());
            platformBill.setContrastDate(requestBillVo.getBillDate());
            platformBill.setContrastState(ContrastEnum.UN_CONTRAST.getValue());
            if (e.getStatus() == OrderStatusEnum.PAID.getValue()) {
                platformBill.setTradeState("SUCCESS");
            } else if (e.getStatus() == OrderStatusEnum.HAVE_A_REFUND.getValue()) {
                platformBill.setTradeState("REFUND");
            }
            this.platformBillMapper.insert((Object)platformBill);
        });
    }
}

