/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.aggregation.payment.server.service.reconciliation;

import com.ebaiyihui.aggregation.payment.server.constant.URLConstant;
import com.ebaiyihui.aggregation.payment.server.mapper.ReconciliationMapper;
import com.ebaiyihui.aggregation.payment.server.mapper.ReconciliationPolymerizationMapper;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.AReconciliationBill;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.IReconciliationService;
import com.ebaiyihui.aggregation.payment.server.service.reconciliation.ReconciliationTypeFactory;
import com.ebaiyihui.aggregation.payment.server.utils.UniqueKeyGenerator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ReconciliationLauncher
implements IReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationLauncher.class);
    public static final Integer MAX_RETRY_TIMES = 3;
    private Map<String, AReconciliationBill> map = ReconciliationTypeFactory.getMap();
    @Resource
    private ReconciliationMapper reconciliationMapper;
    @Resource
    private ReconciliationPolymerizationMapper reconciliationPolymerizationMapper;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private URLConstant urlConstant;

    public void launcher(String billDate) {
        this.saveChannelBill(billDate);
        this.savePlatFormBill(billDate);
        this.reconciliation(billDate);
    }

    public void polymerization(String billDate) {
        List reconciliations = this.reconciliationMapper.selectListByBillDate(billDate);
        this.reconciliationPolymerizationMapper.insertList(reconciliations);
    }

    private void saveChannelBill(String billDate) {
        this.map.entrySet().parallelStream().forEach(entry -> ((AReconciliationBill)entry.getValue()).saveChannelBill(billDate));
    }

    private void savePlatFormBill(String billDate) {
        this.map.entrySet().parallelStream().forEach(entry -> ((AReconciliationBill)entry.getValue()).savePlatformBill(billDate));
    }

    private void reconciliation(String billDate) {
        String batchNumber = UniqueKeyGenerator.generateViewId();
        this.map.entrySet().parallelStream().forEach(entry -> ((AReconciliationBill)entry.getValue()).reconciliationBill(billDate, batchNumber));
    }
}

